/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.text.IntegerDocument;
import com.sanrad.util.SrResourceBundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;

public class SrEnterTimeField
extends SrPanel
implements SrComponent {
    private SrComboBox m_units;
    private SrIntegerTextField m_inputNumber;
    private static final String DAYS = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.ENTER_TIME_COMPONENT_COMBO_UNIT_DAYS);
    private static final String HOURS = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.ENTER_TIME_COMPONENT_COMBO_UNIT_HOUR);
    private static final String MINUTES = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.ENTER_TIME_COMPONENT_COMBO_UNIT_MINUTE);
    private static final String[] UNITS = new String[]{DAYS, HOURS, MINUTES};

    public SrEnterTimeField() {
        super(new FlowLayout(0, 2, 0));
        this.initComponents();
    }

    private void initComponents() {
        this.m_units = new SrComboBox<String>((T[])UNITS);
        this.m_inputNumber = new SrIntegerTextField();
        this.add(this.m_inputNumber);
        this.add(this.m_units);
    }

    public void setDocument(IntegerDocument doc) {
        this.m_inputNumber.setDocument(doc);
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.m_units.addFocusListener(fl);
        this.m_inputNumber.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.m_units.getModel().addListDataListener((ListDataListener)l);
        }
        if (l instanceof DocumentListener) {
            this.m_inputNumber.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        long comparison;
        if (com instanceof SrEnterTimeField && (comparison = this.getTimeMinutes() - ((SrEnterTimeField)com).getTimeMinutes()) != 0L) {
            return (int)(comparison / Math.abs(comparison));
        }
        return 0;
    }

    public long getTimeMinutes() {
        String s = this.m_inputNumber.getText();
        if (s != null && s.length() > 0) {
            String unit = (String)this.m_units.getSelectedItem();
            int num = this.m_inputNumber.intValue();
            long factor = 1L;
            if (unit.equals(DAYS)) {
                factor = 1440L;
            } else if (unit.equals(HOURS)) {
                factor = 60L;
            }
            return (long)num * factor;
        }
        return 0L;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public Object getValue() {
        StringBuffer buf = new StringBuffer(this.m_inputNumber.getText());
        buf.append(" ");
        buf.append(this.m_units.getSelectedItem());
        return buf.toString();
    }

    @Override
    public boolean isComponentEnabled() {
        return this.m_inputNumber.isComponentEnabled() && this.m_units.isComponentEnabled();
    }

    @Override
    public boolean isComponentValid() {
        boolean answer = false;
        String num = this.m_inputNumber.getText();
        if (!num.equals("")) {
            answer = true;
        }
        return answer;
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.m_units.removeFocusListener(fl);
        this.m_inputNumber.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.m_units.getModel().removeListDataListener((ListDataListener)l);
        }
        if (l instanceof DocumentListener) {
            this.m_inputNumber.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.m_units.setEnableComponent(enable);
        this.m_inputNumber.setEnableComponent(enable);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            String[] arr = ((String)value).split(" ");
            this.m_inputNumber.setText(arr[0]);
            this.m_units.setSelectedItem(arr[1]);
        } else if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            if (longValue % 1440L == 0L) {
                this.m_units.setSelectedItem(DAYS);
                this.m_inputNumber.setText(String.valueOf(longValue / 1440L));
            } else if (longValue % 60L == 0L) {
                this.m_units.setSelectedItem(HOURS);
                this.m_inputNumber.setText(String.valueOf(longValue / 60L));
            } else {
                this.m_units.setSelectedItem(MINUTES);
                this.m_inputNumber.setText(String.valueOf(longValue));
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.m_inputNumber.getText());
        buf.append(" ");
        buf.append(this.m_units.getSelectedItem());
        return buf.toString();
    }

    public String getDisplayString() {
        StringBuffer buf = new StringBuffer(this.m_inputNumber.getText());
        buf.append(" ");
        buf.append(this.m_units.getSelectedItem());
        return buf.toString();
    }

    public static String getDisplayString(long timeMinutes) {
        if (timeMinutes < 0L) {
            throw new IllegalArgumentException("Non-positive time value");
        }
        StringBuffer sb = new StringBuffer();
        if (timeMinutes % 3600L == 0L) {
            sb.append(timeMinutes / 3600L);
            sb.append(' ');
            sb.append(DAYS);
        } else if (timeMinutes % 60L == 0L) {
            sb.append(timeMinutes / 60L);
            sb.append(' ');
            sb.append(HOURS);
        } else {
            sb.append(timeMinutes);
            sb.append(' ');
            sb.append(MINUTES);
        }
        return sb.toString();
    }
}

