/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SrDropdownMenu
extends JPanel
implements PropertyChangeListener {
    private static Color theBorderColor = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.DROPDOWN_MENU_LIST_BORDER_COLOR);
    private static Color theButtonFgColor = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.DROPDOWN_MENU_BUTTON_FG_COLOR);
    private static Color theButtonMouseoverFgColor = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.DROPDOWN_MENU_BUTTON_MOUSEOVER_FG_COLOR);
    private static EmptyBorder theNonItemsBorder = new EmptyBorder(0, 0, 0, 3);
    private static int thePopupAnimationDuration = 180;
    private MenuButton myMenuButton;
    private JList myMenuItemsJList;
    private DefaultListModel myListModel;
    private boolean myIsPopupVisible = false;
    private List<Action> myListActions = new ArrayList<Action>();
    private MenuListCellRenderer myListRenderer = new MenuListCellRenderer();
    private Color myListBgColor;
    private static final EmptyBorder theListCellBorder = new EmptyBorder(8, 15, 8, 20);
    private static final int theListIconTextGap = 14;
    private int myPreferredWidth;
    private Timer myPopupAnimationTimer = new Timer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SrDropdownMenu.this.myIsPopupVisible) {
                int indexOfActionToInsert = SrDropdownMenu.this.myListActions.size() - (SrDropdownMenu.this.myListModel.getSize() + this.getInvisibleActionsCount()) - 1;
                if (indexOfActionToInsert >= 0) {
                    Action actionToAdd = (Action)SrDropdownMenu.this.myListActions.get(indexOfActionToInsert);
                    if (SrDropdownMenu.this.isVisibleAction(actionToAdd)) {
                        SrDropdownMenu.this.myListModel.add(0, actionToAdd);
                    }
                } else {
                    SrDropdownMenu.this.myPopupAnimationTimer.stop();
                }
            } else if (SrDropdownMenu.this.myListModel.getSize() == 0) {
                SrDropdownMenu.this.setBorder(theNonItemsBorder);
                SrDropdownMenu.this.myPopupAnimationTimer.stop();
            } else {
                SrDropdownMenu.this.myListModel.remove(0);
            }
        }

        private int getInvisibleActionsCount() {
            int count = 0;
            for (Action a : SrDropdownMenu.this.myListActions) {
                if (SrDropdownMenu.this.isVisibleAction(a)) continue;
                ++count;
            }
            return count;
        }
    });

    public SrDropdownMenu(Action aAction) {
        if (aAction == null) {
            throw new IllegalArgumentException("aAction cannot be null");
        }
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(theNonItemsBorder);
        this.myPopupAnimationTimer.setInitialDelay(0);
        this.myMenuButton = new MenuButton(aAction);
        this.myMenuButton.putClientProperty("substancelaf.paintactive", Boolean.TRUE);
        this.myMenuButton.setIcon(ImageObject.DOWN_ARROW.getImageIcon());
        this.myMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SrDropdownMenu.this.myListActions.size() == 0) {
                    SrDropdownMenu.this.myIsPopupVisible = false;
                    return;
                }
                SrDropdownMenu.this.myPopupAnimationTimer.setDelay(thePopupAnimationDuration / (SrDropdownMenu.this.myListActions.size() - 1));
                SrDropdownMenu.this.myIsPopupVisible = !SrDropdownMenu.this.myIsPopupVisible;
                if (SrDropdownMenu.this.myIsPopupVisible) {
                    SrDropdownMenu.this.showList();
                } else {
                    SrDropdownMenu.this.hideList();
                }
            }
        });
        this.myListModel = new DefaultListModel();
        this.myMenuItemsJList = new JList(this.myListModel);
        this.myMenuItemsJList.setSelectionMode(0);
        this.myMenuItemsJList.setFocusable(false);
        this.myMenuItemsJList.setCellRenderer(this.myListRenderer);
        this.myListBgColor = this.myMenuItemsJList.getBackground();
        this.myMenuItemsJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Action selectedAction;
                    Object selection = SrDropdownMenu.this.myMenuItemsJList.getSelectedValue();
                    if (selection != null && (selectedAction = (Action)selection).isEnabled()) {
                        selectedAction.actionPerformed(new ActionEvent(SrDropdownMenu.this, 1001, (String)selectedAction.getValue("Name")));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SrDropdownMenu.this.clearSelection();
                        }
                    });
                }
            }
        });
        this.add((Component)this.myMenuButton, "North");
        this.add((Component)this.myMenuItemsJList, "South");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myListModel.size() > 0) {
            Graphics newG = g.create();
            ((Graphics2D)newG).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle listRect = this.myMenuItemsJList.getBounds();
            int listX = listRect.x;
            int listY = listRect.y;
            int listW = listRect.width;
            int listH = listRect.height;
            int halfButtonH = this.myMenuButton.getHeight() / 2;
            int roundRectHeight = listH + halfButtonH - halfButtonH / 4;
            int roundCornerR = halfButtonH * 7 / 4;
            Rectangle buttonRect = this.myMenuButton.getBounds();
            int buttonX = buttonRect.x;
            int buttonY = buttonRect.y;
            int buttonW = buttonRect.width;
            int buttonH = buttonRect.height;
            newG.setColor(theBorderColor);
            int xShift = 1;
            int yShift = 3;
            newG.fillRoundRect(buttonX + xShift, buttonY + yShift, buttonW, roundRectHeight + buttonH, roundCornerR + xShift * 4, roundCornerR + yShift * 4);
            newG.setColor(theBorderColor.brighter());
            newG.drawLine(buttonX + buttonW, buttonY + halfButtonH, buttonX + buttonW, buttonY + roundRectHeight + buttonH - roundCornerR + yShift * 4);
            newG.setColor(this.myListBgColor);
            newG.fillRect(listX, listY - halfButtonH, listW, halfButtonH);
            newG.fillRoundRect(listX, listY, listW, roundRectHeight, roundCornerR, roundCornerR);
            newG.setColor(theBorderColor);
            newG.drawRoundRect(listX, listY, listW - 1, roundRectHeight, roundCornerR, roundCornerR);
            SrDropdownMenu.drawVerticalBorderLine(newG, theBorderColor, listX, listY - halfButtonH, listY + listH);
            SrDropdownMenu.drawVerticalBorderLine(newG, theBorderColor, listX + listW - 1, listY - halfButtonH, listY + listH);
            newG.dispose();
        }
    }

    public void addMenuItem(Action aAction) {
        if (aAction == null) {
            throw new IllegalArgumentException("aAction cannot be null");
        }
        this.myListActions.add(aAction);
        this.myPreferredWidth = Math.max(this.myPreferredWidth, this.calculateCellWidth(aAction));
        aAction.removePropertyChangeListener(this);
        aAction.addPropertyChangeListener(this);
        this.myMenuButton.setPreferredSize(new Dimension(this.myPreferredWidth, this.myMenuButton.getPreferredHeight()));
        this.revalidate();
        if (this.myIsPopupVisible && this.isVisibleAction(aAction)) {
            this.myListModel.addElement(aAction);
        }
    }

    private boolean isVisibleAction(Action aAction) {
        Boolean isVisible = (Boolean)aAction.getValue("visible");
        if (isVisible != null) {
            return isVisible;
        }
        return true;
    }

    private int calculateCellWidth(Action aAction) {
        String name = (String)aAction.getValue("Name");
        Icon icon = (Icon)aAction.getValue("SmallIcon");
        Font font = this.myListRenderer.getFont();
        int stringW = name != null ? this.myListRenderer.getFontMetrics(font).stringWidth(name) : 0;
        int iconW = icon != null ? icon.getIconWidth() : 0;
        Insets insets = theListCellBorder.getBorderInsets();
        return stringW + iconW + insets.left + insets.right + 14;
    }

    public void addMenu(SrMenu aMenu) {
        if (aMenu == null) {
            throw new IllegalArgumentException("aMenu cannot be null");
        }
        MenuAction menuAction = new MenuAction(aMenu);
        this.addMenuItem(menuAction);
    }

    private void clearSelection() {
        this.myMenuItemsJList.getSelectionModel().clearSelection();
    }

    public Action getSelectedItem() {
        return (Action)this.myMenuItemsJList.getSelectedValue();
    }

    private void hideList() {
        this.myMenuButton.setIcon(ImageObject.DOWN_ARROW.getImageIcon());
        this.myPopupAnimationTimer.start();
    }

    private void showList() {
        this.myMenuButton.setIcon(ImageObject.UP_ARROW.getImageIcon());
        int halfButtonH = this.myMenuButton.getHeight() / 2;
        Insets borderInsets = theNonItemsBorder.getBorderInsets();
        borderInsets.bottom = halfButtonH;
        this.setBorder(new EmptyBorder(borderInsets));
        this.myPopupAnimationTimer.start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Action changedAction = (Action)evt.getSource();
        if ("visible".equals(evt.getPropertyName())) {
            int actionPosition = this.myListActions.indexOf(changedAction);
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                this.myListModel.remove(actionPosition);
            } else if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.myListModel.add(actionPosition, changedAction);
            } else {
                throw new IllegalArgumentException("Action " + changedAction + " contains illegal property value: " + "visible" + "=" + evt.getNewValue());
            }
        }
        this.repaint();
    }

    private static void drawVerticalBorderLine(Graphics g, Color c, int x, int y1, int y2) {
        Color prevColor = g.getColor();
        g.setColor(c);
        g.drawLine(x, y1, x, y2);
        g.setColor(prevColor);
    }

    private class MenuAction
    extends AbstractAction
    implements PropertyChangeListener {
        private AbstractAction myWrappedAction;
        private List<JMenuItem> myMenuItems = new ArrayList<JMenuItem>();

        MenuAction(SrMenu aMenu) {
            this.myWrappedAction = (AbstractAction)aMenu.getAction();
            for (int i = 0; i < aMenu.getItemCount(); ++i) {
                this.myMenuItems.add(aMenu.getItem(i));
            }
            this.updateAllProperties();
            this.myWrappedAction.addPropertyChangeListener(this);
        }

        private List<JMenuItem> getMenuItemList() {
            return Collections.unmodifiableList(this.myMenuItems);
        }

        public String toString() {
            return (String)this.myWrappedAction.getValue("Name");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.putValue(evt.getPropertyName(), evt.getNewValue());
        }

        private void updateAllProperties() {
            for (Object key : this.myWrappedAction.getKeys()) {
                this.putValue((String)key, this.myWrappedAction.getValue((String)key));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myWrappedAction.actionPerformed(e);
            JPopupMenu popup = new JPopupMenu();
            for (JMenuItem item : this.getMenuItemList()) {
                popup.add(item);
            }
            Point selectionPoint = SrDropdownMenu.this.myMenuItemsJList.indexToLocation(SrDropdownMenu.this.myMenuItemsJList.getSelectedIndex());
            Dimension popupSize = popup.getPreferredSize();
            popup.show(SrDropdownMenu.this.myMenuItemsJList, selectionPoint.x - popupSize.width, selectionPoint.y);
        }
    }

    private static class MenuListCellRenderer
    extends DefaultListCellRenderer {
        private MenuListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Action action = (Action)value;
            this.setIcon((Icon)action.getValue("SmallIcon"));
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
            this.setOpaque(false);
            this.setBorder(theListCellBorder);
            this.setIconTextGap(14);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int h = this.getHeight();
            int w = this.getWidth();
            SrDropdownMenu.drawVerticalBorderLine(g, theBorderColor, 0, 0, h);
            SrDropdownMenu.drawVerticalBorderLine(g, theBorderColor, w - 1, 0, h);
        }
    }

    private static class MenuButton
    extends SrButton {
        private MenuButton(Action aAction) {
            super(aAction);
            this.setFocusable(false);
            this.setHorizontalAlignment(2);
            this.setForeground(theButtonFgColor);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MenuButton.this.setForeground(theButtonMouseoverFgColor);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MenuButton.this.setForeground(theButtonFgColor);
                }
            });
        }

        int getPreferredHeight() {
            Font oldFont = this.getFont();
            Font newFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() + 4);
            FontMetrics fm = this.getFontMetrics(newFont);
            int textH = fm.getHeight() + fm.getMaxAscent() + fm.getMaxDescent();
            return textH;
        }
    }
}

