/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.event.ListDataListener;

public class SrComboBox<T>
extends JComboBox
implements SrComponent<T> {
    public SrComboBox() {
        this.init();
    }

    public SrComboBox(T[] items) {
        super(items);
        this.init();
    }

    public SrComboBox(List<T> items) {
        super(items.toArray());
        this.init();
    }

    protected void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public T getValue() {
        return (T)this.getSelectedItem();
    }

    @Override
    public void setValue(T value) {
        this.setSelectedItem(value);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    @Override
    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isComponentValid() {
        return true;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.getModel().addListDataListener((ListDataListener)l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.getModel().removeListDataListener((ListDataListener)l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrComboBox) {
            T mySel = this.getValue();
            Object compSel = com.getValue();
            if (mySel instanceof String && compSel instanceof String) {
                answer = ((String)mySel).compareTo((String)compSel);
            }
        }
        return answer;
    }

    public int indexOf(T item) {
        int i = this.getItemCount();
        while (i-- > 0) {
            if (!this.getItemAt(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public void refreshItem(T item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            int selected = this.getSelectedIndex();
            this.removeItemAt(index);
            this.insertItemAt(item, index);
            if (selected == index) {
                this.setSelectedIndex(index);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(dim.width + 10, dim.height);
    }
}

