/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

public class SrCheckBoxesPanel<V>
extends SrPanel
implements SrComponent {
    private ArrayList<SrCheckbox> myCheckBoxList = new ArrayList();
    private HashMap<SrCheckbox, V> myCheckBoxToValueMap = new HashMap();

    public SrCheckBoxesPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
    }

    public void addCheckBox(String text, V value, boolean state) {
        if (this.getCheckBox(text) != null) {
            return;
        }
        SrCheckbox checkBox = new SrCheckbox(text);
        checkBox.setFont(this.getFont());
        checkBox.setSelected(state);
        checkBox.setFocusPainted(false);
        this.myCheckBoxToValueMap.put(checkBox, value);
        this.myCheckBoxList.add(checkBox);
        this.add(checkBox);
    }

    public void setTitle(String title) {
        this.setBorder(new TitledBorder(null, title, 0, 0, LookAndFill.GENERAL_FONT));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myCheckBoxList != null) {
            for (SrCheckbox checkBox : this.myCheckBoxList) {
                checkBox.setFont(font);
            }
        }
    }

    public void removeCheckBox(String text) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            String name = checkBox.getText();
            if (!name.equals(text)) continue;
            this.myCheckBoxList.remove(checkBox);
            this.myCheckBoxToValueMap.remove(checkBox);
            this.remove(checkBox);
            break;
        }
    }

    public SrCheckbox getCheckBox(String aText) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            String name = checkBox.getText();
            if (!name.equals(aText)) continue;
            return checkBox;
        }
        return null;
    }

    public List<V> getSelectedValues() {
        ArrayList<V> result = new ArrayList<V>();
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            if (!checkBox.isSelected()) continue;
            result.add(this.myCheckBoxToValueMap.get(checkBox));
        }
        return result;
    }

    public Object getValue() {
        return this.getSelectedValues();
    }

    public void setValue(Object value) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEnableComponent(boolean enable) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            checkBox.setEnabled(enable);
        }
    }

    @Override
    public boolean isComponentEnabled() {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            if (!checkBox.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComponentValid() {
        return this.getValue() != null;
    }

    @Override
    public void addComponentFocusListener(FocusListener fl) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            checkBox.addComponentFocusListener(fl);
        }
    }

    @Override
    public void addComponentValidListener(EventListener l) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            checkBox.addComponentValidListener(l);
        }
    }

    @Override
    public void removeComponentFocusListener(FocusListener fl) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            checkBox.removeComponentFocusListener(fl);
        }
    }

    @Override
    public void removeComponentValidListener(EventListener l) {
        for (SrCheckbox checkBox : this.myCheckBoxList) {
            checkBox.removeComponentValidListener(l);
        }
    }

    @Override
    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrCheckBoxesPanel) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

