/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.components.SrMenuItem;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;

public class SrCheckBoxMenuItem
extends SrMenuItem {
    private static Icon SELECTED_ICON = ImageObject.OK_SIGN.getImageIcon();
    private static Icon UNSELECTED_ICON = new Icon(){

        @Override
        public int getIconHeight() {
            return SELECTED_ICON.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return SELECTED_ICON.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };

    public SrCheckBoxMenuItem() {
        this.init();
    }

    public SrCheckBoxMenuItem(String text) {
        super(text);
        this.init();
    }

    public SrCheckBoxMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
        this.init();
    }

    public SrCheckBoxMenuItem(Action a) {
        super(a);
        this.init();
    }

    private void init() {
        this.setSelected(Boolean.TRUE.equals(this.getAction().getValue("SwingSelectedKey")));
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SrCheckBoxMenuItem.this.getAction().putValue("SwingSelectedKey", !SrCheckBoxMenuItem.this.isSelected());
            }
        });
        this.getAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("SwingSelectedKey".equals(evt.getPropertyName())) {
                    SrCheckBoxMenuItem.this.setSelected((Boolean)evt.getNewValue());
                }
            }
        });
    }

    @Override
    public void setSelected(boolean aSelected) {
        this.setIcon(aSelected ? SELECTED_ICON : UNSELECTED_ICON);
        super.setSelected(aSelected);
    }
}

