/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;

public class SrActionComboBox
extends SrComboBox
implements PropertyChangeListener {
    private Object myLastRequestedSelection;
    private String myNullSelctionText;

    public SrActionComboBox() {
        this.setModel(new ActionComboBoxModel());
    }

    public SrActionComboBox(List<Action> items) {
        this.setModel(new ActionComboBoxModel(new Vector<Action>(items)));
    }

    public SrActionComboBox(Action[] items) {
        this.setModel(new ActionComboBoxModel(items));
        for (Action action : items) {
            action.addPropertyChangeListener(this);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.setRenderer(new ActionCellRenderer());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && e.getItem() instanceof Action) {
                    Action selectedAction = (Action)e.getItem();
                    ActionEvent actEvent = new ActionEvent(SrActionComboBox.this, 1001, (String)selectedAction.getValue("Name"));
                    selectedAction.actionPerformed(actEvent);
                }
            }
        });
    }

    public final void setNonSelectionText(String aText) {
        this.myNullSelctionText = aText;
    }

    @Override
    public void setSelectedItem(Object item) {
        this.myLastRequestedSelection = item;
        if (item == null) {
            super.setSelectedItem(null);
        } else if (this.isEnabledItem(item)) {
            super.setSelectedItem(item);
        }
    }

    private boolean isEnabledItem(Object item) {
        if (item instanceof Action) {
            return ((Action)item).isEnabled();
        }
        return true;
    }

    @Override
    public final void setPopupVisible(boolean v) {
        boolean isEnabledItem;
        boolean bl = isEnabledItem = this.myLastRequestedSelection != null ? this.isEnabledItem(this.myLastRequestedSelection) : true;
        if (v || isEnabledItem) {
            super.setPopupVisible(v);
        }
        this.myLastRequestedSelection = null;
    }

    public void addItem(Object anObject) {
        super.addItem(anObject);
        this.handleAddedItem(anObject);
    }

    public void insertItemAt(Object anObject, int index) {
        super.insertItemAt(anObject, index);
        this.handleAddedItem(anObject);
    }

    private void handleAddedItem(Object anObject) {
        if (anObject instanceof Action) {
            ((Action)anObject).removePropertyChangeListener(this);
            ((Action)anObject).addPropertyChangeListener(this);
        }
        if (this.isFirstAddedEnabledItem(anObject)) {
            this.setSelectedItem(anObject);
        } else if (this.isAllItemDisabled()) {
            this.setSelectedItem(null);
        }
    }

    private boolean isFirstAddedEnabledItem(Object anObject) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object currItem = this.getItemAt(i);
            if (!this.isEnabledItem(currItem) || anObject.equals(currItem)) continue;
            return false;
        }
        return this.isEnabledItem(anObject);
    }

    private boolean isAllItemDisabled() {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object currItem = this.getItemAt(i);
            if (!this.isEnabledItem(currItem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("enabled") && evt.getNewValue().equals(Boolean.FALSE) && evt.getSource().equals(super.getSelectedItem())) {
            this.setSelectedItem(null);
        }
        this.repaint();
    }

    private class ActionCellRenderer
    extends DefaultListCellRenderer {
        private ActionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText(SrActionComboBox.this.myNullSelctionText);
            }
            if (value instanceof Action) {
                Action action = (Action)value;
                this.setText((String)action.getValue("Name"));
                this.setIcon((Icon)action.getValue("SmallIcon"));
                if (!action.isEnabled()) {
                    Color disabledColor = (Color)UIManager.getLookAndFeelDefaults().get("Label.disabledForeground");
                    this.setForeground(disabledColor);
                } else {
                    this.setFont(this.getFont().deriveFont(1));
                    this.setForeground(Color.DARK_GRAY.brighter());
                }
                this.setToolTipText((String)action.getValue("ShortDescription"));
                this.setOpaque(false);
            }
            return this;
        }
    }

    private class ActionComboBoxModel
    extends DefaultComboBoxModel {
        public ActionComboBoxModel() {
        }

        public ActionComboBoxModel(Object[] items) {
            super(items);
        }

        public ActionComboBoxModel(Vector<?> v) {
            super(v);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (SrActionComboBox.this.isEnabledItem(anObject)) {
                super.setSelectedItem(anObject);
            } else {
                super.setSelectedItem(null);
            }
        }
    }
}

