/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ComponentHandler {
    private HashMap<Class<? extends JComponent>, BasicEnabledHandler> myTypeToHandlerMap = new HashMap();
    private Container myHandledComponent;
    private Container myFocuedComponent;

    public ComponentHandler(Container aHandledComponent) {
        if (aHandledComponent == null) {
            throw new IllegalArgumentException("A component must be supplied");
        }
        this.myHandledComponent = aHandledComponent;
        this.initTypesAndHandlers();
        this.storeComponentsState();
    }

    public void storeComponentsState() {
        this.mapAllComponents(this.myHandledComponent);
    }

    private void mapAllComponents(Container aComp) {
        Component[] childrenComps;
        if (aComp.hasFocus()) {
            this.myFocuedComponent = aComp;
        }
        for (Class<? extends JComponent> classKey : this.myTypeToHandlerMap.keySet()) {
            if (!classKey.isAssignableFrom(aComp.getClass())) continue;
            BasicEnabledHandler handler = this.myTypeToHandlerMap.get(classKey);
            handler.addComponentToHandle(aComp);
            return;
        }
        for (Component childComp : childrenComps = aComp.getComponents()) {
            if (!(childComp instanceof JComponent)) continue;
            this.mapAllComponents((JComponent)childComp);
        }
    }

    private void initTypesAndHandlers() {
        this.myTypeToHandlerMap.put(JLabel.class, new BasicEnabledHandler());
        this.myTypeToHandlerMap.put(JButton.class, new BasicEnabledHandler());
        this.myTypeToHandlerMap.put(JTable.class, new TableEnabledHandler());
        this.myTypeToHandlerMap.put(JComboBox.class, new ComboboxHandler());
        this.myTypeToHandlerMap.put(JList.class, new BasicEnabledHandler());
        this.myTypeToHandlerMap.put(JCheckBox.class, new CheckboxHandler());
        this.myTypeToHandlerMap.put(JTextField.class, new TextFieldHandler());
        this.myTypeToHandlerMap.put(JRadioButton.class, new BasicEnabledHandler());
    }

    public void clearAllSelections() {
        this.clearAllSelections(null);
    }

    public void clearAllSelections(Class<? extends JComponent> aComponentType) {
        for (Class<? extends JComponent> classKey : this.myTypeToHandlerMap.keySet()) {
            if (aComponentType != null && !classKey.isAssignableFrom(aComponentType)) continue;
            BasicEnabledHandler handler = this.myTypeToHandlerMap.get(classKey);
            handler.clearSelection();
        }
    }

    public void setAllEnabled(boolean enabled) {
        for (BasicEnabledHandler handler : this.myTypeToHandlerMap.values()) {
            handler.setEnabled(enabled);
        }
    }

    public void revertAll() {
        for (BasicEnabledHandler handler : this.myTypeToHandlerMap.values()) {
            handler.revertAll();
        }
        if (this.myFocuedComponent instanceof JComponent) {
            ((JComponent)this.myFocuedComponent).grabFocus();
        }
    }

    public void revertEnabledState() {
        for (BasicEnabledHandler handler : this.myTypeToHandlerMap.values()) {
            handler.revertEnabledState();
        }
    }

    private static class TableEnabledHandler
    extends BasicEnabledHandler<JTable> {
        private TableEnabledHandler() {
        }

        @Override
        void addComponentToHandle(JTable comp) {
            this.myCompToStateMap.put(comp, comp.getRowSelectionAllowed());
        }

        @Override
        void setEnabled(boolean enabled) {
            for (JTable table : this.getComponents()) {
                table.setRowSelectionAllowed(false);
            }
        }

        @Override
        void revertEnabledState() {
            for (JTable table : this.getComponents()) {
                table.setRowSelectionAllowed((Boolean)this.myCompToStateMap.get(table));
            }
        }

        @Override
        void clearSelection() {
            for (JTable table : this.getComponents()) {
                table.clearSelection();
            }
        }
    }

    private static class TextFieldHandler
    extends BasicEnabledHandler<JTextField> {
        HashMap<JTextField, Boolean> myFieldToEditableMap = new HashMap();

        private TextFieldHandler() {
        }

        @Override
        void addComponentToHandle(JTextField comp) {
            super.addComponentToHandle(comp);
            this.myFieldToEditableMap.put(comp, comp.isEditable());
        }

        @Override
        void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (JTextField comp : this.myFieldToEditableMap.keySet()) {
                comp.setEditable(enabled);
            }
        }

        @Override
        void revertEnabledState() {
            super.revertEnabledState();
            for (JTextField comp : this.myFieldToEditableMap.keySet()) {
                comp.setEditable(this.myFieldToEditableMap.get(comp));
            }
        }

        @Override
        void clearSelection() {
            for (JTextField comp : this.myFieldToEditableMap.keySet()) {
                comp.setSelectionStart(0);
                comp.setSelectionEnd(0);
            }
        }
    }

    private static class ComboboxHandler
    extends BasicEnabledHandler<JComboBox> {
        private ComboboxHandler() {
        }

        @Override
        void clearSelection() {
            for (JComboBox comp : this.getComponents()) {
                comp.setSelectedItem(null);
            }
        }
    }

    private static class CheckboxHandler
    extends BasicEnabledHandler<JCheckBox> {
        private CheckboxHandler() {
        }

        @Override
        void clearSelection() {
            for (JCheckBox comp : this.getComponents()) {
                comp.setSelected(false);
            }
        }
    }

    private static class BasicEnabledHandler<T extends Container> {
        protected HashMap<T, Boolean> myCompToStateMap = new HashMap();

        private BasicEnabledHandler() {
        }

        void addComponentToHandle(T comp) {
            this.myCompToStateMap.put(comp, ((Component)comp).isEnabled());
        }

        List<T> getComponents() {
            return new ArrayList<T>(this.myCompToStateMap.keySet());
        }

        void setEnabled(boolean enabled) {
            for (Container comp : this.getComponents()) {
                comp.setEnabled(enabled);
            }
        }

        void revertAll() {
            this.revertEnabledState();
        }

        void revertEnabledState() {
            for (Container comp : this.getComponents()) {
                comp.setEnabled(this.myCompToStateMap.get(comp));
            }
        }

        void clearSelection() {
        }
    }
}

