/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SrLineBorder
extends AbstractBorder {
    private static final int theTopSideIndex = 0;
    private static final int theLeftSideIndex = 1;
    private static final int theBottomSideIndex = 2;
    private static final int theRightSideIndex = 3;
    private Color[] myColors;
    private int[] myThickness;

    public SrLineBorder(int top, int left, int bottom, int right, Color ... aColors) {
        this.myThickness = new int[]{top, left, bottom, right};
        this.myColors = new Color[4];
        for (int i = 0; i < this.myColors.length; ++i) {
            this.myColors[i] = aColors[Math.min(i, aColors.length - 1)];
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        g.setColor(this.myColors[0]);
        for (i = 0; i < this.myThickness[0]; ++i) {
            g.drawLine(x, y + i, x + width - 1, y + i);
        }
        g.setColor(this.myColors[2]);
        for (i = 0; i < this.myThickness[2]; ++i) {
            g.drawLine(x, y + height - 1 - i, x + width - 1, y + height - 1 - i);
        }
        g.setColor(this.myColors[1]);
        for (i = 0; i < this.myThickness[1]; ++i) {
            g.drawLine(x + i, y, x + i, y + height - 1);
        }
        g.setColor(this.myColors[3]);
        for (i = 0; i < this.myThickness[3]; ++i) {
            g.drawLine(x + width - 1 - i, y, x + width - 1 - i, y + height - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.myThickness[0], this.myThickness[1], this.myThickness[2], this.myThickness[3]);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.myThickness[0];
        insets.left = this.myThickness[1];
        insets.bottom = this.myThickness[2];
        insets.right = this.myThickness[3];
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

