/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.actions;

import com.sanrad.swing.actions.SrAction;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public interface View<A> {
    public Collection<A> getValue();

    public void addListener(SrAction<A, ?> var1);

    public void removeListener(SrAction<A, ?> var1);

    public static class SingleElementView<T>
    implements View<T> {
        private T myElement;

        public SingleElementView(T aElement) {
            this.myElement = aElement;
        }

        @Override
        public void addListener(SrAction<T, ?> action) {
        }

        @Override
        public Collection<T> getValue() {
            return Collections.singletonList(this.myElement);
        }

        @Override
        public void removeListener(SrAction<T, ?> action) {
        }
    }

    public static class ChangeComponentListener
    implements ChangeListener {
        private SrAction<?, ?> myAction;

        public ChangeComponentListener(SrAction aAction) {
            this.myAction = aAction;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.myAction.updateEnabled();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChangeComponentListener) {
                return this.myAction.equals(((ChangeComponentListener)obj).myAction);
            }
            return false;
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }

    public static class ToggleButtonListener
    implements ItemListener {
        private SrAction<?, ?> myAction;

        public ToggleButtonListener(SrAction aAction) {
            this.myAction = aAction;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.myAction.updateEnabled();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ToggleButtonListener) {
                return this.myAction.equals(((ToggleButtonListener)obj).myAction);
            }
            return false;
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }

    public static class ViewTextListener
    implements DocumentListener {
        private SrAction<?, ?> myAction;

        public ViewTextListener(SrAction anAction) {
            this.myAction = anAction;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.myAction.updateEnabled();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.myAction.updateEnabled();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.myAction.updateEnabled();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ViewTextListener) {
                return this.myAction.equals(((ViewTextListener)obj).myAction);
            }
            return false;
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }

    public static class ViewTreeSelectionListener
    implements TreeSelectionListener {
        private SrAction<?, ?> myAction;

        public ViewTreeSelectionListener(SrAction<?, ?> aAction) {
            this.myAction = aAction;
        }

        @Override
        public void valueChanged(TreeSelectionEvent _) {
            this.myAction.updateEnabled();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ViewTreeSelectionListener) {
                return this.myAction.equals(((ViewTreeSelectionListener)obj).myAction);
            }
            return false;
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }

    public static class ViewListSelectionListener
    implements ListSelectionListener {
        private SrAction<?, ?> myAction;

        public ViewListSelectionListener(SrAction aAction) {
            this.myAction = aAction;
        }

        @Override
        public void valueChanged(ListSelectionEvent _) {
            this.myAction.updateEnabled();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ViewListSelectionListener) {
                return this.myAction.equals(((ViewListSelectionListener)obj).myAction);
            }
            return false;
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }
}

