/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.actions;

import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeView<A>
implements View<A> {
    private TreeSelectionModel myModel;
    public Class<A> myCls;

    public TreeView(JTree tree, Class<A> cls) {
        this(tree.getSelectionModel(), cls);
    }

    public TreeView(TreeSelectionModel model, Class<A> cls) {
        this.myModel = model;
        this.myCls = cls;
    }

    @Override
    public Collection<A> getValue() {
        ArrayList<A> retVal = new ArrayList<A>();
        TreePath[] selectionPaths = this.myModel.getSelectionPaths();
        if (selectionPaths == null) {
            return retVal;
        }
        for (TreePath path : selectionPaths) {
            Object value = path.getLastPathComponent();
            if (!this.myCls.isInstance(value)) continue;
            retVal.add(this.myCls.cast(value));
        }
        return retVal;
    }

    @Override
    public void addListener(SrAction<A, ?> action) {
        this.myModel.addTreeSelectionListener(new View.ViewTreeSelectionListener(action));
    }

    @Override
    public void removeListener(SrAction<A, ?> action) {
        this.myModel.removeTreeSelectionListener(new View.ViewTreeSelectionListener(action));
    }
}

