/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.actions;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class SrAction<A, V>
extends AbstractAction {
    public static final SrResourceBundle BUNDLE = SrResourceBundle.getInstance("product_client", Locale.US);
    public static SrResourceBundle CONSTANSTS_BUNDLE = SrResourceBundle.getInstance("constants", Locale.US);
    private static final String DURING_ACTION_TOOLTIP = BUNDLE.getString(SrDefaultUIBundleKeys.CLIENT_GUI_ACTIONS_DURING_ACTION);
    protected static final String CONTEXT_MISMATCH_TOOLTIP = BUNDLE.getString(SrDefaultUIBundleKeys.CLIENT_GUI_ACTIONS_CONTEXT_MISMATCH);
    private static final String MULTIPLE_SELECTION_TOOLTIP = BUNDLE.getString(SrDefaultUIBundleKeys.CLIENT_GUI_ACTIONS_MULTIPLE_SELECTION);
    public static final String UNEXPECTED_ERROR_MESSAGE = BUNDLE.getString(SrDefaultUIBundleKeys.UNEXPECTED_ERROR_MESSAGE);
    public static final SrEventListenerManager theActionStartStop = new SrEventListenerManager(){

        @Override
        public Collection<EventListener> getListeners(Class<? extends EventListener> aClass) {
            Collection<EventListener> retVal = super.getListeners(aClass);
            if (aClass.equals(SrAction.class)) {
                theLogger.info(SrLogCategories.INFORMATIVE, "Action number is ", retVal.size());
            }
            return retVal;
        }
    };
    public static final String VISIBLE = "visible";
    public static final String ENABLED = "enabled";
    private static boolean theIsDuringAction = false;
    private static SrLogger theLogger = SrLogger.getLogger();
    protected View<A> myView;
    private SrEventListenerManager myResultListeners = new SrEventListenerManager();
    private String myEnabledTooltip = null;
    private String myConfirmationString = null;
    private String myConfirmationTitle = null;
    private boolean myIsSingleSelection;
    public static final SrEventListenerManager.Informer<OperationController, SrActionEvent> actionCompletionInformer = new SrEventListenerManager.Informer<OperationController, SrActionEvent>(){

        @Override
        public void inform(OperationController controller, SrActionEvent evt) {
            Collection futures = (Collection)evt.getSource();
            for (SrFuture future : futures) {
                try {
                    future.get();
                }
                catch (SrExecutionException e) {
                    String errorMessage;
                    Set<Throwable> causes = e.getCauses();
                    SrExecutionException cause = causes.isEmpty() ? e : causes.iterator().next();
                    String string = errorMessage = e.containsNonSrException() ? UNEXPECTED_ERROR_MESSAGE : e.getMessage();
                    if (cause instanceof RemoteException || cause instanceof NotBoundException) {
                        String vendor = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_NAME);
                        errorMessage = "Server connection failure.\nPlease make sure your server is up and running and that its hostname and port are correct.\nIf this is the case, please contact " + vendor + " Technical Support.";
                    } else if (cause instanceof RejectedExecutionException) {
                        errorMessage = "The server has closed a connection with the client. Restart the client application to reconnect.";
                    } else if (cause instanceof ActionValidationException) {
                        errorMessage = ((Throwable)cause).getMessage();
                    }
                    theLogger.error(SrLogCategories.ERROR, e, errorMessage);
                    controller.fail(errorMessage);
                    return;
                }
                catch (InterruptedException e) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "A task " + future.getDescription() + " was interrupted");
                    controller.fail(evt.getAction().getInterruptionMessage());
                    return;
                }
            }
            controller.success(evt.getAction());
        }
    };
    public static final SrEventListenerManager.Informer<OperationController, EventObject> actionInProcessInformer = new SrEventListenerManager.Informer<OperationController, EventObject>(){

        @Override
        public void inform(OperationController l, EventObject e) {
            l.inProcess("");
        }
    };
    public static final SrEventListenerManager.Informer<SrAction, EventObject> theUpdateInformer = new SrEventListenerManager.Informer<SrAction, EventObject>(){

        @Override
        public void inform(SrAction listener, EventObject e) {
            listener.updateEnabled();
        }
    };
    private boolean myIsShouldBlockActions;

    public static Window getConfirmationOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }

    public SrAction() {
        this(null, null, null, false, true);
    }

    public SrAction(View<A> view) {
        this(null, null, view);
    }

    public SrAction(String name, View<A> view) {
        this(name, null, view);
    }

    public SrAction(String name, Icon icon, View<A> view) {
        this(name, icon, view, false, true);
    }

    public SrAction(View<A> view, boolean singleSelection) {
        this(null, null, view, singleSelection, true);
    }

    public SrAction(String name, View<A> view, boolean singleSelection) {
        this(name, null, view, singleSelection, true);
    }

    public SrAction(String aName, Icon aIcon, View<A> aView, boolean aIsSingleSelection, boolean aIsShouldBlockActions) {
        this.initActionParameters(aName, aIcon, aView, aIsSingleSelection, aIsShouldBlockActions);
    }

    protected void initActionParameters(String aName, Icon aIcon, View<A> aView, boolean aIsSingleSelection, boolean aIsShouldBlockActions) {
        if (aName != null) {
            this.setName(aName);
        }
        if (aIcon != null) {
            this.setIcon(aIcon);
        }
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.setVisible(true);
        this.myView = aView;
        this.myIsSingleSelection = aIsSingleSelection;
        this.myIsShouldBlockActions = aIsShouldBlockActions;
        if (this.myView != null) {
            this.myView.addListener(this);
        }
        theActionStartStop.add(this);
        this.updateEnabled();
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setName(String aName, String aEnabledTooltip) {
        this.setName(aName);
        this.setEnabledTooltip(aEnabledTooltip);
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    private void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setEnabledTooltip(String tooltip) {
        this.myEnabledTooltip = tooltip;
        if (this.isEnabled()) {
            this.putValue("ShortDescription", tooltip);
        }
    }

    public void addControllerAsListener(OperationController controller) {
        this.myResultListeners.add(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        theLogger.info(SrLogCategories.INFORMATIVE, "Start of actionPerformed() on action ", this.getClass());
        String confirmationString = this.getConfirmationString();
        if (confirmationString != null && JOptionPane.showConfirmDialog(SrAction.getConfirmationOwner(), confirmationString, this.myConfirmationTitle, 0) != 0) {
            return;
        }
        if (this.myIsShouldBlockActions) {
            SrAction.blockActions();
        }
        Collection<SrFuture<V>> futures = null;
        try {
            Collection<A> arguments = this.myView == null ? null : this.myView.getValue();
            this.myResultListeners.fireEvent(OperationController.class, new EventObject(this), actionInProcessInformer);
            futures = this.baseActionPerformed(arguments);
            theLogger.logAndAssert(SrLogCategories.ERROR, futures != null, new Object[]{this.getClass() + ".derivedActionPerformed() returned null"});
        }
        catch (Throwable t) {
            t.printStackTrace();
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, t);
        }
        finally {
            if (futures == null || futures.isEmpty()) {
                SrAction.actionFinished(Collections.singleton(new CompleteFuture("SrAction.derivedActionPerformed, Null Or Empty Future")), this, this.myResultListeners, this.myIsShouldBlockActions);
                return;
            }
        }
        SrAction.waitAndReleaseActions(futures, this.myResultListeners, this, this.myIsShouldBlockActions);
        theLogger.info(SrLogCategories.INFORMATIVE, "Finish of actionPerformed() on action ", this.getClass());
    }

    public static <V> void waitAndReleaseActions(final Collection<? extends SrFuture<V>> future, final SrEventListenerManager resultListeners, final SrAction<?, V> action, final boolean aIsReleaseAction) {
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        Object actionName = action == null ? null : action.getValue("Name");
                        theLogger.info(SrLogCategories.INFORMATIVE, "Start of actionFinished() on action ", actionName);
                        SrAction.actionFinished(future, action, resultListeners, aIsReleaseAction);
                        theLogger.info(SrLogCategories.INFORMATIVE, "Finish of actionFinished() on action ", actionName);
                    }
                });
            }
        }, future);
    }

    protected void onActionFinished(Collection<? extends SrFuture<V>> future) {
    }

    private static <V> void actionFinished(Collection<? extends SrFuture<V>> future, SrAction<?, V> action, SrEventListenerManager resultListeners, boolean aShouldReleaseActions) {
        if (action != null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Action ", action.getClass(), " finished");
            action.onActionFinished(future);
        }
        if (aShouldReleaseActions) {
            SrAction.releaseActions();
        }
        resultListeners.fireEvent(OperationController.class, new SrActionEvent(action, future), actionCompletionInformer);
    }

    protected static void releaseActions() {
        SrAction.setCursorOnAllOpenWindows(null);
        theIsDuringAction = false;
        SrAction.updateAllActions();
    }

    public abstract Collection<? extends SrFuture<V>> baseActionPerformed(Collection<A> var1);

    private String validate() {
        if (theIsDuringAction) {
            return DURING_ACTION_TOOLTIP;
        }
        if (this.myView != null) {
            String contextMismatchTooltip;
            Collection<A> arg = this.myView.getValue();
            if (arg.isEmpty() && (contextMismatchTooltip = this.getContextMismatchTooltip()) != null) {
                return contextMismatchTooltip;
            }
            if (this.myIsSingleSelection && arg.size() > 1) {
                return this.getMultipleSelectionTooltip();
            }
        }
        return this.derivedUpdateEnabled();
    }

    public String getMultipleSelectionTooltip() {
        return MULTIPLE_SELECTION_TOOLTIP;
    }

    protected String getContextMismatchTooltip() {
        return CONTEXT_MISMATCH_TOOLTIP;
    }

    protected boolean shouldBeVisible() {
        return true;
    }

    public void updateEnabled() {
        boolean visible = this.shouldBeVisible();
        this.setVisible(visible);
        if (!visible) {
            return;
        }
        String errorTooltip = this.validate();
        theLogger.logAndAssert(SrLogCategories.ERROR, !"".equals(errorTooltip), new Object[]{"validate() returned empty string, Action is ", this.getValue("Name"), ": " + this.getClass()});
        super.setEnabled(errorTooltip == null);
        String realTooltip = !this.isEnabled() ? errorTooltip : this.myEnabledTooltip;
        this.putValue("ShortDescription", realTooltip);
    }

    protected abstract String derivedUpdateEnabled();

    public void setConfirmationString(String string) {
        this.myConfirmationString = string;
    }

    protected String getConfirmationString() {
        return this.myConfirmationString;
    }

    public void setConfirmationTitle(String title) {
        this.myConfirmationTitle = title;
    }

    private void setVisible(boolean b) {
        this.putValue(VISIBLE, b);
    }

    protected static void blockActions() {
        theIsDuringAction = true;
        SrAction.updateAllActions();
        SrAction.setCursorOnAllOpenWindows(Cursor.getPredefinedCursor(3));
    }

    private static void setCursorOnAllOpenWindows(Cursor aCursor) {
        for (Frame frame : Frame.getFrames()) {
            SrAction.setCursorRecursive(frame, aCursor);
        }
    }

    protected static void setCursorRecursive(Window aWindow, Cursor aCursor) {
        aWindow.setCursor(aCursor);
        for (Window window : aWindow.getOwnedWindows()) {
            SrAction.setCursorRecursive(window, aCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> void blockActions(Collection<? extends SrFuture<V>> future, OperationController controller) {
        try {
            SrAction.blockActions();
        }
        finally {
            SrAction.waitAndInvokeController(future, controller, true);
        }
    }

    public static <V> void waitAndInvokeController(Collection<? extends SrFuture<V>> future, OperationController controller) {
        SrAction.waitAndInvokeController(future, controller, false);
    }

    private static <V> void waitAndInvokeController(Collection<? extends SrFuture<V>> future, OperationController controller, boolean aIsReleaseActions) {
        SrEventListenerManager listeners = new SrEventListenerManager();
        listeners.add(controller);
        SrAction.waitAndReleaseActions(future, listeners, null, aIsReleaseActions);
    }

    public static void updateAllActions() {
        theActionStartStop.fireEvent(SrAction.class, new EventObject(SrAction.class), theUpdateInformer);
    }

    protected String getInterruptionMessage() {
        return "The task was interrupted";
    }

    protected static final boolean isSuccessful(Collection<? extends SrFuture> aFutures, int expectedSize) {
        if (aFutures.size() != expectedSize) {
            return false;
        }
        for (SrFuture srFuture : aFutures) {
            try {
                srFuture.get();
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return true;
    }

    public static class ActionValidationException
    extends Exception {
        public ActionValidationException(String aMsg) {
            super(aMsg);
        }
    }

    private static class SrActionEvent
    extends EventObject {
        private SrAction myAction;

        public <V> SrActionEvent(SrAction aAction, Collection<? extends SrFuture<V>> future) {
            super(future);
            this.myAction = aAction;
        }

        public SrAction getAction() {
            return this.myAction;
        }
    }
}

