/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrBorderedPanel;
import com.sanrad.swing.SrUnderlinedLabelField;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrLabelField;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TransientWindow
extends JWindow {
    private static final int FADE_OUT = -1;
    private static final int FADE_IN = 1;
    private static final int MAX_ALPHA = 255;
    private static final int MIN_ALPHA = 0;
    private static final int MAX_TEXT_LENGTH = 200;
    private static int theNumberOfVisibleTransientWindows = 0;
    private static int theSumOfVisibleWindowsHeight = 0;
    private static final int theFadingDelay = 10;
    private Timer myStayAndFadeOutTimer;
    private Timer myFadeInTimer;
    private AWTEventListener myAWTListener;
    private ActionListener myListener = null;
    private SrBorderedPanel myCenterPanel = new SrBorderedPanel();
    private SrButton myCloseButton = new SrButton("");
    private SrLabelField myIcon;
    private SrLabelField myTitleBarIcon = new SrLabelField();
    private SrLabelField myTypeIcon;
    private ImageIcon myIconImage;
    private ImageIcon myTypeIconImage;
    private ImageIcon myCloseButtonImage;
    private ImageIcon myCloseButtonMouseOverImage;
    private ImageIcon myCloseButtonPressedImage;
    private SrUnderlinedLabelField myLinkableFadingLabel = new SrUnderlinedLabelField();
    private SrUnderlinedLabelField myAdditionalFadingLabel = new SrUnderlinedLabelField();
    private Color myLinkEnabledColor;
    private Color myLinkDisabledColor;
    private int myAlpha;
    private int myFadeValue;
    private long myStartTime;
    private int myDuration;
    private MouseEvent myMousePressedMouseEvent;
    private Point myLocation;

    public TransientWindow(JFrame owner, String linkableMsg, String additionalMsg, int aDelay) {
        this(owner, linkableMsg, additionalMsg, aDelay, null);
    }

    public TransientWindow(JFrame owner, String linkableMsg, String additionalMsg, int aDelay, ActionListener listener) {
        super(owner);
        this.myDuration = aDelay;
        this.myStartTime = System.currentTimeMillis();
        final int fadeInDuration = 255 / Math.abs(1) * 10;
        final int fadeOutDuration = 255 / Math.abs(-1) * 10;
        final int fadeOutInitialDelay = aDelay - fadeInDuration - fadeOutDuration;
        this.myAWTListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 504) {
                    if (event.getSource() == TransientWindow.this || TransientWindow.this.isAncestorOf((Component)event.getSource())) {
                        TransientWindow.this.myStayAndFadeOutTimer.stop();
                        TransientWindow.this.myFadeInTimer.stop();
                        TransientWindow.this.setFullOpacity();
                    }
                } else if (event.getID() == 505 && (event.getSource() == TransientWindow.this || TransientWindow.this.isAncestorOf((Component)event.getSource()))) {
                    TransientWindow.this.myStartTime = System.currentTimeMillis() - (long)fadeInDuration;
                    TransientWindow.this.myStayAndFadeOutTimer.restart();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAWTListener, 16L);
        this.myStayAndFadeOutTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long timeLeft = TransientWindow.this.myStartTime + (long)TransientWindow.this.myDuration - System.currentTimeMillis();
                TransientWindow.this.myFadeValue = TransientWindow.this.calculateNextFadeValue(timeLeft, 0, -1);
                TransientWindow.this.changeAlpha(255);
                if (TransientWindow.this.myAlpha <= 0) {
                    TransientWindow.this.dispose();
                }
            }
        });
        this.myStayAndFadeOutTimer.setInitialDelay(fadeOutInitialDelay);
        this.myFadeInTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long timeLeft = TransientWindow.this.myStartTime + (long)TransientWindow.this.myDuration - (long)fadeOutInitialDelay - (long)fadeOutDuration - System.currentTimeMillis();
                TransientWindow.this.myFadeValue = TransientWindow.this.calculateNextFadeValue(timeLeft, 255, 1);
                TransientWindow.this.changeAlpha(255);
                if (TransientWindow.this.myAlpha >= 255) {
                    TransientWindow.this.myFadeInTimer.stop();
                    TransientWindow.this.myStayAndFadeOutTimer.start();
                }
            }
        });
        this.myFadeInTimer.setInitialDelay(0);
        this.myLinkableFadingLabel.setBottomInset(3);
        this.myLinkableFadingLabel.setUnderlinedText(false);
        this.initLabel(this.myLinkableFadingLabel, linkableMsg);
        this.initLabel(this.myAdditionalFadingLabel, additionalMsg);
        this.myAdditionalFadingLabel.setUnderlinedText(false);
        this.myTitleBarIcon.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                TransientWindow.this.myLocation = TransientWindow.this.getLocation(TransientWindow.this.myLocation);
                int x = ((TransientWindow)TransientWindow.this).myLocation.x - TransientWindow.this.myMousePressedMouseEvent.getX() + me.getX();
                int y = ((TransientWindow)TransientWindow.this).myLocation.y - TransientWindow.this.myMousePressedMouseEvent.getY() + me.getY();
                TransientWindow.this.setLocation(x, y);
            }
        });
        ((JPanel)this.getContentPane()).setOpaque(false);
        this.myCloseButton.setBorder(BorderFactory.createEmptyBorder());
        this.myCloseButton.setOpaque(false);
        this.myIcon = new SrLabelField(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (TransientWindow.this.myIconImage != null) {
                    g.drawImage(TransientWindow.this.myIconImage.getImage(), 0, 0, TransientWindow.this.myCenterPanel.getBackground(), this);
                }
            }
        };
        this.myTypeIcon = new SrLabelField(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (TransientWindow.this.myTypeIconImage != null) {
                    g.drawImage(TransientWindow.this.myTypeIconImage.getImage(), 0, 0, TransientWindow.this.myCenterPanel.getBackground(), this);
                }
            }
        };
        this.setCloseButton();
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.addActionListener(listener);
        this.setAlwaysOnTop(true);
    }

    private int calculateNextFadeValue(long aTimeLeft, int finalAlpha, int fadeDelta) {
        return (int)((long)(finalAlpha - this.myAlpha) - (aTimeLeft / 10L - 1L) * (long)fadeDelta);
    }

    private void initLabel(SrUnderlinedLabelField label, String text) {
        label.setText(text);
        this.setMaximalPreferredWidth(label);
    }

    private void setMaximalPreferredWidth(SrUnderlinedLabelField label) {
        label.setPreferredSize(null);
        Dimension uiPreferredSize = label.getPreferredSize();
        if (uiPreferredSize.width > 200) {
            label.setToolTipText(label.getText());
        }
        label.setPreferredSize(new Dimension(200, uiPreferredSize.height));
    }

    protected void setTitleBar(ImageIcon icon) {
        this.myTitleBarIcon.setIcon(icon);
    }

    private boolean isLinkEnabled() {
        return this.myListener != null;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method should be called only by Event Dispatcher Thread");
        }
        if (!this.isVisible() && visible) {
            if (theNumberOfVisibleTransientWindows == 0) {
                theSumOfVisibleWindowsHeight = 0;
            }
            ++theNumberOfVisibleTransientWindows;
            Font font = this.myAdditionalFadingLabel.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            int height = fm.getHeight();
            this.myAdditionalFadingLabel.setPreferredSize(new Dimension(200, height));
            this.pack();
            Point pos = this.getPositionOnScreen();
            this.setLocation(pos);
            this.setNoneOpacity();
            this.myFadeInTimer.start();
            theSumOfVisibleWindowsHeight += this.getHeight();
        }
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (theNumberOfVisibleTransientWindows > 0) {
            --theNumberOfVisibleTransientWindows;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAWTListener);
        this.myFadeInTimer.stop();
        this.myStayAndFadeOutTimer.stop();
    }

    private void changeForegroundAlpha(Component aComp) {
        int newAlpha = aComp.getForeground().getAlpha() + this.myFadeValue;
        this.setForegroundAlpha(aComp, newAlpha);
    }

    private void changeBackgroundAlpha(Component aComp) {
        int newAlpha = aComp.getBackground().getAlpha() + this.myFadeValue;
        this.setBackgroundAlpha(aComp, newAlpha);
    }

    private void setForegroundAlpha(Component aComp, int aAlpha) {
        Color fg = aComp.getForeground();
        aComp.setForeground(this.changeColorAlpha(fg, aAlpha));
    }

    private void setBackgroundAlpha(Component aComp, int aAlpha) {
        Color bg = aComp.getBackground();
        aComp.setBackground(this.changeColorAlpha(bg, aAlpha));
    }

    private Color changeColorAlpha(Color aColor, int aAlpha) {
        if (aAlpha > 255) {
            aAlpha = 255;
        }
        if (aAlpha < 0) {
            aAlpha = 0;
        }
        return new Color(aColor.getRed(), aColor.getGreen(), aColor.getBlue(), aAlpha);
    }

    private void setFullOpacity() {
        this.myAlpha = 255;
        this.setBackgroundAlpha(this.myCenterPanel, 255);
        this.setForegroundAlpha(this.myLinkableFadingLabel, 255);
        this.setForegroundAlpha(this.myAdditionalFadingLabel, 255);
        Color borderColor = this.myCenterPanel.getBorderColor();
        if (borderColor != null) {
            this.setBorderColor(this.changeColorAlpha(borderColor, 255));
        }
    }

    private void setNoneOpacity() {
        this.myAlpha = 0;
        this.setBackgroundAlpha(this.myCenterPanel, 0);
        this.setForegroundAlpha(this.myLinkableFadingLabel, 0);
        this.setForegroundAlpha(this.myAdditionalFadingLabel, 0);
        Color borderColor = this.myCenterPanel.getBorderColor();
        if (borderColor != null) {
            this.setBorderColor(this.changeColorAlpha(borderColor, 0));
        }
    }

    protected void changeAlpha(int maxAlpha) {
        Color background = this.myCenterPanel.getBackground();
        this.myAlpha = background.getAlpha();
        if (this.myAlpha < maxAlpha && this.myAlpha > 0 || this.myAlpha == maxAlpha && this.myFadeValue < 0 || this.myAlpha == 0 && this.myFadeValue > 0) {
            this.myAlpha += this.myFadeValue;
            if (this.myAlpha > 255) {
                this.myAlpha = 255;
            }
            if (this.myAlpha < 0) {
                this.myAlpha = 0;
            }
            this.changeBackgroundAlpha(this.myCenterPanel);
            this.changeForegroundAlpha(this.myLinkableFadingLabel);
            this.changeForegroundAlpha(this.myAdditionalFadingLabel);
            Color borderColor = this.myCenterPanel.getBorderColor();
            if (borderColor != null) {
                this.setBorderColor(this.changeColorAlpha(borderColor, borderColor.getAlpha() + this.myFadeValue));
            }
        }
    }

    private void addActionListener(final ActionListener listener) {
        this.myListener = listener;
        if (listener == null) {
            if (this.myLinkDisabledColor != null) {
                this.myLinkableFadingLabel.setForeground(this.myLinkDisabledColor);
            }
            return;
        }
        if (this.myLinkEnabledColor != null) {
            this.myLinkableFadingLabel.setForeground(this.myLinkEnabledColor);
        }
        this.myLinkableFadingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TransientWindow.this.isLinkEnabled()) {
                    listener.actionPerformed(new ActionEvent(this, 1001, TransientWindow.this.myLinkableFadingLabel.getText()));
                    TransientWindow.this.dispose();
                }
            }
        });
    }

    private Point getPositionOnScreen() {
        Dimension ownerSize;
        Window owner = this.getOwner();
        if (owner.isVisible()) {
            ownerSize = owner.getSize();
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ownerSize = toolkit.getScreenSize();
        }
        int height = ownerSize.height - (this.getHeight() + 12) - theSumOfVisibleWindowsHeight;
        int width = ownerSize.width - (this.getWidth() + 5);
        return new Point(width, height);
    }

    public void setBackgroundImage(ImageIcon icon) {
        assert (icon != null) : "Background image must not be null";
        if (icon == null) {
            System.err.println("Background image must not be null");
            return;
        }
        this.getLayeredPane().add((Component)this.getTiledLabel(icon), new Integer(Integer.MIN_VALUE));
    }

    public void setIcon(ImageIcon icon) {
        this.myIconImage = icon;
        this.myIcon.setPreferredSize(new Dimension(this.myIconImage.getIconWidth(), this.myIconImage.getIconHeight()));
    }

    public void setTypeIcon(ImageIcon icon) {
        this.myTypeIconImage = icon;
        this.myTypeIcon.setPreferredSize(new Dimension(this.myTypeIconImage.getIconWidth(), this.myTypeIconImage.getIconHeight()));
    }

    public void setBorderColor(Color color) {
        this.myCenterPanel.setBorderColor(color);
    }

    @Override
    public void setBackground(Color background) {
        if (this.myCenterPanel != null) {
            this.myCenterPanel.setBackground(background);
        }
        super.setBackground(background);
    }

    public void setCloseButtonBackground(Color background) {
        this.myCloseButton.setBackground(background);
    }

    public void setCloseButtonIcon(ImageIcon icon) {
        this.myCloseButtonImage = icon;
        this.myCloseButton.setIcon(icon);
    }

    public void setCloseButtonMouseOverIcon(ImageIcon icon) {
        this.myCloseButtonMouseOverImage = icon;
    }

    public void setCloseButtonMousePressedIcon(ImageIcon icon) {
        this.myCloseButtonPressedImage = icon;
    }

    public void setLinkFont(Font font) {
        this.myLinkableFadingLabel.setFont(font);
        this.setMaximalPreferredWidth(this.myLinkableFadingLabel);
    }

    public void setAdditionalTextFont(Font font) {
        this.myAdditionalFadingLabel.setFont(font);
        this.setMaximalPreferredWidth(this.myAdditionalFadingLabel);
    }

    public void setLinkEnabledColor(Color color) {
        this.myLinkEnabledColor = color;
        if (this.isLinkEnabled()) {
            this.myLinkableFadingLabel.setForeground(color);
        }
    }

    public void setLinkDisabledColor(Color color) {
        this.myLinkDisabledColor = color;
        if (!this.isLinkEnabled()) {
            this.myLinkableFadingLabel.setForeground(color);
        }
    }

    public void setAdditionalTextColor(Color color) {
        this.myAdditionalFadingLabel.setForeground(color);
    }

    private JPanel getCenterPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.myCenterPanel.setLayout(layout);
        this.myTitleBarIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TransientWindow.this.myMousePressedMouseEvent = me;
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.myCenterPanel.add((Component)this.myTitleBarIcon, constraints);
        constraints.insets = new Insets(0, 0, 0, 1);
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        constraints.weightx = 0.0;
        constraints.gridx = 4;
        constraints.gridy = 1;
        this.myCenterPanel.add((Component)this.myCloseButton, constraints);
        constraints.insets = new Insets(0, 16, 0, 0);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.myCenterPanel.add((Component)this.myIcon, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridx = 2;
        constraints.gridy = 2;
        this.myCenterPanel.add((Component)this.myTypeIcon, constraints);
        constraints.insets = new Insets(1, 7, 0, 0);
        constraints.gridx = 4;
        constraints.gridy = 2;
        this.myCenterPanel.add((Component)this.myLinkableFadingLabel, constraints);
        constraints.insets = new Insets(0, 7, 12, 0);
        constraints.gridx = 4;
        constraints.gridy = 3;
        this.myCenterPanel.add((Component)this.myAdditionalFadingLabel, constraints);
        this.myCenterPanel.setOpaque(false);
        final Cursor cursor = this.getCursor();
        this.myLinkableFadingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TransientWindow.this.isLinkEnabled()) {
                    TransientWindow.this.myLinkableFadingLabel.setUnderlinedText(true);
                    TransientWindow.this.setCursor(new Cursor(12));
                } else {
                    TransientWindow.this.myLinkableFadingLabel.setUnderlinedText(false);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TransientWindow.this.myLinkableFadingLabel.setUnderlinedText(false);
                TransientWindow.this.setCursor(cursor);
            }
        });
        return this.myCenterPanel;
    }

    private void setCloseButton() {
        this.myCloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TransientWindow.this.myCloseButtonMouseOverImage != null) {
                    TransientWindow.this.myCloseButton.setIcon(TransientWindow.this.myCloseButtonMouseOverImage);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TransientWindow.this.myCloseButton.setIcon(TransientWindow.this.myCloseButtonImage);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (TransientWindow.this.myCloseButtonPressedImage != null) {
                    TransientWindow.this.myCloseButton.setIcon(TransientWindow.this.myCloseButtonPressedImage);
                }
            }
        });
        AbstractAction closeAction = new AbstractAction(this.myCloseButton.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransientWindow.this.dispose();
            }
        };
        this.myCloseButton.addActionListener(closeAction);
    }

    private JLabel getTiledLabel(final ImageIcon icon) {
        JLabel backlabel = new JLabel("");
        if (icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            backlabel = new JLabel(){
                int winc;
                int hinc;
                {
                    this.winc = icon.getIconWidth();
                    this.hinc = icon.getIconHeight();
                }

                @Override
                public void paintComponent(Graphics g) {
                    int w = this.getParent().getWidth();
                    int h = this.getParent().getHeight();
                    for (int i = 0; i < h + this.hinc; i += this.hinc) {
                        for (int j = 0; j < w + this.winc; j += this.winc) {
                            icon.paintIcon(this, g, j, i);
                        }
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(super.getSize());
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        backlabel.setBounds(0, 0, screenSize.width, screenSize.width);
        return backlabel;
    }
}

