/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrActionLabel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.ToolBarListener;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.SrEventListenerManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class ToolBarPanel
extends SrPanel {
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    private static final Font font = LookAndFill.GENERAL_FONT;
    private static final Color foreGround = new Color(113, 131, 155);
    private SrPanel jPanel1 = new SrPanel();

    public ToolBarPanel() {
        try {
            this.jbInit();
            this.addSeperator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.jPanel1.setLayout(new FlowLayout(0));
        this.add((Component)this.jPanel1, "North");
    }

    public void addToolBarListener(ToolBarListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeToolBarListener(ToolBarListener listener) {
        this.m_listeners.remove(listener);
    }

    private void addSeperator() {
        this.jPanel1.add((Component)new Seperator(), null);
    }

    protected void addSpace() {
        this.jPanel1.add((Component)new Space(), null);
        this.addSeperator();
    }

    private void addButtonComponent(JComponent button) {
        button.setFont(font);
        button.setForeground(foreGround);
        button.setBackground(Color.WHITE);
        button.setCursor(new Cursor(12));
        this.jPanel1.add((Component)button, null);
        this.addSeperator();
    }

    protected void addButton(JButton button) {
        this.addButton(button, null);
    }

    protected void addButton(SrActionLabel button) {
        this.addButtonComponent(button);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setIconTextGap(0);
    }

    protected void addButton(JButton button, ImageIcon icon) {
        this.addButtonComponent(button);
        button.setVerticalTextPosition(3);
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setHorizontalTextPosition(0);
        button.setIcon(icon);
        button.setIconTextGap(0);
    }

    public void setToolBarItemVisible(JComponent item, boolean visible) {
        Component[] comps = this.jPanel1.getComponents();
        int i = comps.length;
        while (i-- > 0) {
            if (!comps[i].equals(item)) continue;
            item.setVisible(visible);
            if (comps[i + 1] instanceof Seperator) {
                comps[i + 1].setVisible(visible);
            }
            if (i - 2 < 0 || !(comps[i - 2] instanceof Space)) continue;
            comps[i - 1].setVisible(visible);
        }
    }

    protected void addButton(SrAction action) {
        this.addButton(new SrActionLabel(action));
    }

    private static class Seperator
    extends JLabel {
        Seperator() {
            this.setIcon(ImageObject.TOOL_BAR_SEPERATOR.getImageIcon());
        }
    }

    private static class Space
    extends JLabel {
        Space() {
            this.setPreferredSize(new Dimension(50, this.getPreferredSize().height));
        }
    }
}

