/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPanelTitle;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableViewPanel
extends JPanel {
    private static SrResourceBundle UI_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US);
    private BorderLayout borderLayout2 = new BorderLayout();
    private SrScrollPane tableScrollPanel = new SrScrollPane();
    protected SrTablePanel m_tablePanel;
    private SrPanel tableTitlePanel = new SrPanel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private SrPanelTitle tableTitleLabel = new SrPanelTitle();
    private String title;
    private SrPanel totalLinesPanel = new SrPanel();
    private FlowLayout flowLayout4 = new FlowLayout();
    private JLabel totalLinesLabel = new JLabel();
    private TableModelListener myTableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            TableViewPanel.this.setStatusMessage();
        }
    };
    protected ClusterNode m_workingCluster;

    public TableViewPanel(String title, SrTablePanel tablePanel) {
        this(title, null, tablePanel);
    }

    protected TableViewPanel(String title, ClusterNode workingCluster, SrTablePanel tablePanel) {
        if (tablePanel == null) {
            throw new IllegalArgumentException("tablePanel cannot be null");
        }
        this.title = title;
        this.m_workingCluster = workingCluster;
        this.jbInit(tablePanel);
        this.submitTablePanel();
        this.setBackground(UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.PANEL_BACKGROUND_COLOR));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    private void jbInit(SrTablePanel tablePanel) {
        this.setLayout(this.borderLayout2);
        this.m_tablePanel = tablePanel;
        if (this.m_tablePanel == null) {
            this.tableScrollPanel.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
            this.add((Component)this.tableScrollPanel, "Center");
        } else {
            this.add((Component)this.m_tablePanel, "Center");
        }
        this.tableTitlePanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.add((Component)this.tableTitlePanel, "North");
        this.tableTitlePanel.add((Component)this.tableTitleLabel, null);
        this.tableTitleLabel.setText(this.title);
        this.totalLinesPanel.setLayout(this.flowLayout4);
        this.flowLayout4.setAlignment(0);
        this.add((Component)this.totalLinesPanel, "South");
        this.totalLinesPanel.add((Component)this.totalLinesLabel, null);
    }

    private void submitTablePanel() {
        this.setStatusMessage();
        this.addNewTableModelListener(this.m_tablePanel.getModel());
    }

    private void addNewTableModelListener(TableModel dataModel) {
        dataModel.addTableModelListener(this.myTableModelListener);
        this.getTable().addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableModel newModel;
                TableModel oldModel = (TableModel)evt.getOldValue();
                if (oldModel != null) {
                    oldModel.removeTableModelListener(TableViewPanel.this.myTableModelListener);
                }
                if ((newModel = (TableModel)evt.getNewValue()) != null) {
                    newModel.addTableModelListener(TableViewPanel.this.myTableModelListener);
                }
                TableViewPanel.this.setStatusMessage();
            }
        });
    }

    public JTable getTable() {
        return this.m_tablePanel.getTable();
    }

    public SrTablePanel getCurrentTablePanel() {
        return this.m_tablePanel;
    }

    private void setStatusMessage() {
        if (this.m_tablePanel != null) {
            this.totalLinesLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
            this.totalLinesLabel.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
            this.totalLinesLabel.setText("Total " + this.m_tablePanel.getTable().getRowCount() + " items");
        }
    }
}

