/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class TableHeader {
    private static HashMap<Class, ArrayList<String>> columnNamesHash = new HashMap();
    private String columnName;
    private int indexInModel = -1;

    protected TableHeader(String columnName) {
        this.columnName = columnName;
        this.insertToHash();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.columnName.equals(obj);
        }
        if (obj.getClass().equals(this.getClass())) {
            return this.columnName.equals(((TableHeader)obj).columnName);
        }
        return false;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getIndexInModel() {
        return this.indexInModel;
    }

    public String toString() {
        return this.columnName;
    }

    private void insertToHash() {
        Class<?> key = this.getClass();
        ArrayList<String> headerList = columnNamesHash.get(key);
        if (headerList == null) {
            headerList = new ArrayList();
            columnNamesHash.put(key, headerList);
        }
        headerList.add(this.columnName);
        this.indexInModel = headerList.size() - 1;
    }

    protected static List<String> getColumnNames(Class c) {
        return new ArrayList<String>((Collection)columnNamesHash.get(c));
    }
}

