/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.log.LogParameterMgr;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class StatusPanel
extends SrPanel
implements OperationController {
    private static StatusPanel instance;
    private SrLabelField statusLabel;
    private JLabel constantStatusLabel;
    public static final String CLIENT_LOG_LABEL_TOOLTIP;
    public static final String SERVER_LOG_LABEL_TOOLTIP;
    public static final String READY;
    public static final String CONNECTING_TO_SERVER;
    public static final Level WARNING;
    public static final Level INFO;
    public static final Level ERROR;
    public static final Level NO_INFO;
    private static ImageIcon redIcon;
    private static ImageIcon greenIcon;
    private static ImageIcon grayIcon;
    private static ImageIcon yellowIcon;
    private static final String DIALOG_STATUS_START_ERROR_MSG_STRING = "<font color=red>";
    private static final String DIALOG_STATUS_END_ERROR_MSG_STRING = "</font>";
    private SrTextField myClientLogLabel;
    private SrTextField myServerLogLabel;
    private Color myDefColor;
    private JLabel left = new JLabel(grayIcon);
    private JLabel mid = new JLabel(grayIcon);
    private JLabel right = new JLabel(grayIcon);

    private StatusPanel() {
        this.init();
    }

    private void init() {
        this.statusLabel = new SrLabelField();
        this.constantStatusLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.setLayout(new BorderLayout(0, 0));
        this.statusLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.statusLabel.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
        this.constantStatusLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.constantStatusLabel.setForeground(Color.RED);
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.constantStatusLabel, "Center");
        FlowLayout layout = new FlowLayout();
        layout.setVgap(0);
        SrPanel eastPanel = new SrPanel(layout);
        eastPanel.add(this.createLoggingPanel());
        eastPanel.add(this.initLightPanel());
        this.add((Component)eastPanel, "East");
    }

    private SrPanel initLightPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.left);
        panel.add(this.mid);
        panel.add(this.right);
        return panel;
    }

    public void setClientLogLevel(String aLevel) {
        this.myClientLogLabel.setText(SrLogger.log4jStringRepToSanradStringRep(aLevel));
    }

    public void setServerLogLevel(String aLevel) {
        String curLevel = aLevel;
        org.apache.log4j.Level dispLevel = org.apache.log4j.Level.toLevel(curLevel);
        if (!dispLevel.toString().equals(curLevel)) {
            curLevel = "INVALID";
            this.myServerLogLabel.setForeground(Color.RED);
        } else {
            this.myServerLogLabel.setForeground(this.myDefColor);
        }
        this.myServerLogLabel.setText(SrLogger.log4jStringRepToSanradStringRep(curLevel));
    }

    private SrPanel createLoggingPanel() {
        SrPanel mainPanel = new SrPanel();
        String maxVal = SrLogger.getMaxLengthLevel();
        this.myClientLogLabel = new SrTextField(maxVal.getBytes().length);
        this.myServerLogLabel = new SrTextField(maxVal.getBytes().length);
        this.myClientLogLabel.setToolTipText(CLIENT_LOG_LABEL_TOOLTIP);
        this.myServerLogLabel.setToolTipText(SERVER_LOG_LABEL_TOOLTIP);
        this.myClientLogLabel.setEditable(false);
        this.myServerLogLabel.setEditable(false);
        this.myDefColor = this.myClientLogLabel.getForeground();
        mainPanel.add(this.myClientLogLabel);
        mainPanel.add(this.myServerLogLabel);
        String curLevel = LogParameterMgr.getInstance().getServerLogLabel();
        org.apache.log4j.Level dispLevel = org.apache.log4j.Level.toLevel(curLevel);
        if (!dispLevel.toString().equals(curLevel)) {
            curLevel = "INVALID";
            this.myServerLogLabel.setForeground(Color.RED);
        } else {
            this.myServerLogLabel.setForeground(this.myDefColor);
        }
        this.myServerLogLabel.setText(SrLogger.log4jStringRepToSanradStringRep(curLevel));
        curLevel = LogParameterMgr.getInstance().getClientLogLabel();
        dispLevel = org.apache.log4j.Level.toLevel(curLevel);
        if (!dispLevel.toString().equals(curLevel)) {
            curLevel = "INVALID";
            this.myClientLogLabel.setForeground(Color.RED);
        } else {
            this.myClientLogLabel.setForeground(this.myDefColor);
        }
        this.myClientLogLabel.setText(SrLogger.log4jStringRepToSanradStringRep(curLevel));
        return mainPanel;
    }

    public static synchronized StatusPanel getInstance() {
        if (instance == null) {
            instance = new StatusPanel();
        }
        return instance;
    }

    public void setText(String msg, Level level, Object owner) {
        if (owner instanceof SrComponentStatusBarInterface) {
            this.setComponentStatusBar(msg, level, (SrComponentStatusBarInterface)owner);
        } else {
            this.setLevel(level);
            this.statusLabel.setText(msg);
            if (level.equals(ERROR)) {
                this.statusLabel.setForeground(Color.RED);
            } else {
                this.statusLabel.setForeground(this.myDefColor);
            }
        }
    }

    public void setText(String msg, Object owner) {
        this.setText(msg, NO_INFO, owner);
    }

    private void setComponentStatusBar(String msg, Level level, SrComponentStatusBarInterface owner) {
        owner.setStatusStr(this.buildStatusBarString(msg, level));
    }

    private String buildStatusBarString(String msg, Level level) {
        StringBuffer statusStr = new StringBuffer();
        if (level.equals(WARNING) || level.equals(ERROR)) {
            statusStr.append(DIALOG_STATUS_START_ERROR_MSG_STRING);
            statusStr.append(msg);
            statusStr.append(DIALOG_STATUS_END_ERROR_MSG_STRING);
        } else {
            statusStr.append(msg);
        }
        return statusStr.toString();
    }

    public String getStatusBarString() {
        String msg = null;
        msg = this.right.getIcon() == redIcon ? this.buildStatusBarString(this.statusLabel.getText(), ERROR) : this.buildStatusBarString(this.statusLabel.getText(), NO_INFO);
        return msg;
    }

    public void setConstantText(String msg) {
        this.constantStatusLabel.setText(msg);
    }

    public void setLevel(Level l) {
        if (l.equals(WARNING)) {
            this.left.setIcon(grayIcon);
            this.mid.setIcon(yellowIcon);
            this.right.setIcon(grayIcon);
        } else if (l.equals(INFO) || l.equals(NO_INFO)) {
            this.left.setIcon(greenIcon);
            this.mid.setIcon(grayIcon);
            this.right.setIcon(grayIcon);
        } else if (l.equals(ERROR)) {
            this.left.setIcon(grayIcon);
            this.mid.setIcon(grayIcon);
            this.right.setIcon(redIcon);
        }
    }

    public String getText() {
        return this.statusLabel.getText();
    }

    public void append(String msg) {
        this.statusLabel.setText(this.statusLabel.getText() + msg);
    }

    @Override
    public void success(SrAction aAction) {
        StatusPanel.getInstance().setText(READY, INFO, null);
        ClientLoader.getMainFrame().setCursor(null);
    }

    @Override
    public void fail(String message) {
        StatusPanel.getInstance().setText(READY, INFO, null);
        SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), message);
        ClientLoader.getMainFrame().setCursor(null);
    }

    @Override
    public void inProcess(String message) {
        StatusPanel.getInstance().setLevel(NO_INFO);
        ClientLoader.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
    }

    static {
        CLIENT_LOG_LABEL_TOOLTIP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_LOG_LABEL_TOOLTIP);
        SERVER_LOG_LABEL_TOOLTIP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.SERVER_LOG_LABEL_TOOLTIP);
        READY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATUS_PANEL_READY);
        CONNECTING_TO_SERVER = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATUS_PANEL_CONNECT_TO_SERVER);
        WARNING = new Level("WARNING", 0);
        INFO = new Level("INFO", 1);
        ERROR = new Level("ERROR", 2);
        NO_INFO = new Level("NO_INFO", 3);
        redIcon = ImageObject.RED_LIGHT.getImageIcon();
        greenIcon = ImageObject.GREEN_LIGHT.getImageIcon();
        grayIcon = ImageObject.GRAY_LIGHT.getImageIcon();
        yellowIcon = ImageObject.YELLOW_LIGHT.getImageIcon();
    }

    public static class Level {
        private int id;
        private String level;

        private Level(String level, int id) {
            this.id = id;
            this.level = level;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Level) {
                return ((Level)obj).id == this.id;
            }
            return false;
        }

        public String toString() {
            return this.level;
        }
    }
}

