/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JLabel;

public class SrUnderlinedLabelField
extends JLabel {
    private boolean myIsUnderlined = true;
    private int myBottomInset = 0;

    public SrUnderlinedLabelField(String text) {
        super(text);
    }

    public SrUnderlinedLabelField() {
        this("");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int x1 = 0;
        int y1 = fm.getHeight() - this.myBottomInset;
        int x2 = fm.stringWidth(this.getText());
        if (this.getText().length() > 0) {
            if (this.myIsUnderlined) {
                g.drawLine(x1, y1, x2, y1);
            } else {
                Color color = g.getColor();
                g.setXORMode(this.getForeground());
                g.drawLine(x1, y1, x2, y1);
                g.setColor(color);
            }
        }
    }

    public void setUnderlinedText(boolean underline) {
        this.myIsUnderlined = underline;
        this.repaint();
    }

    public boolean isUndelined() {
        return this.myIsUnderlined;
    }

    public void setBottomInset(int bottom) {
        this.myBottomInset = bottom;
    }

    public int getBottomInset() {
        return this.myBottomInset;
    }
}

