/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.SrTreeExpandSelectionRestorer;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.SrEventListenerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrTreePanel
extends JPanel {
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    private SrScrollPane m_treeView;
    protected SrTree m_tree;
    protected SrPopupMenu m_popup;
    private SrTreeMouseListener m_listener;
    private TreeSelectionListener m_selListener;

    public SrTreePanel(DefaultMutableTreeNode root) {
        this(new SrTreeModel(root));
    }

    public SrTreePanel(SrTreeModel model) {
        super(new BorderLayout());
        this.m_tree = this.getTreeInstance(model);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        SrTreeExpandSelectionRestorer selExpRestorer = new SrTreeExpandSelectionRestorer(this.m_tree);
        model.addSelectionExpandRestorer(selExpRestorer);
        this.m_selListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                SrTreePanel.this.onTreeSelectionEvent(event);
            }
        };
        this.m_tree.addTreeSelectionListener(this.m_selListener);
        this.m_listener = new SrTreeMouseListener();
        this.m_tree.addMouseListener(this.m_listener);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setInvokesStopCellEditing(true);
        this.m_treeView = new SrScrollPane(this.m_tree);
        this.add((Component)this.m_treeView, "Center");
        this.m_tree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 2 && e.getKeyCode() == 89) {
                    Rectangle cellBounds = SrTreePanel.this.m_tree.getPathBounds(SrTreePanel.this.m_tree.getSelectionPath());
                    MouseEvent mouseEvent = new MouseEvent(SrTreePanel.this.m_tree, 500, e.getWhen(), 0, cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2, 1, true, 3);
                    MouseListener[] listeners = SrTreePanel.this.m_tree.getMouseListeners();
                    int i = listeners.length;
                    while (i-- > 0) {
                        listeners[i].mouseReleased(mouseEvent);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected SrTree getTreeInstance(SrTreeModel model) {
        return new SrTree(model);
    }

    public JScrollPane getPanelScrollPane() {
        return this.m_treeView;
    }

    public SrTree getTreeObject() {
        return this.m_tree;
    }

    public SrTreeModel getTreeModel() {
        return (SrTreeModel)this.m_tree.getModel();
    }

    public void setTreePopupMenu(SrPopupMenu menu) {
        this.m_popup = menu;
    }

    public SrPopupMenu getTreePopupMenu() {
        return this.m_popup;
    }

    public TreePath[] getSelectionPaths() {
        return this.m_tree.getSelectionPaths();
    }

    public TreeNode getSelectedNode() {
        return (TreeNode)this.m_tree.getLastSelectedPathComponent();
    }

    public void setTreeSelection(int mode) {
        this.m_tree.getSelectionModel().setSelectionMode(mode);
    }

    public DefaultMutableTreeNode addNode(SrComponent newComponent, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode newNode = this.addNode(newComponent, parent, parent.getChildCount());
        return newNode;
    }

    public DefaultMutableTreeNode addNode(SrComponent newComponent, DefaultMutableTreeNode parent, int position) {
        DefaultMutableTreeNode newNode = null;
        if (position >= 0 && position <= parent.getChildCount()) {
            newNode = new DefaultMutableTreeNode(newComponent);
            ((SrTreeModel)this.m_tree.getModel()).insertNodeInto(newNode, parent, position);
        }
        return newNode;
    }

    public void addTreeBranch(DefaultMutableTreeNode parentNode, Vector nodes, boolean insertAsSort, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).addTreeBranch(parentNode, nodes, insertAsSort);
    }

    public void addTreeBranch(SrComponent parent, Vector nodes, boolean insertAsSort, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).addTreeBranch(parent, nodes, insertAsSort);
    }

    public void clearTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((SrTreeModel)this.m_tree.getModel()).getRoot();
        if (root != null) {
            root.removeAllChildren();
        }
    }

    public void removeNode(DefaultMutableTreeNode node) {
        if (node != null) {
            ((SrTreeModel)this.m_tree.getModel()).removeNodeFromParent(node);
        }
    }

    public void removeNode(SrComponent com) {
        DefaultMutableTreeNode parentNode = this.searchNode(com);
        if (parentNode != null) {
            ((SrTreeModel)this.m_tree.getModel()).removeNodeFromParent(parentNode);
        }
    }

    public void searchNode(SrComponent searchObj, Vector resultPaths) {
        ((SrTreeModel)this.m_tree.getModel()).searchNode(searchObj, resultPaths);
    }

    public void collapseTree() {
        this.m_tree.collapsePath(new TreePath(((SrTreeModel)this.m_tree.getModel()).getRoot()));
    }

    public void collapseTreeNode(TreePath path) {
        this.m_tree.collapsePath(path);
    }

    public void collapseTreeNode(SrComponent com) {
        Vector paths = new Vector();
        this.searchNode(com, paths);
        if (paths.size() > 0) {
            TreePath path = (TreePath)paths.get(0);
            this.collapseTreeNode(path);
        }
    }

    public void expandTree() {
        for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
            this.m_tree.expandRow(row);
        }
    }

    public void expandAndSelectNode(SrComponent com) {
        Vector paths = new Vector();
        this.searchNode(com, paths);
        if (paths.size() > 0) {
            TreePath[] selects = new TreePath[paths.size()];
            int i = 0;
            this.m_tree.clearSelection();
            for (TreePath path : paths) {
                this.m_tree.expandPath(path);
                TreePath savedPath = path;
                while ((path = path.getParentPath()) != null) {
                    this.m_tree.expandPath(path);
                }
                selects[i++] = savedPath;
            }
            this.m_tree.setSelectionPaths(selects);
        }
    }

    public void expandAndSelectNode(TreePath path) {
        this.m_tree.expandPath(path);
        this.m_tree.addSelectionPath(path);
    }

    public void rebuildTree() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        Enumeration<TreePath> iter = this.m_tree.getExpandedDescendants(new TreePath(((SrTreeModel)this.m_tree.getModel()).getRoot()));
        ((SrTreeModel)this.m_tree.getModel()).reload((DefaultMutableTreeNode)((SrTreeModel)this.m_tree.getModel()).getRoot());
        this.m_tree.setSelectionPaths(paths);
        while (iter.hasMoreElements()) {
            this.m_tree.expandPath(iter.nextElement());
        }
    }

    public DefaultMutableTreeNode searchNode(SrComponent com) {
        return ((SrTreeModel)this.m_tree.getModel()).searchNode(com);
    }

    public void insertInPosition(DefaultMutableTreeNode parent, DefaultMutableTreeNode newNode) {
        ((SrTreeModel)this.m_tree.getModel()).insertInPosition(parent, newNode);
    }

    public void sortTree(boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortTree();
    }

    public void sortBranch(DefaultMutableTreeNode parent, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortBranch(parent);
    }

    public void sortBranch(SrComponent parent, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortBranch(parent);
    }

    protected void onTreeSelectionEvent(TreeSelectionEvent event) {
    }

    protected void mouseReleasedOutOfRange() {
        this.m_tree.getSelectionModel().clearSelection();
    }

    protected void showPopupMenu(MouseEvent e) {
        this.m_popup.show(e);
    }

    class SrTreeMouseListener
    extends MouseAdapter {
        SrTreeMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point p = e.getPoint();
            TreePath path = SrTreePanel.this.m_tree.getPathForLocation(p.x, p.y);
            if (path == null || path.getPathCount() == 0) {
                SrTreePanel.this.mouseReleasedOutOfRange();
            } else if (SwingUtilities.isRightMouseButton(e) && path != null && path.getPathCount() > 0) {
                if (!SrTreePanel.this.m_tree.getSelectionModel().isPathSelected(path)) {
                    SrTreePanel.this.m_tree.getSelectionModel().setSelectionPath(path);
                } else {
                    SrTreePanel.this.m_tree.getSelectionModel().addSelectionPath(path);
                }
                if (SrTreePanel.this.m_popup != null) {
                    SrTreePanel.this.showPopupMenu(e);
                }
            }
        }
    }
}

