/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrTreeExpandSelectionRestorer;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.SrEventListenerManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrTreeModel
extends DefaultTreeModel
implements Comparator {
    private boolean m_sortAsc = true;
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    private static final SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, EventObject> theSaveInformer = new SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, EventObject>(){

        @Override
        public void inform(SrTreeExpandSelectionRestorer aListener, EventObject aEvent) {
            aListener.save();
        }
    };
    private static final SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, EventObject> theRestoreInformer = new SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, EventObject>(){

        @Override
        public void inform(SrTreeExpandSelectionRestorer aListener, EventObject aEvent) {
            aListener.restore();
        }
    };
    private static final SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, TreeModelEvent> theRemoveInformer = new SrEventListenerManager.Informer<SrTreeExpandSelectionRestorer, TreeModelEvent>(){

        @Override
        public void inform(SrTreeExpandSelectionRestorer aListener, TreeModelEvent aEvent) {
            aListener.treeNodesRemoved(aEvent);
        }
    };

    public SrTreeModel(DefaultMutableTreeNode root) {
        super(root);
    }

    public SrTreeModel(DefaultMutableTreeNode root, Vector nodes, boolean insertAsSort) {
        this(root);
        this.buildTree(nodes, insertAsSort);
    }

    private void buildTree(Vector nodes, boolean insertAsSort) {
        if (insertAsSort) {
            Collections.sort(nodes, this);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Object rootObj = root.getUserObject();
        nodes.add(0, rootObj);
        DefaultMutableTreeNode newRoot = this.recursiveBuild(nodes);
        this.setRoot(newRoot);
        this.reload(root);
    }

    private DefaultMutableTreeNode recursiveBuild(List hierarchy) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((SrComponent)hierarchy.get(0));
        for (int i = 1; i < hierarchy.size(); ++i) {
            Object nodeSpecifier = hierarchy.get(i);
            DefaultMutableTreeNode child = nodeSpecifier instanceof List ? this.recursiveBuild((List)nodeSpecifier) : new DefaultMutableTreeNode((SrComponent)nodeSpecifier);
            node.add(child);
        }
        return node;
    }

    public TreePath getTreePath(TreeNode node) {
        Object[] path = this.getPathToRoot(node);
        if (path != null) {
            return new TreePath(path);
        }
        return null;
    }

    public void sortTree() {
        Vector<Object> nodesVec = new Vector<Object>(((DefaultMutableTreeNode)this.getRoot()).getChildCount());
        this.dumpNodeToVector((DefaultMutableTreeNode)this.getRoot(), nodesVec);
        Collections.sort(nodesVec, this);
        Object rootObj = ((DefaultMutableTreeNode)this.getRoot()).getUserObject();
        nodesVec.add(0, rootObj);
        DefaultMutableTreeNode newRoot = this.recursiveBuild(nodesVec);
        this.setRoot(newRoot);
        this.reload();
    }

    public void sortBranch(DefaultMutableTreeNode parentNode) {
        if (!parentNode.isRoot()) {
            Vector<Object> nodesVec = new Vector<Object>(parentNode.getChildCount() + 1);
            this.dumpNodeToVector(parentNode, nodesVec);
            DefaultMutableTreeNode papa = (DefaultMutableTreeNode)parentNode.getParent();
            int sybl = papa.getIndex(parentNode);
            this.removeNodeFromParent(parentNode);
            Collections.sort(nodesVec, this);
            Object parentObj = parentNode.getUserObject();
            nodesVec.add(0, parentObj);
            DefaultMutableTreeNode newBranch = this.recursiveBuild(nodesVec);
            this.insertNodeInto(newBranch, papa, sybl);
        }
    }

    public void sortBranch(SrComponent parent) {
        DefaultMutableTreeNode parentNode = this.searchNode(parent);
        if (parentNode != null) {
            this.sortBranch(parentNode);
        }
    }

    private void dumpNodeToVector(DefaultMutableTreeNode node, Vector data) {
        int children = node.getChildCount();
        if (children == 0) {
            data.add(node.getUserObject());
        } else {
            for (int i = 0; i < children; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                if (child.getChildCount() > 0) {
                    Vector<Object> v = new Vector<Object>(child.getChildCount() + 1);
                    v.add(child.getUserObject());
                    data.add(v);
                    this.dumpNodeToVector(child, v);
                    continue;
                }
                data.add(child.getUserObject());
            }
        }
    }

    public void dumpTreeToVector(DefaultMutableTreeNode node, Vector data) {
        int children = node.getChildCount();
        if (children == 0) {
            data.add(node);
        } else {
            for (int i = 0; i < children; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                if (child.getChildCount() > 0) {
                    Vector<DefaultMutableTreeNode> v = new Vector<DefaultMutableTreeNode>(child.getChildCount() + 1);
                    v.add(child);
                    data.add(v);
                    this.dumpTreeToVector(child, v);
                    continue;
                }
                data.add(child);
            }
        }
    }

    public void addTreeBranch(DefaultMutableTreeNode parentNode, Vector nodes, boolean insertAsSort) {
        if (parentNode.equals(this.getRoot())) {
            return;
        }
        if (insertAsSort) {
            Collections.sort(nodes, this);
        }
        Object parentObj = parentNode.getUserObject();
        nodes.add(0, parentObj);
        DefaultMutableTreeNode newBranch = this.recursiveBuild(nodes);
        if (newBranch != null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentNode.getParent();
            this.removeNodeFromParent(parentNode);
            if (insertAsSort) {
                this.insertInPosition(parent, newBranch);
            } else {
                this.insertNodeInto(newBranch, parent, 0);
            }
            int numOfChild = parentNode.getChildCount();
            for (int i = 0; i < numOfChild; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(0);
                if (insertAsSort) {
                    this.insertInPosition(newBranch, node);
                    continue;
                }
                this.insertNodeInto(node, newBranch, 0);
            }
        }
    }

    public void addTreeBranch(SrComponent parent, Vector nodes, boolean insertAsSort) {
        DefaultMutableTreeNode parentNode = this.searchNode(parent);
        if (parentNode != null) {
            this.addTreeBranch(parentNode, nodes, insertAsSort);
        }
    }

    public DefaultMutableTreeNode searchNode(SrComponent com) {
        DefaultMutableTreeNode returnNode = null;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        returnNode = this.searchNode(new TreePath(root), com);
        return returnNode;
    }

    private DefaultMutableTreeNode searchNode(TreePath parent, SrComponent obj) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        SrComponent treeObj = (SrComponent)node.getUserObject();
        if (treeObj != null && this.compare(treeObj, obj) == 0) {
            return node;
        }
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                DefaultMutableTreeNode retNode = this.searchNode(path, obj);
                if (retNode == null) continue;
                return retNode;
            }
        }
        return null;
    }

    public void insertInPosition(DefaultMutableTreeNode parent, DefaultMutableTreeNode newNode) {
        SrComponent newObj = (SrComponent)newNode.getUserObject();
        Enumeration<TreeNode> children = parent.children();
        if (parent.getChildCount() == 0) {
            this.insertNodeInto(newNode, parent, parent.getChildCount());
            return;
        }
        if (parent.getChildCount() > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            SrComponent obj = (SrComponent)node.getUserObject();
            if (this.compare(obj, newObj) > 0) {
                this.insertNodeInto(newNode, parent, 0);
                return;
            }
            children = parent.children();
        }
        int i = 0;
        DefaultMutableTreeNode node2 = null;
        DefaultMutableTreeNode node1 = null;
        while (children.hasMoreElements()) {
            node1 = node2 != null ? node2 : (DefaultMutableTreeNode)children.nextElement();
            ++i;
            if (children.hasMoreElements()) {
                node2 = (DefaultMutableTreeNode)children.nextElement();
            }
            SrComponent obj1 = (SrComponent)node1.getUserObject();
            SrComponent obj2 = null;
            if (node2 != null) {
                obj2 = (SrComponent)node2.getUserObject();
            }
            if (this.compare(obj1, newObj) < 0 && obj2 != null && this.compare(obj2, newObj) > 0) {
                this.insertNodeInto(newNode, parent, i);
                break;
            }
            if (this.compare(obj1, newObj) < 0 && obj2 == null) {
                this.insertNodeInto(newNode, parent, parent.getChildCount());
                break;
            }
            if (this.compare(obj1, newObj) >= 0 || obj2 == null || this.compare(obj2, newObj) >= 0 || children.hasMoreElements()) continue;
            this.insertNodeInto(newNode, parent, parent.getChildCount());
        }
    }

    public void insertOrderedByName(DefaultMutableTreeNode parent, DefaultMutableTreeNode newChild) {
        int childs = parent.getChildCount();
        int i = 0;
        for (i = 0; i < childs; ++i) {
            TreeNode child = parent.getChildAt(i);
            if (newChild.equals(child)) {
                return;
            }
            if (newChild.toString().compareToIgnoreCase(child.toString()) < 0) break;
        }
        this.insertNodeInto(newChild, parent, i);
    }

    public void searchNode(SrComponent searchObj, Vector resultPaths) {
        if (resultPaths != null && resultPaths.isEmpty()) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            this.searchNode(new TreePath(root), resultPaths, searchObj);
        }
    }

    private void searchNode(TreePath parent, Vector resultPaths, SrComponent searchObj) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (this.compare((SrComponent)node.getUserObject(), searchObj) == 0) {
            resultPaths.add(parent);
        }
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.searchNode(path, resultPaths, searchObj);
            }
        }
    }

    protected int compareTwoNodeObjects(Object o1, Object o2) {
        if (o1 instanceof SrComponent && o2 instanceof SrComponent) {
            SrComponent class1 = (SrComponent)o1;
            SrComponent class2 = (SrComponent)o2;
            int result = class1.compareTo(class2);
            return result;
        }
        return 0;
    }

    private int order(int i) {
        if (!this.m_sortAsc) {
            return -i;
        }
        return i;
    }

    public int compare(Object o1, Object o2) {
        List v;
        if (o1 instanceof List) {
            v = (List)o1;
            o1 = this.sortChildVector(v);
        }
        if (o2 instanceof List) {
            v = (List)o2;
            o2 = this.sortChildVector(v);
        }
        int result = this.compareTwoNodeObjects(o1, o2);
        return this.order(result);
    }

    private Object sortChildVector(List v) {
        Object o = v.remove(0);
        Collections.sort(v, this);
        v.add(0, o);
        return o;
    }

    public boolean isSortAsc() {
        return this.m_sortAsc;
    }

    public void setSortAsc(boolean sortAsc) {
        this.m_sortAsc = sortAsc;
    }

    public void addSelectionExpandRestorer(SrTreeExpandSelectionRestorer selExpRestorer) {
        this.m_listeners.add(selExpRestorer);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (path != null && path.length > 0) {
            this.m_listeners.fireEvent(SrTreeExpandSelectionRestorer.class, new EventObject(source), theSaveInformer);
            super.fireTreeStructureChanged(source, path, childIndices, children);
            this.m_listeners.fireEvent(SrTreeExpandSelectionRestorer.class, new EventObject(source), theRestoreInformer);
        }
    }

    @Override
    protected void fireTreeNodesRemoved(Object aSource, Object[] aPath, int[] aChildIndices, Object[] aChildren) {
        this.m_listeners.fireEvent(SrTreeExpandSelectionRestorer.class, new TreeModelEvent(aSource, aPath, aChildIndices, aChildren), theRemoveInformer);
        super.fireTreeNodesRemoved(aSource, aPath, aChildIndices, aChildren);
    }
}

