/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrTreeExpandSelectionRestorer
implements EventListener {
    private List<TreePath> expandedPaths;
    private JTree tree;
    private List<TreePath> selectionPaths;

    public void treeNodesRemoved(TreeModelEvent e) {
        if (this.selectionPaths != null) {
            Object[] removedNodes = e.getChildren();
            Object[] parentPath = e.getPath();
            if (removedNodes != null) {
                for (Object node : removedNodes) {
                    Object[] removedPath = new Object[parentPath.length + 1];
                    System.arraycopy(parentPath, 0, removedPath, 0, parentPath.length);
                    removedPath[removedPath.length - 1] = node;
                    TreePath path = new TreePath(removedPath);
                    this.selectionPaths.remove(path);
                    this.expandedPaths.remove(path);
                }
            }
        }
    }

    public SrTreeExpandSelectionRestorer(JTree tree) {
        this.tree = tree;
        this.save();
    }

    public void save() {
        this.saveSelection();
        this.saveExpandedState();
    }

    public void restore() {
        this.restoreExpandedState();
        this.restoreSelections();
    }

    private void restoreSelections() {
        if (this.selectionPaths != null) {
            for (TreePath path : this.selectionPaths) {
                if (this.tree.getRowForPath(path) < 0) continue;
                this.tree.addSelectionPath(path);
            }
        }
    }

    private void restoreExpandedState() {
        for (TreePath path : this.expandedPaths) {
            this.tree.expandPath(path);
        }
    }

    private void saveExpandedState() {
        this.expandedPaths = new ArrayList<TreePath>();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (root != null) {
            TreePath rootPath = new TreePath(root);
            Enumeration<TreePath> iter = this.tree.getExpandedDescendants(rootPath);
            while (iter != null && iter.hasMoreElements()) {
                this.expandedPaths.add(iter.nextElement());
            }
        }
    }

    private void saveSelection() {
        this.selectionPaths = new ArrayList<TreePath>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            Collections.addAll(this.selectionPaths, paths);
        } else {
            this.selectionPaths = Collections.EMPTY_LIST;
        }
    }

    private void print() {
        if (this.selectionPaths == null) {
            System.out.println("No selection");
            return;
        }
        StringBuffer buffer = new StringBuffer("selection paths are:\n");
        for (TreePath path : this.selectionPaths) {
            buffer.append(path.toString()).append('\n');
        }
        System.out.println(buffer.toString());
    }
}

