/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrCellEditor;
import com.sanrad.swing.SrDefaultCellEditor;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTable;
import com.sanrad.swing.SrTableCellRenderer;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.TableHeader;
import com.sanrad.swing.TableSelectionSaveListener;
import com.sanrad.swing.border.SrLineBorder;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.table.ColumnGroup;
import com.sanrad.swing.table.GroupableTableHeader;
import com.sanrad.swing.table.KeyObject;
import com.sanrad.swing.table.SrComboboxTableCellRenderer;
import com.sanrad.swing.table.SrTableCellTooltip;
import com.sanrad.swing.table.UnEditableCellEditor;
import com.sanrad.swing.table.event.TableCellEditEvent;
import com.sanrad.swing.table.event.TableCellEditListener;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SrTablePanel
extends SrPanel
implements ListSelectionListener,
TableSelectionSaveListener,
TableCellEditListener {
    protected SrTable m_table;
    private SrTableColumns m_tableCols;
    private int m_selMode;
    private HeaderSortListener m_hsl;
    private JScrollPane m_scrollPane;
    private SrPopupMenu m_popup;
    private int[] m_selSet;
    private SrTableMouseAdapter m_mouseListener;
    private static final String ROW_DEL = "\n";
    private static final String COLUMN_DEL = "\t";
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    private HashSet<Integer> myDisabledRows = new HashSet();
    private HashMap<Integer, SrTableCellTooltip> myColumnToTooltipMap = new HashMap();

    public SrTablePanel(SrTableModel model) {
        this(model, true);
    }

    public SrTablePanel(SrTableModel model, boolean sort) {
        super(new BorderLayout());
        int i;
        this.m_tableCols = model.getTableColumnsObject();
        this.m_table = new SrTable(model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int columnIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, columnIndex);
                if (c instanceof JComponent) {
                    JComponent jComp = (JComponent)c;
                    jComp.setToolTipText(null);
                    jComp.setEnabled(SrTablePanel.this.isEnabledRow(rowIndex));
                }
                if (c instanceof SrTableCellTooltip) {
                    if (c instanceof JComponent) {
                        ((JComponent)c).setToolTipText(((SrTableCellTooltip)((Object)c)).getTooltipText(rowIndex, columnIndex));
                    }
                } else if (c instanceof JComponent && SrTablePanel.this.myColumnToTooltipMap.get(columnIndex) != null) {
                    SrTableCellTooltip tooltipProvider = (SrTableCellTooltip)SrTablePanel.this.myColumnToTooltipMap.get(columnIndex);
                    ((JComponent)c).setToolTipText(tooltipProvider.getTooltipText(rowIndex, columnIndex));
                } else if (c instanceof DefaultTableCellRenderer) {
                    Exception e;
                    String exceMsg;
                    Object value;
                    DefaultTableCellRenderer rend = (DefaultTableCellRenderer)c;
                    String text = rend.getText();
                    if (text == null) {
                        text = "";
                        value = SrTablePanel.this.m_table.getValueAt(rowIndex, columnIndex);
                        exceMsg = "Method renderer.getText() returned null from class " + c.getClass() + ", index in table: row=" + rowIndex + " col=" + columnIndex + ", value in cell is " + (value != null ? "[" + value.getClass() + ":" + value + "]" : null);
                        e = new Exception(exceMsg);
                        e.printStackTrace();
                    }
                    if (text.length() > 0) {
                        rend.setToolTipText(text);
                    } else {
                        value = SrTablePanel.this.m_table.getValueAt(rowIndex, columnIndex);
                        if (value instanceof KeyObject && ((KeyObject)value).getValue() == null) {
                            exceMsg = "KeyObject's value was set to null";
                            e = new Exception(exceMsg);
                            e.printStackTrace();
                        }
                    }
                } else if (c instanceof JComponent) {
                    String value;
                    JComponent jc = (JComponent)c;
                    Object val = this.getValueAt(rowIndex, columnIndex);
                    if (val != null && (value = val.toString()).length() > 0) {
                        jc.setToolTipText(value);
                    }
                }
                return c;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new GroupableTableHeader(this.columnModel);
            }
        };
        model.addListeners();
        model.initModelData();
        this.m_selMode = 0;
        this.m_table.setSelectionMode(this.m_selMode);
        this.m_table.setSelectionModel(new SrTableSelectionModel(this));
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 4);
        this.m_hsl = new HeaderSortListener();
        this.m_table.getTableHeader().addMouseListener(this.m_hsl);
        this.m_table.getTableHeader().addMouseMotionListener(this.m_hsl);
        SrComponent[] defVals = this.m_tableCols.getColumnObjects();
        int cols = model.getColumnCount();
        for (i = 0; i < cols; ++i) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            if (defVals == null || i >= defVals.length) continue;
            tc.setHeaderRenderer(new AlignedHeaderCellRenderer(0.0f));
            if (defVals[i] instanceof SrCheckbox) continue;
            tc.setCellRenderer(new SrTableCellRenderer());
        }
        if (defVals != null) {
            for (i = 0; i < defVals.length; ++i) {
                if (defVals[i] instanceof SrCheckbox) {
                    model.setDefaults(i, defVals[i]);
                    continue;
                }
                TableColumn myColumn = this.m_table.getColumnModel().getColumn(i);
                Component c = myColumn.getHeaderRenderer().getTableCellRendererComponent(this.m_table, myColumn.getHeaderValue(), false, false, -1, i);
                int headerWidth = c.getPreferredSize().width + 1;
                myColumn.setPreferredWidth(headerWidth);
                if (!(defVals[i] instanceof SrLabelField)) {
                    myColumn.setCellEditor(new SrCellEditor(myColumn, defVals[i], headerWidth));
                }
                model.setDefaults(i, defVals[i]);
            }
        }
        this.m_table.setShowVerticalLines(true);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_mouseListener = new SrTableMouseAdapter();
        this.m_table.addMouseListener(this.m_mouseListener);
        this.m_table.setAutoResizeMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.addTableCellEditListener(this);
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        this.add((Component)this.m_scrollPane, "Center");
        this.m_scrollPane.addMouseListener(this.m_mouseListener);
        if (sort) {
            this.invokeColumnSortOnStartup(0, true);
        }
        model.addSelSaveListeners(this);
        this.m_table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 2 && e.getKeyCode() == 89) {
                    Rectangle cellLocation = SrTablePanel.this.m_table.getCellRect(SrTablePanel.this.m_table.getSelectedRow(), 0, false);
                    MouseEvent event = new MouseEvent(SrTablePanel.this.m_table, 500, e.getWhen(), 0, cellLocation.x + cellLocation.width / 2, cellLocation.y + cellLocation.height / 2, 1, true, 3);
                    SrTablePanel.this.m_mouseListener.mouseClicked(event);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void setTablePanelCellRenderer(SrTableCellRenderer renderer) {
        int cols = this.m_table.getColumnModel().getColumnCount();
        for (int i = 0; i < cols; ++i) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            tc.setCellRenderer(renderer);
        }
    }

    public void setComboBoxColumn(TableHeader aTableColumnHeader, SrComboBox aCombo, boolean aRollbackAfterEditing) {
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(aTableColumnHeader.getIndexInModel());
        SrComboboxTableCellRenderer renderer = new SrComboboxTableCellRenderer();
        renderer.setRenderer(aCombo.getRenderer());
        for (int i = 0; i < aCombo.getItemCount(); ++i) {
            renderer.addItem(aCombo.getItemAt(i));
        }
        tableColumn.setCellRenderer(renderer);
        SrDefaultCellEditor editor = new SrDefaultCellEditor(aCombo);
        editor.setRollbackAfterEditing(aRollbackAfterEditing);
        tableColumn.setCellEditor(editor);
    }

    public void setColumnTooltip(TableHeader aTableColumnHeader, SrTableCellTooltip aTooltipProvider) {
        if (aTableColumnHeader == null) {
            throw new IllegalArgumentException("TableHeader cannot be null");
        }
        if (aTooltipProvider != null) {
            this.myColumnToTooltipMap.put(aTableColumnHeader.getIndexInModel(), aTooltipProvider);
        } else {
            this.myColumnToTooltipMap.remove(aTableColumnHeader.getIndexInModel());
        }
    }

    public void setModel(SrTableModel aModel) {
        this.getModel().removeListeners();
        this.m_table.setModel(aModel);
        aModel.addListeners();
        aModel.initModelData();
    }

    public void setColumnUnEditable(TableHeader aTableHeader) {
        int indexInModel = this.getModel().getColumnIndex(aTableHeader.getColumnName());
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(indexInModel);
        tableColumn.setCellEditor(new UnEditableCellEditor());
    }

    @Override
    public void saveTableSelectionSet() {
        this.m_selSet = this.m_table.getSelectedRows();
    }

    @Override
    public void restoreTableSelectionSet() {
        if (this.m_selSet != null && this.m_selSet.length > 0) {
            this.m_table.setRowSelectionInterval(this.m_selSet[0], this.m_selSet[this.m_selSet.length - 1]);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && event.getSource() == this.m_table.getSelectionModel() && event.getFirstIndex() >= 0) {
            if (this.m_table.getColumnSelectionAllowed() && !this.m_table.getRowSelectionAllowed()) {
                int[] colIndices = this.m_table.getSelectedColumns();
                this.columnSelectionChanged(colIndices);
            } else if (!this.m_table.getColumnSelectionAllowed() && this.m_table.getRowSelectionAllowed()) {
                int[] rowIndices = this.m_table.getSelectedRows();
                this.rowSelectionChanged(rowIndices);
            }
        }
    }

    protected void rowSelectionChanged(int[] rowIndices) {
    }

    protected void columnSelectionChanged(int[] colIndices) {
    }

    public void setTablePopUpMenuObject(SrPopupMenu menu) {
        this.m_popup = menu;
    }

    public SrPopupMenu getTablePopUpMenuObject() {
        return this.m_popup;
    }

    public void setColumnSortComparator(Comparator comp) {
        ((SrTableModel)this.m_table.getModel()).setSortComperator(comp);
    }

    public SrTable getTable() {
        return this.m_table;
    }

    public SrTableModel getModel() {
        return (SrTableModel)this.m_table.getModel();
    }

    public void addRow(Object[] row) {
        ((SrTableModel)this.m_table.getModel()).addRow(row);
    }

    public void setCellValue(Object value, int row, int col) {
        this.m_table.getModel().setValueAt(value, row, col);
    }

    public void removeRow(int rowId) {
        ((SrTableModel)this.m_table.getModel()).removeRow(rowId);
    }

    public void removeAllRows() {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        model.removeAllRows();
    }

    public int getRowCount() {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        return model.getRowCount();
    }

    public List<Object> getRow(int rowId) {
        return ((SrTableModel)this.m_table.getModel()).getRow(rowId);
    }

    public final boolean isEnabledRow(int aRow) {
        int numRowsInTable = this.getRowCount();
        if (aRow < 0 || numRowsInTable > 0 && aRow >= numRowsInTable) {
            throw new IllegalArgumentException("Row index " + aRow + " exceeds table bounds");
        }
        return !this.myDisabledRows.contains(aRow);
    }

    public final void clearDisabledRowsState() {
        this.myDisabledRows.clear();
        this.repaint();
    }

    public final void setEnabledRow(int aRow, boolean aEnabled) {
        if (aRow < 0 || aRow >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index " + aRow + " exceeds table bounds");
        }
        if (this.isEnabledRow(aRow) == aEnabled) {
            return;
        }
        if (!aEnabled) {
            this.myDisabledRows.add(aRow);
            ListSelectionModel selectionModel = this.getTable().getSelectionModel();
            if (selectionModel.isSelectedIndex(aRow)) {
                selectionModel.removeSelectionInterval(aRow, aRow);
            }
        } else {
            this.myDisabledRows.remove(aRow);
        }
        this.repaint();
    }

    public List getAllRows() {
        ArrayList rows = new ArrayList();
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            ArrayList<String> ar = new ArrayList<String>();
            for (int j = 0; j < this.m_table.getModel().getColumnCount(); ++j) {
                Object o = model.getValueAt(i, j);
                String val = String.valueOf(o);
                ar.add(val);
            }
            rows.add(ar);
        }
        return rows;
    }

    public void forceInvalidate() {
        super.invalidate();
    }

    public int getSelectedRow() {
        return this.m_table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        int rowCount = this.getRowCount();
        ListSelectionModel seletionModel = this.m_table.getSelectionModel();
        for (int i = 0; i < rowCount; ++i) {
            if (!seletionModel.isSelectedIndex(i)) continue;
            selection.add(i);
        }
        int[] selectionInts = new int[selection.size()];
        int loopCounter = 0;
        for (Integer row : selection) {
            selectionInts[loopCounter] = row;
            ++loopCounter;
        }
        return selectionInts;
    }

    public int[] getUnselectedRows() {
        ArrayList<Integer> unSelectedList = new ArrayList<Integer>();
        int rowCount = this.getRowCount();
        ListSelectionModel seletionModel = this.m_table.getSelectionModel();
        for (int i = 0; i < rowCount; ++i) {
            if (seletionModel.isSelectedIndex(i)) continue;
            unSelectedList.add(i);
        }
        int[] unselectedInts = new int[unSelectedList.size()];
        int loopCounter = 0;
        for (Integer row : unSelectedList) {
            unselectedInts[loopCounter] = row;
            ++loopCounter;
        }
        return unselectedInts;
    }

    public int getSelectedColumn() {
        return this.m_table.getSelectedColumn();
    }

    protected void beforeClearSelection() {
    }

    public String exportTable() {
        return this.exportTable(true, ROW_DEL, COLUMN_DEL);
    }

    public String exportTable(boolean useHeader) {
        return this.exportTable(useHeader, ROW_DEL, COLUMN_DEL);
    }

    public String exportTable(boolean useHeader, String rowDel, String colDel) {
        int i;
        StringBuffer line = new StringBuffer();
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        if (useHeader) {
            for (i = 0; i < model.getColumnCount(); ++i) {
                String defColName = ((SrTableModel)this.m_table.getModel()).getColumnName(i);
                if (i == 0) {
                    line.append(defColName);
                    continue;
                }
                line.append(colDel + defColName);
            }
            line.append(rowDel);
        }
        for (i = 0; i < model.getRowCount(); ++i) {
            List<Object> row = model.getRow(i);
            Object[] arr = row.toArray();
            for (int j = 0; j < arr.length; ++j) {
                Object o = arr[j];
                String item = o.toString();
                if (j == 0) {
                    line.append(item);
                    continue;
                }
                line.append(colDel + item);
            }
            line.append(rowDel);
        }
        return line.toString();
    }

    public SrComponent[] getDefaults() {
        return ((SrTableModel)this.m_table.getModel()).getDefaults();
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != this.m_selMode) {
            this.m_selMode = selectionMode;
            this.m_table.setSelectionMode(this.m_selMode);
        }
    }

    public void setRowSelectionSet(int first, int second) {
        this.m_table.clearSelection();
        this.m_table.getSelectionModel().setSelectionInterval(first, second);
    }

    public void scrollToRow(int row) {
        this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 0, true));
    }

    private void resizeColumnAccordingToLargestCell(TableColumn tableCol, int colIndex) {
        if (colIndex != -1 && tableCol != null) {
            Component h = tableCol.getHeaderRenderer().getTableCellRendererComponent(this.m_table, tableCol.getHeaderValue(), false, false, 0, 0);
            int max = h.getPreferredSize().width;
            SrTableModel model = (SrTableModel)this.m_table.getModel();
            SrComponent colDef = model.getDefault(colIndex);
            if (!(colDef instanceof SrCheckbox)) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    Object o = model.getValueAt(i, colIndex);
                    Component com = tableCol.getCellRenderer().getTableCellRendererComponent(this.m_table, o, false, false, i, colIndex);
                    int w = com.getPreferredSize().width;
                    max = Math.max(max, w);
                }
            }
            if (max != -1) {
                tableCol.setPreferredWidth(max + 20);
            }
        }
    }

    private void setBackSelection(Vector selRows) {
        if (selRows.size() > 0) {
            int i;
            int[] newIndex = new int[selRows.size()];
            int index = 0;
            SrTableModel model = (SrTableModel)this.m_table.getModel();
            for (i = 0; i < model.getRowCount(); ++i) {
                if (!selRows.contains(model.getRow(i).toString())) continue;
                newIndex[index++] = i;
                if (index == selRows.size()) break;
            }
            this.m_table.clearSelection();
            for (i = 0; i < newIndex.length; ++i) {
                this.m_table.addRowSelectionInterval(newIndex[i], newIndex[i]);
            }
        }
    }

    public SrTableColumns getTableCols() {
        return this.m_tableCols;
    }

    public JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    public void enableSort(boolean allowSort) {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        model.enableSort(allowSort);
        if (!allowSort) {
            TableColumn column = this.m_table.getColumnModel().getColumn(0);
            String name = model.getColumnName(column.getModelIndex());
            column.setHeaderValue(name);
        }
    }

    public void invokeColumnSortOnStartup(Vector colSet) {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        model.m_sortColVec.clear();
        model.m_sortColVec.addAll(colSet);
        if (model.isSortAllowed() && model.getRowCount() > 0) {
            this.sort(model);
        }
    }

    public void invokeColumnSortOnStartup(int colsIndex, boolean asc) {
        Vector<int[]> colSet = new Vector<int[]>(1);
        int order = 1;
        if (!asc) {
            order = 0;
        }
        colSet.add(new int[]{colsIndex, order});
        this.invokeColumnSortOnStartup(colSet);
    }

    public void addNewColumnGroup(String groupName, int[] listOfColumnIndexes) {
        if (listOfColumnIndexes.length > 0) {
            TableColumnModel cm = this.m_table.getColumnModel();
            ColumnGroup group = new ColumnGroup(groupName);
            for (int i = 0; i < listOfColumnIndexes.length; ++i) {
                group.add(cm.getColumn(listOfColumnIndexes[i]));
            }
            GroupableTableHeader header = (GroupableTableHeader)this.m_table.getTableHeader();
            header.addColumnGroup(group);
        }
    }

    public void hideTableColumn(int column) {
        if (this.m_table.getColumnModel().getColumn(column) != null) {
            this.m_table.getColumnModel().getColumn(column).setMinWidth(0);
            this.m_table.getColumnModel().getColumn(column).setMaxWidth(0);
        }
    }

    public void hideTableColumn(String columnName) {
        int colIndex = ((SrTableModel)this.m_table.getModel()).getColumnIndex(columnName);
        if (colIndex != -1) {
            this.hideTableColumn(colIndex);
        }
    }

    public void showHiddenTableColumn(int column) {
        TableColumn myColumn = this.m_table.getColumnModel().getColumn(column);
        if (myColumn != null && myColumn.getMaxWidth() == 0) {
            Component c = myColumn.getHeaderRenderer().getTableCellRendererComponent(this.m_table, myColumn.getHeaderValue(), false, false, -1, column);
            int headerWidth = c.getPreferredSize().width + 1;
            myColumn.setMaxWidth(Integer.MAX_VALUE);
            myColumn.setPreferredWidth(headerWidth);
            myColumn.setMinWidth(15);
        }
    }

    public void showHiddenTableColumn(String columnName) {
        int colIndex = ((SrTableModel)this.m_table.getModel()).getColumnIndex(columnName);
        if (colIndex != -1) {
            this.showHiddenTableColumn(colIndex);
        }
    }

    public void changeGroupHeaderName(String oldGroupName, String newGroupName) {
        ColumnGroup g = ((GroupableTableHeader)this.m_table.getTableHeader()).getGroupByName(oldGroupName);
        if (g != null) {
            Vector cols = g.getGroupTableColumns();
            for (int i = 0; i < cols.size(); ++i) {
                TableColumn col = (TableColumn)cols.get(i);
                String colName = (String)col.getHeaderValue();
                if (colName.indexOf(oldGroupName) == -1) continue;
                String newColName = colName.replaceAll(oldGroupName, "").trim();
                StringBuffer buff = new StringBuffer(newGroupName);
                buff.append(" ");
                buff.append(newColName);
                this.getModel().setColumnName(colName, buff.toString());
                col.setHeaderValue(buff.toString());
            }
            g.setHeaderValue(newGroupName);
            this.m_table.getTableHeader().repaint();
        }
    }

    public void addTableCellEditListener(TableCellEditListener listener) {
        this.listenerList.remove(TableCellEditListener.class, listener);
        this.listenerList.add(TableCellEditListener.class, listener);
    }

    public void removeTableCellEditListener(TableCellEditListener listener) {
        this.listenerList.remove(TableCellEditListener.class, listener);
    }

    @Override
    public void tableEditingCanceled(TableCellEditEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableCellEditListener.class) continue;
            ((TableCellEditListener)listeners[i + 1]).tableEditingCanceled(e);
        }
    }

    @Override
    public void tableEditingStarted(TableCellEditEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableCellEditListener.class) continue;
            ((TableCellEditListener)listeners[i + 1]).tableEditingStarted(e);
        }
    }

    @Override
    public void tableEditingStopped(TableCellEditEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableCellEditListener.class) continue;
            ((TableCellEditListener)listeners[i + 1]).tableEditingStopped(e);
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        this.m_popup.show(e);
    }

    private void sort(SrTableModel model) {
        Vector colSet = model.m_sortColVec;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = this.m_table.getColumnModel().getColumn(i);
            String name = model.getColumnName(column.getModelIndex());
            JLabel lbl = null;
            int rec = this.findColInSet(colSet, i);
            if (rec != -1) {
                int[] param = (int[])colSet.get(rec);
                lbl = new JLabel();
                ImageIcon icon = null;
                icon = param[1] == 1 ? ImageObject.UP_ARROW.getImageIcon() : ImageObject.DOWN_ARROW.getImageIcon();
                if (colSet.size() > 1) {
                    lbl.setIcon(SrSwingUtils.drawStringOnIcon(icon, new Font("Courier New", 0, 9), Color.BLACK, String.valueOf(rec + 1), 7, 1));
                } else {
                    lbl.setIcon(icon);
                }
                lbl.setText(name);
            }
            if (lbl != null) {
                column.setHeaderValue(lbl);
                Component c = column.getHeaderRenderer().getTableCellRendererComponent(this.m_table, column.getHeaderValue(), false, false, -1, i);
                int newSize = c.getPreferredSize().width + 1;
                if (newSize <= column.getPreferredWidth()) continue;
                column.setPreferredWidth(newSize);
                continue;
            }
            column.setHeaderValue(name);
        }
        this.m_table.getTableHeader().repaint();
        model.sortColumn();
    }

    private int findColInSet(Vector v, int index) {
        int found = -1;
        for (int i = 0; i < v.size(); ++i) {
            int[] arr = (int[])v.get(i);
            if (arr[0] != index) continue;
            found = i;
            break;
        }
        return found;
    }

    protected void setSelectedRows(Set<Integer> rows) {
        this.getTable().clearSelection();
        int startRow = -1;
        int endRow = -1;
        for (int row = 0; row < this.getRowCount(); ++row) {
            while (row < this.getRowCount() && !rows.contains(row)) {
                ++row;
            }
            if (row == this.getRowCount()) {
                return;
            }
            startRow = row++;
            while (row < this.getRowCount() && rows.contains(row)) {
                ++row;
            }
            endRow = row - 1;
            this.getTable().getSelectionModel().addSelectionInterval(startRow, endRow);
        }
    }

    public <T> T getSelctedValue(String aColumnName) {
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        int col = this.getModel().getColumnIndex(aColumnName);
        return (T)this.getModel().getValueAt(row, col);
    }

    public <T> List<T> getSelctedValues(String aColumnName) {
        ArrayList<Object> retValues = new ArrayList<Object>();
        int col = this.getModel().getColumnIndex(aColumnName);
        int[] selection = this.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            retValues.add(this.getModel().getValueAt(selection[i], col));
        }
        return retValues;
    }

    public <T> T getValueAt(int aRow, int aCol) {
        return (T)this.m_table.getValueAt(aRow, aCol);
    }

    private static class SrTableSelectionModel
    extends DefaultListSelectionModel {
        SrTablePanel myTablePanel;
        private static final long serialVersionUID = 1L;

        SrTableSelectionModel(SrTablePanel aTablePanel) {
            if (aTablePanel == null) {
                throw new IllegalArgumentException("Table panel must be supplied");
            }
            this.myTablePanel = aTablePanel;
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            int sign = index1 != index0 ? (index1 - index0) / Math.abs(index1 - index0) : 1;
            int bigIndex = Math.max(index0, index1);
            int smallIndex = Math.min(index0, index1);
            int fromIndex = -1;
            int toIndex = -1;
            for (int i = index0; i <= bigIndex && i >= smallIndex; i += sign) {
                boolean isLastSelection;
                if (fromIndex < 0 && this.myTablePanel.isEnabledRow(i)) {
                    fromIndex = i;
                }
                if (this.myTablePanel.isEnabledRow(i)) {
                    toIndex = i;
                }
                boolean bl = isLastSelection = i + sign > bigIndex || i + sign < smallIndex;
                if (!isLastSelection && this.myTablePanel.isEnabledRow(i)) continue;
                if (fromIndex > -1 && toIndex > -1) {
                    super.addSelectionInterval(fromIndex, toIndex);
                }
                fromIndex = -1;
                toIndex = -1;
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            int sign = index1 != index0 ? (index1 - index0) / Math.abs(index1 - index0) : 1;
            int bigIndex = Math.max(index0, index1);
            int smallIndex = Math.min(index0, index1);
            int fromIndex = -1;
            int toIndex = -1;
            boolean isFirstSelection = true;
            for (int i = index0; i <= bigIndex && i >= smallIndex; i += sign) {
                boolean isLastSelection;
                if (fromIndex < 0 && this.myTablePanel.isEnabledRow(i)) {
                    fromIndex = i;
                }
                if (this.myTablePanel.isEnabledRow(i)) {
                    toIndex = i;
                }
                boolean bl = isLastSelection = i + sign > bigIndex || i + sign < smallIndex;
                if (!isLastSelection && this.myTablePanel.isEnabledRow(i)) continue;
                if (fromIndex > -1 && toIndex > -1) {
                    if (isFirstSelection) {
                        super.setSelectionInterval(fromIndex, toIndex);
                        isFirstSelection = false;
                    } else {
                        super.addSelectionInterval(fromIndex, toIndex);
                    }
                }
                fromIndex = -1;
                toIndex = -1;
            }
        }
    }

    class SrTableMouseAdapter
    extends MouseAdapter {
        SrTableMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = SrTablePanel.this.m_table.rowAtPoint(e.getPoint());
            if (row == -1) {
                SrTablePanel.this.beforeClearSelection();
                SrTablePanel.this.m_table.clearSelection();
            } else if (SwingUtilities.isRightMouseButton(e)) {
                if (SrTablePanel.this.m_table.getSelectedRowCount() == 0 || !SrTablePanel.this.m_table.getSelectionModel().isSelectedIndex(row)) {
                    SrTablePanel.this.m_table.getSelectionModel().setSelectionInterval(row, row);
                }
                if (SrTablePanel.this.m_popup != null) {
                    TableCellEditor editor;
                    int editRow = SrTablePanel.this.m_table.getEditingRow();
                    int editCol = SrTablePanel.this.m_table.getEditingColumn();
                    if (editRow >= 0 && editCol >= 0 && (editor = SrTablePanel.this.m_table.getCellEditor(editRow, editCol)) != null) {
                        editor.stopCellEditing();
                    }
                    SrTablePanel.this.m_popup.show(e);
                }
            }
        }
    }

    public class AlignedHeaderCellRenderer
    implements TableCellRenderer {
        float m_alignment;

        public AlignedHeaderCellRenderer(float alignment) {
            this.m_alignment = alignment;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GroupableTableHeader th = (GroupableTableHeader)table.getTableHeader();
            TableCellRenderer originRenderer = th.getDefaultRenderer();
            Component originRendererComp = originRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String name = SrTablePanel.this.getModel().getColumnName(column);
            TableColumn col = table.getColumnModel().getColumn(column);
            List colGroups = th.getColumnGroups(col);
            if (colGroups != null) {
                for (int index = 0; index < colGroups.size(); ++index) {
                    ColumnGroup group = (ColumnGroup)colGroups.get(index);
                    String groupName = (String)group.getHeaderValue();
                    name = name.replaceAll(groupName, "").trim();
                }
            }
            if (originRendererComp instanceof JLabel) {
                JLabel lbl = (JLabel)originRendererComp;
                lbl.setHorizontalTextPosition(2);
                lbl.setVerticalTextPosition(3);
                lbl.setIconTextGap(10);
                if (value instanceof JLabel) {
                    lbl.setIcon(((JLabel)value).getIcon());
                }
                lbl.setText(name);
                lbl.setBackground(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.TABLE_HEADER_BACKGROUND_COLOR));
                Color borderColor = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.TABLE_HEADER_BORDER_COLOR);
                SrLineBorder lineBorder = new SrLineBorder(0, 0, 1, 1, borderColor);
                Border emptyBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
                lbl.setBorder(BorderFactory.createCompoundBorder(lineBorder, emptyBorder));
            }
            return originRendererComp;
        }
    }

    class HeaderSortListener
    extends MouseInputAdapter {
        private boolean m_ctrlDown = false;

        HeaderSortListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.checkCursor(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.removeSortCursor();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.checkCursor(e);
        }

        private void checkCursor(MouseEvent e) {
            if (e.isControlDown()) {
                this.m_ctrlDown = true;
            } else {
                this.removeSortCursor();
            }
        }

        private void removeSortCursor() {
            if (this.m_ctrlDown) {
                SrTablePanel.this.m_table.getTableHeader().setCursor(Cursor.getDefaultCursor());
                this.m_ctrlDown = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Cursor cursor = e.getComponent().getCursor();
            if (cursor.equals(Cursor.getPredefinedCursor(11)) || cursor.equals(Cursor.getPredefinedCursor(10))) {
                int columnModelIndex;
                TableColumnModel colModel;
                TableColumn tableCol;
                int modelIndex;
                if (e.getClickCount() == 2 && (modelIndex = (tableCol = (colModel = SrTablePanel.this.m_table.getColumnModel()).getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX() - 5))).getModelIndex()) != -1) {
                    SrTablePanel.this.resizeColumnAccordingToLargestCell(tableCol, modelIndex);
                }
            } else {
                SrTableModel model = (SrTableModel)SrTablePanel.this.m_table.getModel();
                if (model.isSortAllowed() && e.getClickCount() == 1 && model.getRowCount() > 0) {
                    int columnModelIndex;
                    int[] rows = SrTablePanel.this.m_table.getSelectedRows();
                    Vector<String> selRows = new Vector<String>(rows.length);
                    for (int i = 0; i < rows.length; ++i) {
                        List<Object> rowVec;
                        if (rows[i] == -1 || (rowVec = model.getRow(rows[i])) == null) continue;
                        selRows.add(rowVec.toString());
                    }
                    TableColumnModel colModel = SrTablePanel.this.m_table.getColumnModel();
                    int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                    if (modelIndex < 0) {
                        return;
                    }
                    boolean isControlDown = e.isControlDown();
                    int colIndex = Math.abs(columnModelIndex);
                    Vector colSet = model.m_sortColVec;
                    int colListSize = colSet.size();
                    if (!isControlDown && colSet.size() >= 1) {
                        int[] sortParam = (int[])colSet.get(0);
                        int newOrder = sortParam[1];
                        if (sortParam[0] == colIndex) {
                            newOrder ^= 1;
                        }
                        colSet.clear();
                        colSet.addElement(new int[]{colIndex, newOrder});
                    } else if (colListSize == 0) {
                        colSet.addElement(new int[]{colIndex, 1});
                    } else if (isControlDown) {
                        if (colListSize >= 1) {
                            int rec = SrTablePanel.this.findColInSet(colSet, colIndex);
                            if (rec != -1) {
                                int[] sortParam = (int[])colSet.get(rec);
                                sortParam[1] = sortParam[1] ^ 1;
                            } else {
                                int[] lastSortParam = (int[])colSet.get(colListSize - 1);
                                colSet.addElement(new int[]{colIndex, lastSortParam[1]});
                            }
                        }
                    } else {
                        return;
                    }
                    SrTablePanel.this.sort(model);
                    SrTablePanel.this.setBackSelection(selRows);
                }
            }
        }
    }
}

