/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.TableSelectionSaveListener;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SrFilterSimpleRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class SrTableModel
extends AbstractTableModel
implements Comparator {
    private Vector<SrComponent> m_defVals;
    private Vector<String> m_columns;
    protected ArrayList<ArrayList<Object>> m_data;
    private boolean[] m_readOnly;
    private boolean m_allowSort;
    private SrTableColumns m_cols;
    private Comparator m_comp;
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    protected int m_sortColumn;
    protected int m_sortOrder;
    protected int m_runningIndex;
    public Vector m_sortColVec;
    private ArrayList<SrFilterSimpleRule<List>> myTableFilters = new ArrayList();

    public SrTableModel(SrTableColumns cols) {
        String[] columns = cols.getColumnNames();
        SrComponent[] defs = cols.getColumnObjects();
        this.m_defVals = new Vector(columns.length);
        this.m_columns = new Vector(columns.length);
        this.m_data = new ArrayList();
        this.m_comp = this;
        this.enableSort(true);
        for (int i = 0; i < columns.length; ++i) {
            this.m_columns.add(i, columns[i]);
            this.m_defVals.add(i, defs[i]);
        }
        this.m_readOnly = cols.getColumnReadOnlyPermission();
        this.m_cols = cols;
        this.m_sortColVec = new Vector();
    }

    public void addRow(Object[] row) {
        this.addRow(row, -1);
    }

    public void addRow(Object[] row, int place) {
        this.addRowQuetly(row, place);
        if (place >= 0 && place < this.m_data.size()) {
            this.fireTableRowsInserted(place, place);
        } else {
            this.fireTableRowsInserted(this.m_data.size() - 1, this.m_data.size() - 1);
        }
    }

    protected void addRowQuetly(Object[] row, int place) {
        int cols = this.m_columns.size();
        if (row.length < cols) {
            System.out.println("Error in " + this.getClass().getName() + ":addRowQuetly - not enough data, received: " + row.length + " expected: " + cols);
            return;
        }
        ArrayList<Object> newRow = new ArrayList<Object>();
        for (int i = 0; i < cols; ++i) {
            newRow.add(i, row[i]);
        }
        for (SrFilterSimpleRule<List> rowFilter : this.myTableFilters) {
            if (rowFilter.isValid(newRow, null)) continue;
            return;
        }
        if (place >= 0) {
            this.m_data.add(place, newRow);
        } else {
            this.m_data.add(newRow);
        }
    }

    public void editRow(int selectedRow, Object[] row) {
        int i = row.length;
        while (i-- > 0) {
            this.setValueAt(row[i], selectedRow, i);
        }
        ArrayList<Object> changedRow = this.m_data.get(selectedRow);
        for (SrFilterSimpleRule<List> rowFilter : this.myTableFilters) {
            if (rowFilter.isValid(changedRow, null)) continue;
            this.removeRow(selectedRow);
            return;
        }
        this.fireTableRowsUpdated(selectedRow, selectedRow);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.m_readOnly == null || col >= this.m_readOnly.length || !this.m_readOnly[col];
    }

    public Class getColumnClass(int c) {
        Object o = this.getValueAt(0, c);
        if (o != null) {
            return o.getClass();
        }
        if (this.m_defVals.get(c) != null) {
            return this.m_defVals.get(c).getClass();
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    public int getLastRowIndex() {
        int size = this.m_data.size() - 1;
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    @Override
    public String getColumnName(int col) {
        String name = null;
        if (col < this.m_columns.size() && col >= 0) {
            name = this.m_columns.get(col);
        }
        return name;
    }

    public void setColumnName(String oldName, String newName) {
        int index = this.m_columns.indexOf(oldName);
        if (index != -1) {
            this.m_columns.setElementAt(newName, index);
        }
    }

    public int getColumnIndex(String name) {
        return this.m_columns.indexOf(name);
    }

    public SrComponent[] getDefaults() {
        return (SrComponent[])this.m_defVals.toArray();
    }

    public SrComponent getDefault(int col) {
        return this.m_defVals.get(col);
    }

    public void setDefaults(int col, SrComponent obj) {
        this.m_defVals.add(col, obj);
    }

    public List<Object> getRow(int row) {
        List v = null;
        if (row < this.getRowCount() && row >= 0) {
            v = this.m_data.get(row);
        }
        return v;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.m_data.size() > row) {
            return this.m_data.get(row).get(col);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.m_data.size() > row) {
            this.m_data.get(row).set(col, value);
            this.fireTableCellUpdated(row, col);
        }
    }

    public void removeRow(int row) {
        if (row < this.getRowCount() && row >= 0) {
            this.m_data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void removeRowQuetly(int row) {
        if (row < this.getRowCount() && row >= 0) {
            this.m_data.remove(row);
        }
    }

    public void removeAllRows() {
        int size = this.getRowCount();
        this.m_data.clear();
        if (size > 0) {
            this.fireTableRowsDeleted(0, size);
        }
    }

    public int findRow(Object aValue) {
        int rowIndex = -1;
        for (ArrayList<Object> row : this.m_data) {
            ++rowIndex;
            if (!row.contains(aValue)) continue;
            return rowIndex;
        }
        return -1;
    }

    public int findRow(Object aValue, String aColumnName) {
        List colValues = this.getColumnValues(aColumnName);
        return colValues.indexOf(aValue);
    }

    public Object[] getColumns() {
        return this.m_columns.toArray();
    }

    public SrTableColumns getTableColumnsObject() {
        return this.m_cols;
    }

    public <T> List<T> getColumnValues(String aColumnName) {
        int colIndex = this.getColumnIndex(aColumnName);
        ArrayList view = new ArrayList();
        for (ArrayList<Object> row : this.m_data) {
            view.add(row.get(colIndex));
        }
        return view;
    }

    public void enableSort(boolean sort) {
        this.m_allowSort = sort;
    }

    public boolean isSortAllowed() {
        return this.m_allowSort;
    }

    public void sortColumn() {
        this.m_runningIndex = 0;
        this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
        this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
        Collections.sort(this.m_data, this.m_comp);
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void setSortComperator(Comparator comp) {
        this.m_comp = comp;
    }

    public void addSelSaveListeners(TableSelectionSaveListener l) {
        this.m_listeners.add(l);
    }

    public void removeSelSaveListeners(TableSelectionSaveListener l) {
        this.m_listeners.remove(l);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && this.m_sortOrder == 0) {
            return this.order(-1);
        }
        if (o2 == null) {
            return this.order(1);
        }
        List vect1 = (List)o1;
        List vect2 = (List)o2;
        Object obj1 = vect1.get(this.m_sortColumn);
        Object obj2 = vect2.get(this.m_sortColumn);
        if (obj1 == null || obj1.toString().length() == 0) {
            return this.order(-1);
        }
        if (obj2 == null || obj2.toString().length() == 0) {
            return this.order(1);
        }
        int result = 0;
        if (obj1 instanceof Comparable && obj2 instanceof Comparable) {
            Comparable col1 = (Comparable)obj1;
            Comparable col2 = (Comparable)obj2;
            if (obj1.getClass().isAssignableFrom(obj2.getClass())) {
                result = this.order(col1.compareTo(col2));
            } else if (obj2.getClass().isAssignableFrom(obj1.getClass())) {
                result = this.order(col2.compareTo(col1));
            }
        } else {
            return this.order(-1);
        }
        if (result == 0 && this.m_sortColVec.size() > this.m_runningIndex + 1) {
            ++this.m_runningIndex;
            int saveSortCol = this.m_sortColumn;
            int saveSortOrder = this.m_sortOrder;
            this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
            this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
            result = this.compare(o1, o2);
            this.m_sortColumn = saveSortCol;
            this.m_sortOrder = saveSortOrder;
            --this.m_runningIndex;
        }
        return result;
    }

    protected int order(int i) {
        if (this.m_sortOrder == 0) {
            return -i;
        }
        return i;
    }

    public abstract void removeListeners();

    public abstract void addListeners();

    public void initModelData() {
    }

    public void addFilter(SrFilterSimpleRule<List> aRowFilter) {
        Util.validateInputNotNull(aRowFilter, "Table filter");
        this.myTableFilters.add(aRowFilter);
        int i = this.m_data.size();
        while (i-- > 0) {
            ArrayList<Object> row = this.m_data.get(i);
            if (aRowFilter.isValid(row, null)) continue;
            this.removeRow(i);
        }
    }
}

