/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrWidget;
import java.util.List;
import java.util.Vector;

public class SrTableColumns {
    private Vector<SrWidget> m_columns;
    private String[] m_colNames;
    private boolean[] m_colReadOnly;
    private SrComponent[] m_colObjects;

    public SrTableColumns() {
    }

    public SrTableColumns(Vector<SrWidget> columns) {
        this.setColumns(columns);
    }

    public void setColumns(List<SrWidget> columns) {
        this.m_columns = new Vector<SrWidget>(columns);
        this.m_colNames = new String[this.m_columns.size()];
        this.m_colReadOnly = new boolean[this.m_columns.size()];
        this.m_colObjects = new SrComponent[this.m_columns.size()];
        for (int i = 0; i < this.m_columns.size(); ++i) {
            SrWidget widget = this.m_columns.get(i);
            this.m_colNames[i] = widget.getName();
            this.m_colReadOnly[i] = widget.isReadOnly();
            this.m_colObjects[i] = widget.getComponent();
        }
    }

    public SrWidget getWidgetByName(String widgetName) {
        SrWidget widget = null;
        for (int i = 0; i < this.m_columns.size(); ++i) {
            SrWidget w = this.m_columns.get(i);
            if (!w.getName().equals(widgetName)) continue;
            widget = w;
            break;
        }
        return widget;
    }

    public SrWidget getWidgetByIndex(int index) {
        SrWidget widget = null;
        if (index < this.m_columns.size() && index >= 0) {
            widget = this.m_columns.get(index);
        }
        return widget;
    }

    private int getWidgetIndex(SrWidget w) {
        int index = -1;
        for (int i = 0; i < this.m_columns.size(); ++i) {
            SrWidget widget = this.m_columns.get(i);
            if (!widget.getName().equals(w.getName())) continue;
            index = i;
            break;
        }
        return index;
    }

    public void setWidgetProperties(SrWidget w) {
        int index = this.getWidgetIndex(w);
        if (index != -1) {
            this.m_colReadOnly[index] = w.isReadOnly();
            this.m_colObjects[index] = w.getComponent();
        }
    }

    public int getColumnsCount() {
        return this.m_columns.size();
    }

    public String[] getColumnNames() {
        return this.m_colNames;
    }

    public boolean[] getColumnReadOnlyPermission() {
        return this.m_colReadOnly;
    }

    public SrComponent[] getColumnObjects() {
        return this.m_colObjects;
    }
}

