/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrDefaultCellEditor;
import com.sanrad.swing.table.event.TableCellEditEvent;
import com.sanrad.swing.table.event.TableCellEditListener;
import java.awt.Container;
import java.awt.Font;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jvnet.lafwidget.utils.LafConstants;

public class SrTable
extends JTable {
    private Object myEditorPrevValue;

    public SrTable() {
        this.initDefaultUIView();
    }

    public SrTable(TableModel model) {
        super(model);
        this.initDefaultUIView();
    }

    @Override
    public void doLayout() {
        this.autoResizeMode = 2;
        super.doLayout();
        this.autoResizeMode = 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent;
        if (this.autoResizeMode == 0 && (parent = this.getParent()) instanceof JViewport) {
            return parent.getSize().getWidth() >= this.getPreferredSize().getWidth();
        }
        return super.getScrollableTracksViewportWidth();
    }

    private void initDefaultUIView() {
        this.putClientProperty("lafwidgets.animationKind", LafConstants.AnimationKind.NONE);
        this.setGridColor(LookAndFill.TABLE_SCROLL_GRID_COLOR);
        this.setFont(LookAndFill.GENERAL_FONT);
        this.setSelectionBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
        this.setSelectionForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        JTableHeader header = this.getTableHeader();
        this.setAutoCreateColumnsFromModel(false);
        header.setFont(new Font("Verdana", 0, 9));
        header.setUpdateTableInRealTime(true);
    }

    public void addTableCellEditListener(TableCellEditListener listener) {
        this.listenerList.remove(TableCellEditListener.class, listener);
        this.listenerList.add(TableCellEditListener.class, listener);
    }

    public void removeTableCellEditListener(TableCellEditListener listener) {
        this.listenerList.remove(TableCellEditListener.class, listener);
    }

    @Override
    public final boolean editCellAt(int row, int column, EventObject e) {
        Object cellValue = this.getModel().getValueAt(row, column);
        boolean isEditing = super.editCellAt(row, column, e);
        if (isEditing) {
            TableCellEditor editor = this.getCellEditor();
            this.myEditorPrevValue = editor != null ? editor.getCellEditorValue() : null;
            TableCellEditEvent cellEditEvent = new TableCellEditEvent(this, cellValue, this.myEditorPrevValue, row, column);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableCellEditListener.class) continue;
                ((TableCellEditListener)listeners[i + 1]).tableEditingStarted(cellEditEvent);
            }
        }
        return isEditing;
    }

    @Override
    public final void editingCanceled(ChangeEvent e) {
        int row = this.getEditingRow();
        int column = this.getEditingColumn();
        TableCellEditor editor = this.getCellEditor();
        Object editorValue = editor != null ? editor.getCellEditorValue() : null;
        super.editingCanceled(e);
        TableCellEditEvent cellEditEvent = new TableCellEditEvent(this, this.getModel().getValueAt(row, column), editorValue, row, column);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableCellEditListener.class) continue;
            ((TableCellEditListener)listeners[i + 1]).tableEditingCanceled(cellEditEvent);
        }
    }

    @Override
    public final void editingStopped(ChangeEvent e) {
        Object editorValue;
        int row = this.getEditingRow();
        int column = this.getEditingColumn();
        TableCellEditor editor = this.getCellEditor();
        Object object = editorValue = editor != null ? editor.getCellEditorValue() : null;
        if (editorValue == null || editorValue.toString().trim().length() == 0) {
            editor.cancelCellEditing();
            return;
        }
        Object cellPrevValue = this.getModel().getValueAt(row, column);
        super.editingStopped(e);
        Object cellValue = this.getModel().getValueAt(row, column);
        if (editor instanceof SrDefaultCellEditor && ((SrDefaultCellEditor)editor).isRollbackAfterEditing()) {
            this.setValueAt(cellPrevValue, row, column);
        }
        TableCellEditEvent cellEditEvent = new TableCellEditEvent(this, cellValue, cellPrevValue, editorValue, this.myEditorPrevValue, row, column);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableCellEditListener.class) continue;
            ((TableCellEditListener)listeners[i + 1]).tableEditingStopped(cellEditEvent);
        }
    }
}

