/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SrSwingUtils {
    private static final Font STRIGN_FONT = new Font("Courier New", 1, 12);

    public static ImageIcon drawStringOnIcon(ImageIcon icon, Font font, Color color, String str) {
        return SrSwingUtils.drawStringOnIcon(icon, font, color, str, 0, 0);
    }

    public static ImageIcon drawStringOnIcon(ImageIcon icon, Font font, Color color, String str, int xOffset, int yOffset) {
        ImageIcon newIcon = null;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight();
        BufferedImage bi = new BufferedImage(iconW, iconH, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(icon.getImage(), 0, 0, iconW, iconH, null);
        g.setColor(color);
        g.setFont(font);
        int strH = g.getFontMetrics().getHeight();
        int strW = g.getFontMetrics().stringWidth(str);
        if (strW > iconW || strH > iconH) {
            return newIcon;
        }
        int strXcord = iconW / 2 - strW / 2;
        int strYcord = iconH / 2 + strH / 4;
        ((Graphics)g).drawString(str, strXcord + xOffset, strYcord + yOffset);
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }

    public static ImageIcon horizontallyJoinTwoIcons(ImageIcon leftIcon, ImageIcon rightIcon, int wDistance) {
        int rightIconHOffset;
        int leftIconHOffset;
        ImageIcon newIcon = null;
        int leftIconW = leftIcon == null ? 0 : leftIcon.getIconWidth();
        int leftIconH = leftIcon == null ? 0 : leftIcon.getIconHeight();
        int rightIconW = rightIcon == null ? 0 : rightIcon.getIconWidth();
        int rightIconH = rightIcon == null ? 0 : rightIcon.getIconHeight();
        int maxH = leftIconH > rightIconH ? leftIconH : rightIconH;
        BufferedImage bi = new BufferedImage(leftIconW + rightIconW + wDistance, maxH, 2);
        Graphics2D g = bi.createGraphics();
        int n = leftIconHOffset = leftIconH < rightIconH ? (rightIconH - leftIconH) / 2 : 0;
        if (leftIcon != null) {
            g.drawImage(leftIcon.getImage(), 0, leftIconHOffset, leftIconW, leftIconH, null);
        }
        int n2 = rightIconHOffset = leftIconHOffset == 0 ? (rightIconHOffset = (leftIconH - rightIconH) / 2) : 0;
        if (rightIcon != null) {
            g.drawImage(rightIcon.getImage(), leftIconW + wDistance, rightIconHOffset, rightIconW, rightIconH, null);
        }
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }

    public static String createHTMLToolTip(String message) {
        if (message != null) {
            StringBuffer toolTip = new StringBuffer("<html><body><table border=\"0\"><td valign=\"middle\">&nbsp;<img src=\"");
            toolTip.append(ImageObject.TOOLTIP_INFO_ICON.getImageIcon().getDescription());
            toolTip.append("\" border=0 align =\"bottom\">&nbsp;&nbsp;");
            toolTip.append(message);
            toolTip.append("</td></body></html>");
            return toolTip.toString();
        }
        return null;
    }

    public static ImageIcon drawRedStringOnIcon(ImageIcon icon, String string) {
        ImageIcon newIcon = null;
        int factor = 10;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight() + factor;
        BufferedImage bi = new BufferedImage(iconW, iconH, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(icon.getImage(), 0, 3, iconW, iconH - factor, null);
        g.setColor(Color.RED);
        g.setFont(STRIGN_FONT);
        int strH = g.getFontMetrics().getHeight();
        int strW = g.getFontMetrics().stringWidth(string);
        int strXcord = iconW / 2 - strW / 2;
        int strYcord = iconH / 2 + strH / 4;
        ((Graphics)g).drawString(string, strXcord, strYcord);
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }

    public static Container getParentOfType(Class c, Component comp) {
        Container parent = comp.getParent();
        if (parent == null || c.isAssignableFrom(parent.getClass())) {
            return parent;
        }
        return SrSwingUtils.getParentOfType(c, parent);
    }

    public static Component getChildOfType(Class c, Container parent) {
        int i;
        Component[] comps = parent.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!c.isAssignableFrom(comps[i].getClass())) continue;
            return comps[i];
        }
        for (i = 0; i < comps.length; ++i) {
            Component comp;
            if (!(comps[i] instanceof Container) || (comp = SrSwingUtils.getChildOfType(c, (Container)comps[i])) == null) continue;
            return comp;
        }
        return null;
    }

    public static Component getChildComponentByName(String aCompName, Container aParent) {
        int i;
        Component[] comps = aParent.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (!Util.equalsWithNull(aCompName, comps[i].getName())) continue;
            return comps[i];
        }
        for (i = 0; i < comps.length; ++i) {
            Component comp;
            if (!(comps[i] instanceof Container) || (comp = SrSwingUtils.getChildComponentByName(aCompName, (Container)comps[i])) == null) continue;
            return comp;
        }
        return null;
    }

    public static void setLocationOnScreenCenter(Window w) {
        Dimension screenDim = w.getToolkit().getScreenSize();
        Rectangle abounds = w.getBounds();
        w.setLocation((screenDim.width - abounds.width) / 2, (screenDim.height - abounds.height) / 2);
    }

    public static void setWindowMinimumWidthByTitleNotInvokeLater(Window aWindow, String aTitle) {
        int minWidth;
        Font titleFont;
        if (aTitle == null) {
            aTitle = "";
        }
        if ((titleFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.captionFont")) == null) {
            Font labelFont = UIManager.getFont("Label.font");
            int titleBarHeight = SrSwingUtils.getCaptionHeight(aWindow);
            FontMetrics fMetrics = aWindow.getFontMetrics(labelFont);
            int fontH = titleBarHeight > 0 ? titleBarHeight / 2 : fMetrics.getHeight();
            titleFont = labelFont.deriveFont(labelFont.getStyle(), fontH);
        }
        if ((minWidth = aWindow.getFontMetrics(titleFont).stringWidth(aTitle) + 70) > aWindow.getWidth()) {
            aWindow.setSize(new Dimension(minWidth, aWindow.getSize().height));
        }
    }

    public static void setWindowMinimumWidthByTitle(final Window aWindow, String aTitle) {
        Font titleFont;
        if (aTitle == null) {
            aTitle = "";
        }
        if ((titleFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.captionFont")) == null) {
            Font labelFont = UIManager.getFont("Label.font");
            int titleBarHeight = SrSwingUtils.getCaptionHeight(aWindow);
            FontMetrics fMetrics = aWindow.getFontMetrics(labelFont);
            int fontH = titleBarHeight > 0 ? titleBarHeight / 2 : fMetrics.getHeight();
            titleFont = labelFont.deriveFont(labelFont.getStyle(), fontH);
        }
        final int minWidth = aWindow.getFontMetrics(titleFont).stringWidth(aTitle) + 70;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (minWidth > aWindow.getWidth()) {
                    aWindow.setSize(new Dimension(minWidth, aWindow.getSize().height));
                }
            }
        });
    }

    public static int getCaptionHeight(Window aWindow) {
        int rootPaneHeight = 0;
        if (aWindow instanceof JFrame) {
            rootPaneHeight = ((JFrame)aWindow).getRootPane().getHeight();
        }
        if (aWindow instanceof JDialog) {
            rootPaneHeight = ((JDialog)aWindow).getRootPane().getHeight();
        }
        return aWindow.getHeight() - rootPaneHeight;
    }

    public static Color getContainerBackground(Container comp) {
        for (Container parent = comp; parent != null; parent = parent.getParent()) {
            if (!parent.isOpaque()) continue;
            return parent.getBackground();
        }
        return comp.getBackground();
    }

    public static GridBagConstraints getGridBagConstraintsForSimpleFields() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.bottom = 5;
        c.insets.left = 5;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        return c;
    }
}

