/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SrSplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private JButton myExpandToRightButton;
    private JButton myExpandToLeftButton;

    public SrSplitPane() {
        this.init();
    }

    public SrSplitPane(int newOrientation) {
        super(newOrientation);
        this.init();
    }

    public SrSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.init();
    }

    public SrSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.init();
    }

    public SrSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
    }

    @Override
    public void setOneTouchExpandable(boolean newValue) {
        super.setOneTouchExpandable(newValue);
        if (newValue) {
            BasicSplitPaneDivider devider = ((BasicSplitPaneUI)this.getUI()).getDivider();
            ArrayList<JButton> arrowButtons = new ArrayList<JButton>();
            for (Component comp : devider.getComponents()) {
                if (!(comp instanceof JButton)) continue;
                arrowButtons.add((JButton)comp);
            }
            if (arrowButtons.size() == 2) {
                this.myExpandToLeftButton = (JButton)arrowButtons.get(0);
                this.myExpandToRightButton = (JButton)arrowButtons.get(1);
            }
        } else {
            this.myExpandToLeftButton = null;
            this.myExpandToRightButton = null;
        }
    }

    public JButton getExpandToRightButton() {
        return this.myExpandToRightButton;
    }

    public JButton getExpandToLeftButton() {
        return this.myExpandToLeftButton;
    }

    public void setOneTouchExpandListener(ActionListener aListener) {
        if (!this.isOneTouchExpandable()) {
            return;
        }
        for (ActionListener prevListener : this.myExpandToRightButton.getActionListeners()) {
            this.myExpandToRightButton.removeActionListener(prevListener);
        }
        this.myExpandToRightButton.addActionListener(aListener);
        for (ActionListener prevListener : this.myExpandToLeftButton.getActionListeners()) {
            this.myExpandToLeftButton.removeActionListener(prevListener);
        }
        this.myExpandToLeftButton.addActionListener(aListener);
    }

    public void setOneTouchExpandMaxLocation(final int aLocation) {
        if (!this.isOneTouchExpandable()) {
            return;
        }
        ActionListener maxLocationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean expandToRightAction = e.getSource().equals(SrSplitPane.this.getExpandToRightButton());
                JButton toRightButton = SrSplitPane.this.getExpandToRightButton();
                JButton toLeftButton = SrSplitPane.this.getExpandToLeftButton();
                if (toRightButton != null) {
                    toRightButton.setEnabled(!expandToRightAction);
                }
                if (toLeftButton != null) {
                    toLeftButton.setEnabled(expandToRightAction);
                }
                SrSplitPane.this.setDividerLocation(expandToRightAction ? aLocation : 0);
            }
        };
        if (this.getDividerLocation() == 0) {
            this.myExpandToLeftButton.setEnabled(false);
        } else {
            this.myExpandToRightButton.setEnabled(false);
        }
        this.setOneTouchExpandListener(maxLocationListener);
    }
}

