/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SrSliderPanel
extends SrPanel {
    private JSlider mySlider = null;
    private String myUnitDescStr = null;
    private SrLabelField myUnitDescLabel = new SrLabelField();
    private SrIntegerTextField myCurrentValueTextField = null;
    private boolean myIsTextFieldEnabled = true;
    private boolean myIsLocked = false;
    private KeyListener myValueTextFieldToSliderListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String valStr = SrSliderPanel.this.myCurrentValueTextField.getText().trim();
            if (!valStr.isEmpty()) {
                SrSliderPanel.this.setValue(Integer.parseInt(valStr));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };

    public SrSliderPanel(int aMinBoundry, int aMaxBoundry, int aValue, String aSliderUnitDescr, boolean aTextFieldEnabled) {
        super(new GridBagLayout());
        this.myCurrentValueTextField = new SrIntegerTextField(new Integer(aMaxBoundry).toString().length(), aMaxBoundry);
        this.mySlider = new JSlider(aMinBoundry, aMaxBoundry, aValue);
        this.mySlider.setOpaque(false);
        this.mySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                Integer val = new Integer(source.getValue());
                SrSliderPanel.this.myCurrentValueTextField.setText(val.toString());
                SrSliderPanel.this.updateCrossMaxValueWarning(val);
            }
        });
        this.setUnitDescriptor(aSliderUnitDescr);
        this.myIsTextFieldEnabled = aTextFieldEnabled;
        this.myCurrentValueTextField.setEnabled(aTextFieldEnabled);
        this.myCurrentValueTextField.addKeyListener(this.myValueTextFieldToSliderListener);
        this.initPanel();
    }

    public SrSliderPanel(int aMinBoundry, int aMaxBoundry, String aSliderUnitDescr, boolean aTextEnabled) {
        this(aMinBoundry, aMaxBoundry, aMinBoundry, aSliderUnitDescr, aTextEnabled);
    }

    public void setUnitDescriptor(String aDesc) {
        this.myUnitDescStr = aDesc;
    }

    private void initPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 10;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.mySlider, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets.right = 0;
        this.myCurrentValueTextField.setText(String.valueOf(this.mySlider.getValue()));
        this.myUnitDescLabel.setText(this.myUnitDescStr);
        SrPanel p = new SrPanel(new BorderLayout());
        p.add((Component)this.myCurrentValueTextField, "West");
        p.add((Component)this.myUnitDescLabel, "East");
        this.add((Component)p, c);
    }

    public int getMaxValue() {
        return this.mySlider.getMaximum();
    }

    public void setMaxValue(int aMaxValue) {
        this.mySlider.setMaximum(aMaxValue);
    }

    public int getMinValue() {
        return this.mySlider.getMinimum();
    }

    public void setMajorTickSpacing(int aMajorTickSpacing) {
        this.mySlider.setMajorTickSpacing(aMajorTickSpacing);
    }

    public void setMinorTickSpacing(int aMinorTickSpacing) {
        this.mySlider.setMinorTickSpacing(aMinorTickSpacing);
    }

    public void showTicks(boolean aToShow) {
        this.mySlider.setPaintTicks(aToShow);
    }

    public void showLabels(boolean aToShow) {
        this.mySlider.setPaintLabels(aToShow);
    }

    public void setValue(int aVal) {
        if (this.myIsLocked) {
            return;
        }
        this.mySlider.setValue(aVal);
        this.updateCrossMaxValueWarning(aVal);
    }

    private void displayCrossMaxValueWarning(boolean aToWarn) {
        if (aToWarn) {
            this.myUnitDescLabel.setIcon(ClientImageObject.FATAL_ALARM.getImageIcon());
            this.myUnitDescLabel.setText("");
        } else {
            this.myUnitDescLabel.setIcon(null);
            this.myUnitDescLabel.setText(this.myUnitDescStr);
        }
    }

    private void updateCrossMaxValueWarning(int aVal) {
        if (aVal > this.mySlider.getModel().getMaximum()) {
            this.displayCrossMaxValueWarning(true);
        } else {
            this.displayCrossMaxValueWarning(false);
        }
    }

    @Override
    public void setVisible(boolean aIsVisible) {
        this.mySlider.setVisible(aIsVisible);
    }

    @Override
    public void setEnabled(boolean aIsEnabled) {
        this.mySlider.setEnabled(aIsEnabled);
        if (this.myIsTextFieldEnabled) {
            this.myCurrentValueTextField.setEnabled(aIsEnabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mySlider.isEnabled();
    }

    public int getValue() {
        return this.mySlider.getValue();
    }

    public void addChangeListener(ChangeListener aListener) {
        this.mySlider.addChangeListener(aListener);
    }

    public void removeChangeListener(ChangeListener aListener) {
        this.mySlider.removeChangeListener(aListener);
    }

    public void addMouseListener(MouseMotionListener aListener) {
        this.mySlider.addMouseMotionListener(aListener);
    }

    public void setLock(boolean aLock) {
        this.myIsLocked = aLock;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public boolean getValueIsAdjusting() {
        return this.mySlider.getValueIsAdjusting();
    }
}

