/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.RefineryUtilities;

public class SrScrollChartPanel
extends SrPanel
implements ActionListener,
ChangeListener,
ChartChangeListener,
MouseListener,
MouseMotionListener {
    private ChartPanel chartPanel;
    private int scrollFactor = 20;
    private JScrollBar scrollBar;
    private Point2D panStartPoint;
    private double[] primYMinMax = new double[2];
    private double[] secondYMinMax = new double[2];
    private static final String ACTION_CMD_PAN = "pan";
    private static final String ACTION_CMD_ZOOM_BOX = "zoomBox";
    private static final String ACTION_CMD_ZOOM_TO_FIT = "zoomFit";
    private static final String ACTION_CMD_ZOOM_IN = "zoomIn";
    private static final String ACTION_CMD_ZOOM_OUT = "zoomOut";
    private static final String ACTION_SCROLL_CMD = "Scroll";
    private static final String ACTION_ZOOM_CMD = "Zoom";
    private static final double ZOOM_FACTOR = 0.8;
    private JToolBar toolBar;
    private AbstractButton zoomButton;
    private AbstractButton panButton;

    public SrScrollChartPanel(JFreeChart chart) {
        super(new BorderLayout());
        SrPanel toolBarPanel = new SrPanel(new FlowLayout(2, 0, 0));
        toolBarPanel.add(new ChartToolBarPanel());
        this.add((Component)toolBarPanel, "North");
        this.chartPanel = new SrChartPanel(chart);
        chart.addChangeListener(this);
        this.actionPerformed(new ActionEvent(this, 0, ACTION_CMD_ZOOM_BOX));
        this.chartPanel.addMouseListener(this);
        this.chartPanel.addMouseMotionListener(this);
        this.add(this.chartPanel);
    }

    private void prepareButton(AbstractButton button, String actionKey, String buttonLabelText, String toolTipText) {
        button.setActionCommand(actionKey);
        button.setText(buttonLabelText);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
    }

    private void setPanMode(boolean val) {
        this.chartPanel.setHorizontalZoom(!val);
        this.chartPanel.setVerticalZoom(!val);
        if (val) {
            this.chartPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.chartPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            String acmd = evt.getActionCommand();
            if (acmd.equals(ACTION_CMD_ZOOM_BOX)) {
                this.setPanMode(false);
            } else if (acmd.equals(ACTION_CMD_PAN)) {
                this.setPanMode(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        try {
            Object src = event.getSource();
            BoundedRangeModel scrollBarModel = this.scrollBar.getModel();
            if (src == scrollBarModel) {
                int val = scrollBarModel.getValue();
                int ext = scrollBarModel.getExtent();
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof XYPlot) {
                    XYPlot hvp = (XYPlot)plot;
                    TimeSeriesCollection dataset = (TimeSeriesCollection)hvp.getDataset(0);
                    int first = val - ext;
                    if (first > 0) {
                        Date currectDate = dataset.getSeries(0).getDataItem(val).getPeriod().getStart();
                        Date firstDate = dataset.getSeries(0).getDataItem(first).getPeriod().getStart();
                        DateAxis axis = (DateAxis)hvp.getDomainAxis();
                        this.chartPanel.getChart().removeChangeListener(this);
                        axis.setRange(firstDate, currectDate);
                        this.chartPanel.getChart().addChangeListener(this);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void chartChanged(ChartChangeEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            Point point;
            Rectangle2D dataArea;
            if ((this.panButton.isSelected() || this.panButton.isEnabled() && SwingUtilities.isRightMouseButton(event)) && (dataArea = this.chartPanel.getScaledDataArea()).contains(point = event.getPoint())) {
                this.setPanMode(true);
                this.panStartPoint = point;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            this.panStartPoint = null;
            if (!this.panButton.isSelected()) {
                this.setPanMode(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        try {
            if (this.panStartPoint != null) {
                XYPlot xyPlot;
                double dY;
                XYPlot vvp;
                ValueAxis yAxis;
                double newMax;
                double oldMax;
                double newMin;
                double oldMin;
                double translatedEndPoint;
                double translatedStartPoint;
                XYPlot hvp;
                ValueAxis xAxis;
                Rectangle2D scaledDataArea = this.chartPanel.getScaledDataArea();
                this.panStartPoint = RefineryUtilities.getPointInRectangle(this.panStartPoint.getX(), this.panStartPoint.getY(), scaledDataArea);
                Point2D panEndPoint = RefineryUtilities.getPointInRectangle(event.getX(), event.getY(), scaledDataArea);
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof XYPlot && (xAxis = (hvp = (XYPlot)plot).getDomainAxis()) != null) {
                    translatedStartPoint = xAxis.java2DToValue((float)this.panStartPoint.getX(), scaledDataArea, hvp.getDomainAxisEdge());
                    translatedEndPoint = xAxis.java2DToValue((float)panEndPoint.getX(), scaledDataArea, hvp.getDomainAxisEdge());
                    double dX = translatedStartPoint - translatedEndPoint;
                    oldMin = xAxis.getLowerBound();
                    newMin = oldMin + dX;
                    oldMax = xAxis.getUpperBound();
                    newMax = oldMax + dX;
                    Range dataRange = hvp.getDataRange(xAxis);
                    if (dataRange != null && newMin >= dataRange.getLowerBound() && newMax <= dataRange.getUpperBound()) {
                        xAxis.setLowerBound(newMin);
                        xAxis.setUpperBound(newMax);
                    }
                }
                if (plot instanceof XYPlot && (yAxis = (vvp = (XYPlot)plot).getRangeAxis()) != null) {
                    translatedStartPoint = yAxis.java2DToValue((float)this.panStartPoint.getY(), scaledDataArea, vvp.getRangeAxisEdge());
                    translatedEndPoint = yAxis.java2DToValue((float)panEndPoint.getY(), scaledDataArea, vvp.getRangeAxisEdge());
                    dY = translatedStartPoint - translatedEndPoint;
                    oldMin = yAxis.getLowerBound();
                    newMin = oldMin + dY;
                    oldMax = yAxis.getUpperBound();
                    newMax = oldMax + dY;
                    yAxis.setLowerBound(newMin);
                    yAxis.setUpperBound(newMax);
                }
                if (plot instanceof XYPlot && (yAxis = (xyPlot = (XYPlot)plot).getRangeAxis(1)) != null) {
                    translatedStartPoint = yAxis.java2DToValue((float)this.panStartPoint.getY(), scaledDataArea, xyPlot.getRangeAxisEdge(1));
                    translatedEndPoint = yAxis.java2DToValue((float)panEndPoint.getY(), scaledDataArea, xyPlot.getRangeAxisEdge(1));
                    dY = translatedStartPoint - translatedEndPoint;
                    oldMin = yAxis.getLowerBound();
                    newMin = oldMin + dY;
                    oldMax = yAxis.getUpperBound();
                    newMax = oldMax + dY;
                    yAxis.setLowerBound(newMin);
                    yAxis.setUpperBound(newMax);
                }
                this.panStartPoint = panEndPoint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private int getExtent(int max, int min) {
        int ext = this.scrollFactor;
        int length = max - min;
        if (this.scrollFactor > length) {
            ext = length;
        }
        return ext;
    }

    private int getSeriesMax(List series) {
        int max = -1;
        for (TimeSeries timeSeries : series) {
            int count = timeSeries.getItemCount() - 1;
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    private void recalcScrollBar(Plot plot) {
        if (plot instanceof XYPlot) {
            XYPlot hvp = (XYPlot)plot;
            TimeSeriesCollection dataset = (TimeSeriesCollection)hvp.getDataset(0);
            int maxSeries = this.getSeriesMax(dataset.getSeries());
            BoundedRangeModel scrollBarModel = this.scrollBar.getModel();
            scrollBarModel.setMinimum(0);
            scrollBarModel.setValue(maxSeries);
            scrollBarModel.setMaximum(maxSeries);
            scrollBarModel.setExtent(this.getExtent(maxSeries, 0));
            scrollBarModel.addChangeListener(this);
        }
    }

    private void zoomBoth(double x, double y, double zoomFactor) {
        this.zoomHorizontal(x, zoomFactor);
        this.zoomVertical(y, zoomFactor);
    }

    private void zoomHorizontal(double x, double zoomFactor) {
        XYPlot hvp;
        ValueAxis axis;
        JFreeChart chart = this.chartPanel.getChart();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (chart.getPlot() instanceof XYPlot && (axis = (hvp = (XYPlot)chart.getPlot()).getDomainAxis()) != null) {
            double anchorValue = axis.java2DToValue((float)x, info.getPlotInfo().getDataArea(), hvp.getDomainAxisEdge());
            if (zoomFactor < 1.0) {
                axis.resizeRange(zoomFactor, anchorValue);
            } else if (zoomFactor > 1.0) {
                Range range = hvp.getDataRange(axis);
                this.adjustRange(axis, range, zoomFactor, anchorValue);
            }
        }
    }

    private void zoomVertical(double y, double zoomFactor) {
        JFreeChart chart = this.chartPanel.getChart();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (chart.getPlot() instanceof XYPlot) {
            XYPlot xyp;
            ValueAxis secYAxis;
            XYPlot vvp = (XYPlot)chart.getPlot();
            ValueAxis primYAxis = vvp.getRangeAxis();
            if (primYAxis != null) {
                double anchorValue = primYAxis.java2DToValue((float)y, info.getPlotInfo().getDataArea(), vvp.getRangeAxisEdge());
                if (zoomFactor < 1.0) {
                    primYAxis.resizeRange(zoomFactor, anchorValue);
                } else if (zoomFactor > 1.0) {
                    Range range = new Range(this.primYMinMax[0], this.primYMinMax[1]);
                    this.adjustRange(primYAxis, range, zoomFactor, anchorValue);
                }
            }
            if (chart.getPlot() instanceof XYPlot && (secYAxis = (xyp = (XYPlot)chart.getPlot()).getRangeAxis(1)) != null) {
                double anchorValue = secYAxis.java2DToValue((float)y, info.getPlotInfo().getDataArea(), xyp.getRangeAxisEdge(1));
                if (zoomFactor < 1.0) {
                    secYAxis.resizeRange(zoomFactor, anchorValue);
                } else if (zoomFactor > 1.0) {
                    Range range = new Range(this.secondYMinMax[0], this.secondYMinMax[1]);
                    this.adjustRange(secYAxis, range, zoomFactor, anchorValue);
                }
            }
        }
    }

    private void adjustRange(ValueAxis axis, Range range, double zoomFactor, double anchorValue) {
        if (axis == null || range == null) {
            return;
        }
        double rangeMinVal = range.getLowerBound() - range.getLength() * axis.getLowerMargin();
        double rangeMaxVal = range.getUpperBound() + range.getLength() * axis.getUpperMargin();
        double halfLength = axis.getRange().getLength() * zoomFactor / 2.0;
        double zoomedMinVal = anchorValue - halfLength;
        double zoomedMaxVal = anchorValue + halfLength;
        double adjMinVal = zoomedMinVal;
        if (zoomedMinVal < rangeMinVal) {
            adjMinVal = rangeMinVal;
            zoomedMaxVal += rangeMinVal - zoomedMinVal;
        }
        double adjMaxVal = zoomedMaxVal;
        if (zoomedMaxVal > rangeMaxVal) {
            adjMaxVal = rangeMaxVal;
            adjMinVal = Math.max(zoomedMinVal -= zoomedMaxVal - rangeMaxVal, rangeMinVal);
        }
        Range adjusted = new Range(adjMinVal, adjMaxVal);
        axis.setRange(adjusted);
    }

    class SrChartPanel
    extends ChartPanel {
        public SrChartPanel(JFreeChart chart) {
            super(chart, false, false, false, true, false);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!SrScrollChartPanel.this.panButton.isSelected()) {
                super.mouseDragged(event);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SrScrollChartPanel.this.panButton.isSelected()) {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SrScrollChartPanel.this.panButton.isSelected()) {
                super.mouseReleased(e);
            }
        }
    }

    class ChartToolBarPanel
    extends SrPanel {
        private SrPanel m_innerPanel = new SrPanel(new FlowLayout(0, 10, 10));

        public ChartToolBarPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets.right = 7;
            this.add((Component)this.m_innerPanel, constraints);
            this.init();
        }

        private void init() {
            this.addSeperator();
            ButtonGroup groupedButtons = new ButtonGroup();
            SrScrollChartPanel.this.panButton = new JToggleButton(SrScrollChartPanel.ACTION_SCROLL_CMD);
            SrScrollChartPanel.this.panButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SrScrollChartPanel.this.setPanMode(true);
                }
            });
            groupedButtons.add(SrScrollChartPanel.this.panButton);
            this.addButton(SrScrollChartPanel.this.panButton, null);
            SrScrollChartPanel.this.panButton.setIcon(ImageObject.CHART_SCROLL_HAND.getImageIcon());
            JToggleButton zoomBtt = new JToggleButton(SrScrollChartPanel.ACTION_ZOOM_CMD);
            zoomBtt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SrScrollChartPanel.this.setPanMode(false);
                }
            });
            groupedButtons.add(zoomBtt);
            this.addButton(zoomBtt, null);
            zoomBtt.setIcon(ImageObject.CHART_ZOOM.getImageIcon());
            zoomBtt.setSelected(true);
        }

        protected void addButton(AbstractButton button, ImageIcon icon) {
            this.addButtonComponent(button);
            button.setVerticalTextPosition(3);
            button.setFocusPainted(false);
            button.setRequestFocusEnabled(false);
            button.setBorderPainted(true);
            button.setHorizontalTextPosition(0);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setIcon(icon);
            button.setIconTextGap(0);
        }

        private void addButtonComponent(JComponent button) {
            button.setFont(LookAndFill.GENERAL_FONT);
            button.setForeground(new Color(113, 131, 155));
            button.setBackground(Color.WHITE);
            this.m_innerPanel.add(button);
            this.addSeperator();
        }

        private void addSeperator() {
            JLabel seperator = new JLabel();
            seperator.setIcon(ImageObject.CHART_TOOL_BAR_SEPARATOR.getImageIcon());
            this.m_innerPanel.add(seperator);
        }
    }
}

