/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.SrTabbedPane;
import java.util.List;
import java.util.Vector;

public class SrPropertyTabbedPanel
extends SrTabbedPane {
    public SrPropertyTabbedPanel() {
    }

    public SrPropertyTabbedPanel(SrPropertyPanel[] panels) {
        for (int i = 0; i < panels.length; ++i) {
            SrPropertyPanel pan = panels[i];
            this.addTab(pan.getPanelName(), pan);
            pan.setPanelBorder(null);
            pan.onUpdateEvent(null);
        }
    }

    public void removePropertyTab(String name) {
        if (this.isTabExists(name)) {
            int index = this.indexOfTab(name);
            this.removeTabAt(index);
        }
    }

    public void setPropertyTab(SrPropertyPanel pan) {
        if (this.isTabExists(pan.getPanelName())) {
            int index = this.indexOfTab(pan.getPanelName());
            this.setComponentAt(index, pan);
            pan.onUpdateEvent(null);
        } else {
            this.addTab(pan.getPanelName(), pan);
            pan.onUpdateEvent(null);
        }
    }

    public void forceValidate(String tabName) {
        if (this.isTabExists(tabName)) {
            SrPropertyPanel pan = this.getTabPanel(tabName);
            pan.validate();
        }
    }

    public SrPropertyPanel getTabPanel(String tabName) {
        int index = this.indexOfTab(tabName);
        SrPropertyPanel pan = null;
        if (index != -1) {
            pan = (SrPropertyPanel)this.getComponentAt(index);
        }
        return pan;
    }

    public boolean isTabInFocus(String tabName) {
        boolean answer = false;
        int index = this.indexOfTab(tabName);
        if (index == this.getSelectedIndex()) {
            answer = true;
        }
        return answer;
    }

    public String getSelectedTab() {
        int index = this.getSelectedIndex();
        return this.getTitleAt(index);
    }

    public boolean isTabExists(String tabName) {
        boolean answer = true;
        int index = this.indexOfTab(tabName);
        if (index == -1) {
            answer = false;
        }
        return answer;
    }

    public String[] getTabOrder() {
        int size = this.getTabCount();
        String[] arr = new String[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.getTitleAt(i);
        }
        return arr;
    }

    public SrPropertyPanel[] getTabsPanel() {
        String[] arr = this.getTabOrder();
        SrPropertyPanel[] pans = new SrPropertyPanel[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            pans[i] = this.getTabPanel(arr[i]);
        }
        return pans;
    }

    public boolean isTabValid(String tabName) {
        SrPropertyPanel pan;
        Vector<String> list;
        boolean valid = false;
        if (this.isTabExists(tabName) && (list = (pan = this.getTabPanel(tabName)).getNonValidMandatoryFields()).isEmpty()) {
            valid = true;
        }
        return valid;
    }

    public Vector getTabNonValidFields(String tabName) {
        Vector<String> list = null;
        if (this.isTabExists(tabName)) {
            SrPropertyPanel pan = this.getTabPanel(tabName);
            list = pan.getNonValidMandatoryFields();
        }
        return list;
    }

    public List getTabMandatoryFields(String tabName) {
        List list = null;
        if (this.isTabExists(tabName)) {
            SrPropertyPanel pan = this.getTabPanel(tabName);
            list = pan.getPanelMandatoryFields();
        }
        return list;
    }

    public void setTabSelection(String tabName) {
        int index = this.indexOfTab(tabName);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
    }

    public void enableDialogEdit(boolean enable) {
        SrPropertyPanel[] pans = this.getTabsPanel();
        for (int i = 0; i < pans.length; ++i) {
            pans[i].setEnabledAllProperties(enable);
        }
    }
}

