/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.util.SrEventListenerManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SrPropertyPanel
extends SrPanel {
    private String m_panName;
    private SrPanel m_pnl;
    private JScrollPane m_scroll;
    private boolean m_rightToLeft;
    private boolean m_verticalScrool;
    private boolean m_stickUpItems;
    private HashMap m_nameToComponent;
    private HashMap m_componentLastValue;
    private HashMap m_keyStringToValue;
    private HashMap m_keyStringToPanel;
    private Vector m_mandatoryProperties;
    private HashMap m_saveLastValue;
    private HashMap m_statusLabels;
    private Vector m_propertyOrder;
    private int m_propertyRow;
    protected SrListener m_listener = new SrListener();
    protected Insets m_leftInsets;
    private Insets m_mandatoryInsets;
    protected Insets m_rightInsets;
    private GridBagConstraints m_myLayoutConstrains;
    private ArrayList<PropertyPanelValidationListener> m_listeners = new ArrayList();
    private static final String STATUS_LBL = "* ";
    private static final String SPACE = " ";
    public static final String KEY_SEPERATOR = "__";
    private static final int MID_INNER_INSETS = 5;
    private static final int FULL_INNER_INSETS = 10;
    SrEventListenerManager.Informer<PropertyPanelValidationListener, PropertyPanelValidationEvent> onPanelPropertyChangedInformer = new SrEventListenerManager.Informer<PropertyPanelValidationListener, PropertyPanelValidationEvent>(){

        @Override
        public void inform(PropertyPanelValidationListener listener, PropertyPanelValidationEvent event) {
            listener.onPanelPropertyChanged(event);
        }
    };

    public SrPropertyPanel(String panelName) {
        this.m_panName = panelName;
        this.initPanel(false, false, false);
    }

    public SrPropertyPanel(String panelName, boolean verticalScrool, boolean stickUpItems, boolean isRightToLeft) {
        this.m_panName = panelName;
        this.initPanel(verticalScrool, stickUpItems, isRightToLeft);
    }

    private void initPanel(boolean verticalScrool, boolean stickUpItems, boolean isRightToLeft) {
        this.m_verticalScrool = verticalScrool;
        this.m_stickUpItems = stickUpItems;
        this.m_rightToLeft = isRightToLeft;
        if (this.m_verticalScrool) {
            this.setLayout(new BorderLayout(2, 2));
            this.m_pnl = new SrPanel();
            this.m_scroll = new JScrollPane(this.m_pnl);
            this.add((Component)this.m_scroll, "Center");
        } else {
            this.m_pnl = this;
        }
        this.m_pnl.setLayout(new GridBagLayout());
        if (this.m_stickUpItems) {
            this.stickUpItemsSetup();
        }
        this.m_nameToComponent = new HashMap();
        this.m_componentLastValue = new HashMap();
        this.m_keyStringToValue = new HashMap();
        this.m_keyStringToPanel = new HashMap();
        this.m_propertyRow = 0;
        this.m_statusLabels = new HashMap();
        this.m_propertyOrder = new Vector();
        this.m_mandatoryProperties = new Vector();
        this.m_saveLastValue = new HashMap();
        this.m_mandatoryInsets = new Insets(5, 10, 0, 0);
        this.m_leftInsets = new Insets(5, 0, 0, 5);
        this.m_rightInsets = new Insets(5, 0, 5, 10);
    }

    public void setPanelBorder(Border border) {
        if (this.m_scroll != null) {
            this.m_scroll.setBorder(border);
        }
    }

    private void stickUpItemsSetup() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 99;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.weighty = 1.0;
        constraints.fill = 3;
        JLabel dummy = new JLabel();
        this.m_pnl.add((Component)dummy, constraints);
    }

    public void addProperty(String propName, SrComponent com) {
        SrWidget labelWidget = this.createLabelWidget(propName);
        SrWidget valueWidget = new SrWidget(propName, com, true, false, false, true, null);
        this.addProperty(labelWidget, valueWidget);
    }

    public void addProperty(String propName, SrWidget valueWidget) {
        SrWidget labelWidget = this.createLabelWidget(propName);
        valueWidget.setName(propName);
        this.addProperty(labelWidget, valueWidget);
    }

    public void addProperty(SrWidget widget) {
        SrWidget dummy = new SrWidget();
        this.addProperty(dummy, widget);
    }

    public void addProperty(SrComponent keyComponent, SrComponent valueComponent) {
        SrWidget keyWidget = new SrWidget(keyComponent.getValue().toString(), keyComponent, false, false, true, true, null);
        SrWidget valueWidget = new SrWidget(keyComponent.getValue().toString(), valueComponent, false, false, true, true, null);
        this.addProperty(keyWidget, valueWidget);
    }

    public void addLabel(String lblStr) {
        SrLabelField lbl = new SrLabelField(lblStr);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = this.m_propertyRow++;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.weightx = 0.1;
        constraints.insets = this.m_mandatoryInsets;
        constraints.gridwidth = 3;
        this.m_pnl.add((Component)lbl, constraints);
    }

    public void skipLines(int lines) {
        for (int i = 0; i < lines; ++i) {
            this.addLabel(SPACE);
            ++this.m_propertyRow;
        }
    }

    public void addProperty(SrWidget keyWidget, SrWidget valueWidget) {
        int columnIndex = 0;
        int sign = 1;
        if (this.m_rightToLeft) {
            columnIndex = 2;
            sign = -1;
        }
        SrLabelField statusLbl = new SrLabelField(STATUS_LBL);
        statusLbl.setForeground(this.getBackground());
        GridBagConstraints mandatoryRowConstraints = new GridBagConstraints();
        mandatoryRowConstraints.gridx = columnIndex;
        mandatoryRowConstraints.gridy = this.m_propertyRow;
        mandatoryRowConstraints.anchor = 17;
        mandatoryRowConstraints.fill = 1;
        mandatoryRowConstraints.insets = new Insets(5, 5, 0, 0);
        this.m_pnl.add((Component)statusLbl, mandatoryRowConstraints);
        columnIndex += sign;
        if (keyWidget.getComponent() != null) {
            this.insertToPanel(keyWidget, columnIndex, this.m_leftInsets, 0.1);
            this.m_propertyOrder.add(keyWidget.getName());
        }
        if (valueWidget.getComponent() != null) {
            this.insertToPanel(valueWidget, columnIndex += sign, this.m_rightInsets, 0.7);
            if (keyWidget.getComponent() != null && keyWidget.getComponent() instanceof SrLabelField) {
                String keyName = keyWidget.getName();
                this.m_nameToComponent.put(keyName, keyWidget.getComponent());
                this.m_keyStringToValue.put(keyName, valueWidget.getComponent());
                if (valueWidget.isMandatory()) {
                    this.m_mandatoryProperties.add(keyName);
                }
                this.m_statusLabels.put(keyName, statusLbl);
                if (valueWidget.isKeepingHistory()) {
                    this.m_saveLastValue.put(keyName, valueWidget.getComponent().getValue());
                    valueWidget.getComponent().addComponentFocusListener(new SrItemFocusListener(keyName, valueWidget.getComponent()));
                }
            } else if (keyWidget.getComponent() != null && valueWidget.getComponent() != null) {
                this.m_nameToComponent.put(keyWidget.getName(), keyWidget.getComponent());
                this.m_nameToComponent.put(valueWidget.getName(), valueWidget.getComponent());
            } else if (keyWidget.getComponent() == null) {
                this.m_nameToComponent.put(valueWidget.getName(), valueWidget.getComponent());
                this.m_propertyOrder.add(valueWidget.getName());
                if (valueWidget.isMandatory()) {
                    this.m_mandatoryProperties.add(valueWidget.getName());
                }
                this.m_statusLabels.put(valueWidget.getName(), statusLbl);
                if (valueWidget.isKeepingHistory()) {
                    this.m_saveLastValue.put(valueWidget.getName(), valueWidget.getComponent().getValue());
                    valueWidget.getComponent().addComponentFocusListener(new SrItemFocusListener(valueWidget.getName(), valueWidget.getComponent()));
                }
            }
            ++this.m_propertyRow;
        }
    }

    public void addPropertyPanel(SrPropertyPanel panel, boolean registerListeners) {
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridy = this.m_propertyRow;
        itemConstraints.gridwidth = 0;
        itemConstraints.insets = new Insets(10, 10, 0, 10);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 1;
        this.addPropertyPanel(panel, registerListeners, itemConstraints);
    }

    public void addPropertyPanel(SrPropertyPanel panel, boolean registerListeners, GridBagConstraints itemConstraints) {
        if (itemConstraints != null) {
            itemConstraints.insets = new Insets(10, 10, 0, 10);
            itemConstraints.weightx = 1.0;
            itemConstraints.anchor = 17;
            itemConstraints.fill = 1;
            this.m_pnl.add((Component)panel, itemConstraints);
            panel.setMyLayoutConstrains(itemConstraints);
            HashMap values = panel.getPanelStringComponentMap();
            this.m_keyStringToValue.putAll(values);
            HashMap statusLables = panel.getPanelStatusLabels();
            this.m_statusLabels.putAll(statusLables);
            String panelName = panel.getName();
            this.m_propertyOrder.add(panelName);
            this.m_keyStringToPanel.put(panelName, panel);
            List mandatory = panel.getPanelMandatoryFields();
            this.m_mandatoryProperties.addAll(mandatory);
            HashMap savedFields = panel.getPanelSavedFields();
            this.m_saveLastValue.putAll(savedFields);
            if (savedFields != null && values != null) {
                for (String key : savedFields.keySet()) {
                    if (!values.containsKey(key)) continue;
                    SrComponent com = (SrComponent)values.get(key);
                    this.clearFocusListeners(com.getComponent());
                    com.addComponentFocusListener(new SrItemFocusListener(key, com));
                }
            }
            if (registerListeners) {
                for (SrComponent com : values.values()) {
                    com.removeComponentValidListener(panel.getSrListener());
                    com.addComponentValidListener(this.m_listener);
                }
            }
            ++this.m_propertyRow;
        }
    }

    private void clearFocusListeners(Component com) {
        FocusListener[] listeners = com.getFocusListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof SrItemFocusListener)) continue;
            com.removeFocusListener(listeners[i]);
        }
    }

    public void addPropertyListener(SrComponent srCom, SrListener listener) {
        if (srCom != null) {
            srCom.addComponentValidListener(listener);
        }
    }

    public boolean isPropertyEnabled(String key) {
        boolean answer = false;
        SrComponent srCom = this.getProperty(key);
        if (srCom != null) {
            answer = srCom.isComponentEnabled();
        }
        return answer;
    }

    public void setEnabledAllProperties(boolean b) {
        SrComponent srCom;
        Iterator keys = this.m_keyStringToValue.keySet().iterator();
        while (keys.hasNext()) {
            srCom = (SrComponent)this.m_keyStringToValue.get(keys.next());
            srCom.setEnableComponent(b);
        }
        keys = this.m_nameToComponent.keySet().iterator();
        while (keys.hasNext()) {
            srCom = (SrComponent)this.m_nameToComponent.get(keys.next());
            srCom.setEnableComponent(b);
        }
    }

    public SrComponent getProperty(String key) {
        SrComponent com = null;
        String newKey = this.m_panName + KEY_SEPERATOR + key;
        if (this.m_keyStringToValue.containsKey(newKey)) {
            com = (SrComponent)this.m_keyStringToValue.get(newKey);
        } else if (this.m_nameToComponent.containsKey(newKey)) {
            com = (SrComponent)this.m_nameToComponent.get(newKey);
        }
        if (com == null) {
            if (this.m_keyStringToValue.containsKey(key)) {
                com = (SrComponent)this.m_keyStringToValue.get(key);
            } else if (this.m_nameToComponent.containsKey(key)) {
                com = (SrComponent)this.m_nameToComponent.get(key);
            }
        }
        return com;
    }

    public void removeProperty(String key) {
        SrComponent keyCom = null;
        SrComponent valCom = null;
        if (this.m_keyStringToValue.containsKey(key)) {
            valCom = (SrComponent)this.m_keyStringToValue.get(key);
        }
        if (this.m_nameToComponent.containsKey(key)) {
            keyCom = (SrComponent)this.m_nameToComponent.get(key);
        }
        if (keyCom != null && valCom != null) {
            this.m_pnl.remove((SrLabelField)this.m_statusLabels.get(key));
            this.m_pnl.remove(keyCom.getComponent());
            this.m_pnl.remove(valCom.getComponent());
            this.m_keyStringToValue.remove(key);
            this.m_nameToComponent.remove(key);
            this.m_propertyOrder.remove(key);
            this.m_mandatoryProperties.remove(key);
            this.m_saveLastValue.remove(key);
            this.m_statusLabels.remove(key);
            --this.m_propertyRow;
            this.repaint();
        }
    }

    public void removePropertyPanel(String panelName) {
        if (this.m_keyStringToPanel.containsKey(panelName)) {
            SrPropertyPanel pan = (SrPropertyPanel)this.m_keyStringToPanel.get(panelName);
            this.m_pnl.remove(pan);
            this.m_keyStringToPanel.remove(pan);
            this.m_propertyOrder.remove(panelName);
            HashMap panValues = pan.getPanelStringComponentMap();
            Iterator keys = panValues.keySet().iterator();
            while (keys.hasNext()) {
                this.m_keyStringToValue.remove(keys.next());
            }
            HashMap statusLabels = pan.getPanelStatusLabels();
            keys = statusLabels.keySet().iterator();
            while (keys.hasNext()) {
                this.m_statusLabels.remove(keys.next());
            }
            List mandatoryFields = pan.getPanelMandatoryFields();
            Iterator iter = mandatoryFields.iterator();
            while (iter.hasNext()) {
                this.m_mandatoryProperties.remove(iter.next());
            }
            HashMap savedFields = pan.getPanelSavedFields();
            keys = savedFields.keySet().iterator();
            while (keys.hasNext()) {
                savedFields.remove(keys.next());
            }
            --this.m_propertyRow;
            this.repaint();
        }
    }

    public void removeProperty(SrWidget w) {
        String wName = w.getName();
        this.m_pnl.remove(w.getComponent().getComponent());
        this.m_nameToComponent.remove(wName);
        this.m_propertyOrder.remove(wName);
        this.m_mandatoryProperties.remove(wName);
        this.m_saveLastValue.remove(wName);
        this.m_statusLabels.remove(wName);
        --this.m_propertyRow;
        this.repaint();
    }

    public Object getPropertyVal(String key) {
        Object retObj = null;
        SrComponent com = this.getProperty(key);
        if (com != null) {
            retObj = com.getValue();
        }
        return retObj;
    }

    public HashMap getPanelValues() {
        return this.getPanelData(true);
    }

    private HashMap getPanelData(boolean returnValues) {
        Object propVal;
        HashMap results = new HashMap();
        for (Object key : this.m_keyStringToValue.keySet()) {
            Object val = this.m_keyStringToValue.get(key);
            if (!(val instanceof SrComponent)) continue;
            propVal = val;
            if (returnValues) {
                propVal = ((SrComponent)val).getValue();
            }
            results.put(this.preperKey(key), propVal);
        }
        for (Object key : this.m_nameToComponent.keySet()) {
            if (this.m_keyStringToValue.containsKey(key)) continue;
            SrComponent com = (SrComponent)this.m_nameToComponent.get(key);
            propVal = com;
            if (returnValues) {
                propVal = com.getValue();
            }
            results.put(this.preperKey(key), propVal);
        }
        return results;
    }

    private String preperKey(Object key) {
        String newKey = (String)key;
        String prefix = this.m_panName + KEY_SEPERATOR;
        if (newKey.startsWith(prefix)) {
            newKey = newKey.replaceFirst(prefix, "");
        }
        return newKey;
    }

    public HashMap getPanelProperties() {
        return this.getPanelData(false);
    }

    public HashMap getPanelStringComponentMap() {
        return this.getPanelMap(this.m_keyStringToValue);
    }

    public List getPanelMandatoryFields() {
        return (List)this.m_mandatoryProperties.clone();
    }

    public HashMap getPanelSavedFields() {
        return this.getPanelMap(this.m_saveLastValue);
    }

    private HashMap getPanelMap(HashMap currentMap) {
        return (HashMap)currentMap.clone();
    }

    public HashMap getPanelStatusLabels() {
        return this.getPanelMap(this.m_statusLabels);
    }

    public Vector getPropertiesOrder() {
        return this.m_propertyOrder;
    }

    public void setPropertyValue(String key, Object val) {
        this.setPropertyValue(key, val, false);
    }

    public void setPropertyValue(String key, Object val, boolean fire) {
        SrComponent com = this.getProperty(key);
        if (com != null) {
            com.setValue(val);
            if (fire) {
                this.onUpdateEvent(null);
            }
        } else {
            System.err.println("cannot find the property [" + key + "] in panel [" + this.m_panName + "]");
        }
    }

    public void rebuild() {
        this.m_pnl.removeAll();
        if (this.m_stickUpItems) {
            this.stickUpItemsSetup();
        }
        this.m_propertyRow = 0;
        List r = (List)this.m_propertyOrder.clone();
        this.m_propertyOrder.clear();
        for (int i = 0; i < r.size(); ++i) {
            String key = (String)r.get(i);
            SrComponent com = null;
            if (this.m_keyStringToValue.containsKey(key)) {
                com = (SrComponent)this.m_keyStringToValue.get(key);
                this.addProperty(key, com);
                continue;
            }
            if (this.m_nameToComponent.containsKey(key)) {
                com = (SrComponent)this.m_nameToComponent.get(key);
                this.addProperty(new SrWidget(key, com));
                continue;
            }
            if (!this.m_keyStringToPanel.containsKey(key)) continue;
            SrPropertyPanel pan = (SrPropertyPanel)this.m_keyStringToPanel.get(key);
            this.addPropertyPanel(pan, false, pan.getMyLayoutConstrains());
        }
        this.revalidate();
        this.repaint();
    }

    public void startCurserAt(String key) {
        SrComponent com = this.getProperty(key);
        if (com != null && com.getComponent().isEnabled()) {
            com.getComponent().requestFocus();
        }
    }

    public String getPanelName() {
        return this.m_panName;
    }

    public GridBagConstraints getMyLayoutConstrains() {
        return this.m_myLayoutConstrains;
    }

    public void setMyLayoutConstrains(GridBagConstraints m_myLayoutConstrains) {
        this.m_myLayoutConstrains = m_myLayoutConstrains;
    }

    public void addValidationListener(PropertyPanelValidationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeValidationListener(PropertyPanelValidationListener listener) {
        this.m_listeners.remove(listener);
    }

    public Vector<String> getNonValidMandatoryFields() {
        Vector<String> listOfNonValid = new Vector<String>();
        for (int i = 0; i < this.m_mandatoryProperties.size(); ++i) {
            String field = (String)this.m_mandatoryProperties.get(i);
            SrComponent comp = this.getProperty(field);
            if (comp.isComponentValid()) continue;
            listOfNonValid.add(field);
        }
        return listOfNonValid;
    }

    protected Vector setMandatorySign() {
        Vector<String> nonValidFields = this.getNonValidMandatoryFields();
        if (nonValidFields != null) {
            for (Object key : this.m_statusLabels.keySet()) {
                SrLabelField lbl = (SrLabelField)this.m_statusLabels.get(key);
                if (nonValidFields.contains(key)) {
                    lbl.setForeground(Color.red);
                    continue;
                }
                lbl.setForeground(this.getBackground());
            }
        }
        return nonValidFields;
    }

    public void clearMandatoryFieldSet() {
        this.m_mandatoryProperties.clear();
    }

    public SrWidget createLabelWidget(String propName) {
        SrLabelField propLbl = new SrLabelField(propName);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = -1;
        constraints.insets = null;
        constraints.anchor = -1;
        constraints.fill = -1;
        constraints.weightx = -1.0;
        SrWidget labelWidget = new SrWidget(this.m_panName + KEY_SEPERATOR + propName, propLbl, false, true, false, false, constraints);
        return labelWidget;
    }

    private void insertToPanel(SrWidget widget, int col, Insets ints, double weightx) {
        String componentName = widget.getName();
        SrComponent component = widget.getComponent();
        GridBagConstraints layoutConstraints = widget.getConstraints();
        GridBagConstraints constraints = null;
        if (layoutConstraints == null) {
            constraints = new GridBagConstraints();
            constraints.gridx = col;
            constraints.gridy = this.m_propertyRow;
            constraints.insets = ints;
            constraints.anchor = 17;
            constraints.fill = 1;
            constraints.weightx = weightx;
        } else {
            constraints = layoutConstraints;
            constraints.gridx = constraints.gridx < 0 ? col : constraints.gridx;
            constraints.gridy = constraints.gridy < 0 ? this.m_propertyRow : constraints.gridy;
            constraints.insets = constraints.insets == null ? ints : constraints.insets;
            constraints.anchor = constraints.anchor < 0 ? 17 : constraints.anchor;
            constraints.fill = constraints.fill < 0 ? 1 : constraints.fill;
            constraints.weightx = constraints.weightx < 0.0 ? weightx : constraints.weightx;
        }
        this.m_pnl.add(component.getComponent(), constraints);
        if (componentName != null) {
            this.m_componentLastValue.put(componentName, component.getValue());
        }
        boolean registerListener = widget.isRegisterListener();
        boolean readOnly = widget.isReadOnly();
        if (registerListener) {
            this.addPropertyListener(component, this.m_listener);
        }
        if (readOnly) {
            widget.getComponent().setEnableComponent(!readOnly);
        }
    }

    public void forceUpdateEvent() {
        this.onUpdateEvent(null);
    }

    public void onUpdateEvent(EventObject e) {
        Vector nonValidList = this.setMandatorySign();
        PropertyPanelValidationEvent event = new PropertyPanelValidationEvent(this.getPanelName(), nonValidList);
        for (PropertyPanelValidationListener l : this.m_listeners) {
            l.onPanelPropertyChanged(event);
        }
    }

    private HashMap getSavedValuesMap() {
        HashMap results = new HashMap();
        for (Object key : this.m_saveLastValue.keySet()) {
            Object val = this.m_saveLastValue.get(key);
            results.put(this.preperKey(key), val);
        }
        return results;
    }

    public HashMap getChangedValues() {
        HashMap<String, SrComponent> changedValues = new HashMap<String, SrComponent>();
        HashMap history = this.getSavedValuesMap();
        HashMap current = this.getPanelProperties();
        Iterator iter = current.keySet().iterator();
        while (iter.hasNext()) {
            String key = this.preperKey(iter.next());
            if (!history.containsKey(key)) continue;
            SrComponent currentVal = (SrComponent)current.get(key);
            Object historyVal = history.get(key);
            if (currentVal.getValue().equals(historyVal)) continue;
            changedValues.put(key, currentVal);
        }
        return changedValues;
    }

    public SrListener getSrListener() {
        return this.m_listener;
    }

    public class SrListener
    implements ChangeListener,
    ListDataListener,
    DocumentListener,
    TableModelListener,
    PropertyChangeListener,
    ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                SrPropertyPanel.this.onUpdateEvent(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SrPropertyPanel.this.onUpdateEvent(null);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SrPropertyPanel.this.onUpdateEvent(null);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SrPropertyPanel.this.onUpdateEvent(null);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SrPropertyPanel.this.onUpdateEvent(e);
        }
    }

    public class SrItemFocusListener
    implements FocusListener {
        private String m_key;
        private SrComponent m_val;

        public SrItemFocusListener(String key, SrComponent val) {
            this.m_key = key;
            this.m_val = val;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SrPropertyPanel.this.m_saveLastValue.put(this.m_key, this.m_val.getValue());
        }

        @Override
        public void focusLost(FocusEvent e) {
            SrPropertyPanel.this.m_saveLastValue.put(this.m_key, this.m_val.getValue());
        }
    }
}

