/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.SrTreePanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.SrEventListenerManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class SrPopupMenu
extends JPopupMenu {
    public static final String NO_REASON = "";
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    protected List m_actions;
    protected JComponent m_comToWorkWith;
    protected ArrayList m_lastActionSet;
    private HashMap m_actionToitem;

    public SrPopupMenu(JComponent workWith) {
        this.setWorkWith(workWith);
        this.m_actionToitem = new HashMap();
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SrPopupMenu.this.innerReset();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SrPopupMenu.this.innerReset();
            }
        });
    }

    protected void setWorkWith(JComponent workWith) {
        this.m_comToWorkWith = workWith;
    }

    public void attachActions(List actions) {
        this.m_actions = actions;
        this.addAllActions(this, this.m_actions);
        this.m_lastActionSet = new ArrayList();
        this.m_lastActionSet.addAll(this.m_actions);
    }

    protected void addMenuItem(AbstractAction action, int index) {
        SrMenuItem item = new SrMenuItem(action);
        super.insert(item, index);
        this.m_actionToitem.put(action, item);
        this.m_actions.add(index, action);
        this.m_lastActionSet.add(index, action);
    }

    protected void addMenuItem(SrMenu parent, AbstractAction action, int index) {
        List listInLastActionMap;
        SrMenuItem item = new SrMenuItem(action);
        parent.add((Component)item, index);
        this.m_actionToitem.put(action, item);
        List listInActionMap = this.findMenuActionList(parent, this.m_actions);
        if (listInActionMap != null) {
            listInActionMap.add(index, action);
        }
        if ((listInLastActionMap = this.findMenuActionList(parent, this.m_lastActionSet)) != null) {
            listInLastActionMap.add(index, action);
        }
    }

    private List findMenuActionList(SrMenu menu, List actions) {
        if (actions.contains(menu.getAction())) {
            return actions;
        }
        for (Object element : actions) {
            List candidate;
            if (!(element instanceof List) || (candidate = this.findMenuActionList(menu, (List)element)) == null) continue;
            return candidate;
        }
        return null;
    }

    protected void addMenu(SrMenu menu, int index) {
        super.insert(menu, index);
        ArrayList<Action> menuList = new ArrayList<Action>();
        menuList.add(menu.getAction());
        this.m_lastActionSet.add(index, menuList);
        this.m_actions.add(index, menuList);
        this.m_actionToitem.put((AbstractAction)menu.getAction(), menu);
    }

    public void show(MouseEvent e) {
        List currentActions = this.validateActions(e);
        if (currentActions != null && currentActions.size() > 0) {
            if (!this.m_lastActionSet.equals(currentActions)) {
                this.removeAllActions();
                this.addAllActions(this, currentActions);
                this.m_lastActionSet = new ArrayList();
                this.m_lastActionSet.addAll(currentActions);
            }
            JComponent invoker = this.m_comToWorkWith;
            if (this.m_comToWorkWith instanceof SrTreePanel) {
                invoker = ((SrTreePanel)this.m_comToWorkWith).getTreeObject();
            } else if (this.m_comToWorkWith instanceof SrTablePanel) {
                invoker = ((SrTablePanel)this.m_comToWorkWith).getTable();
            }
            this.show(invoker, e.getX(), e.getY());
        }
    }

    protected final void addAllActions(JComponent container, List currentActions) {
        for (int i = 0; i < currentActions.size(); ++i) {
            Object obj = currentActions.get(i);
            if (obj instanceof List) {
                JMenu newMenu;
                List menuItemList = (List)obj;
                ArrayList menuItemListCloned = new ArrayList(menuItemList);
                Object main = menuItemListCloned.remove(0);
                if (main instanceof AbstractAction) {
                    AbstractAction action = (AbstractAction)main;
                    newMenu = new SrMenu(action);
                    this.m_actionToitem.put(action, newMenu);
                } else {
                    newMenu = new JMenu((String)main);
                }
                container.add(newMenu);
                this.addAllActions(newMenu, menuItemListCloned);
                continue;
            }
            if (obj instanceof AbstractAction) {
                AbstractAction act = (AbstractAction)obj;
                SrMenuItem item = new SrMenuItem(act);
                container.add(item);
                this.m_actionToitem.put(act, item);
                continue;
            }
            if (!(obj instanceof JPopupMenu.Separator)) continue;
            container.add((JPopupMenu.Separator)obj);
        }
    }

    public void removeItemFromMenu(AbstractAction act) {
        if (this.m_actionToitem.containsKey(act)) {
            this.m_actionToitem.remove(act);
            this.m_actions.remove(act);
        }
    }

    protected abstract void innerReset();

    protected void removeAllActions() {
        this.removeAll();
        this.m_lastActionSet.clear();
        this.m_actionToitem.clear();
        this.innerReset();
    }

    protected List validateActions(MouseEvent e) {
        return this.m_actions;
    }

    public void addListener(EventListener l) {
        this.m_listeners.add(l);
    }

    public void removeListener(EventListener l) {
        this.m_listeners.remove(l);
    }

    public SrMenu getSrMenu(AbstractAction act) {
        SrMenu menu = null;
        JMenuItem item = (JMenuItem)this.m_actionToitem.get(act);
        if (item instanceof SrMenu) {
            menu = (SrMenu)item;
        }
        return menu;
    }

    protected SrMenuItem getMenuItem(SrAction action) {
        SrMenuItem menu = null;
        JMenuItem item = (JMenuItem)this.m_actionToitem.get(action);
        if (item instanceof SrMenuItem) {
            menu = (SrMenuItem)item;
        }
        return menu;
    }

    public boolean isMenuItemCreated(AbstractAction act) {
        return this.m_actionToitem.containsKey(act);
    }

    protected List getCurrentActions() {
        return this.m_actions;
    }

    protected String appendTooltipText(String inTip1, String inTip2) {
        if (inTip2 == null) {
            return inTip1;
        }
        if (inTip1 == null) {
            return inTip2;
        }
        return inTip1 + "; " + inTip2;
    }
}

