/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.SrSubstanceAquaTheme;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jvnet.substance.color.ColorScheme;

public class SrPanelTitle
extends JPanel {
    private static Color theGradientColorFrom = null;
    private static Color theGradientColorTo = null;
    private JLabel myLabel = new JLabel();

    public SrPanelTitle() {
        this("");
        theGradientColorFrom = this.validateColors(SrDefaultUIBundleKeys.SUBSTANCE_LOOK_AND_FEEL_STYLE_1).getUltraDarkColor();
        theGradientColorTo = this.validateColors(SrDefaultUIBundleKeys.SUBSTANCE_LOOK_AND_FEEL_STYLE_2).getLightColor();
    }

    private ColorScheme validateColors(SrDefaultUIBundleKeys aBundleKey) {
        ColorScheme colorScheme;
        SrSubstanceAquaTheme theme = SrSubstanceAquaTheme.getThemeByName(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(aBundleKey));
        if (theme != null && (colorScheme = theme.getColorScheme()) != null) {
            return colorScheme;
        }
        return SrSubstanceAquaTheme.CYAN.getColorScheme();
    }

    public SrPanelTitle(String text) {
        this.myLabel.setText(text);
        this.myLabel.setFont(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getFontResource(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT));
        this.myLabel.setForeground(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getColorResource(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FOREGROUND));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SrPanelTitle.this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, SrPanelTitle.this.getHeight()));
            }
        });
        this.setLayout(new FlowLayout(1, 5, 2));
        this.setOpaque(false);
        this.add(this.myLabel);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color prevColor = g.getColor();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        Color color1 = theGradientColorFrom;
        Color color2 = theGradientColorTo;
        GradientPaint colorGrad = new GradientPaint(0.0f, 0.0f, color1, w, h, color2);
        ((Graphics2D)g).setPaint(colorGrad);
        g.fillRect(0, 0, w - h, h);
        g.fillArc(w - h * 2, 0, h * 2, h * 2, 0, 90);
        g.setColor(prevColor);
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }
}

