/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.actions.SrAction;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JOptionPane;

public class SrOptionPaneUtil {
    public static final SrOptionPane.Option<String> YES_BUTTON = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_YES));
    public static final SrOptionPane.Option<String> NO_BUTTON = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_NO));
    public static final SrOptionPane.Option<String> OK_BUTTON = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_OK));
    public static final SrOptionPane.Option<String> CANCEL_BUTTON = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_CANCEL));
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int YES_TO_ALL_OPTION = 3;
    private static String MESSAGE_PREFIX = "";
    private static String TITLE_PREFIX = "";
    private static final String ERROR_TITLE = SrAction.BUNDLE.getString(SrDefaultUIBundleKeys.ERROR_DIALOG_TITLE);

    private SrOptionPaneUtil() {
    }

    public static SrOptionPane.Option<String> showYesNoConfirmDialog(String aTitle, String aMessage, SrOptionPane.MessageType aMessageType, Window aOwner) {
        SrOptionPane optionPane = new SrOptionPane(aTitle, aMessage, aMessageType, aOwner);
        optionPane.addButtons(YES_BUTTON, NO_BUTTON);
        return optionPane.show();
    }

    public static void showErrorMsg(Window aOwner, String aMessage, String aTitle) {
        SrOptionPane optionPane = new SrOptionPane(aTitle, aMessage, SrOptionPane.MessageType.ERROR_DIALOG, aOwner);
        optionPane.addButtons(OK_BUTTON);
        optionPane.show();
    }

    public static void showInfoMsg(Component parentComponent, String message, String title) {
        JOptionPane.showMessageDialog(parentComponent, MESSAGE_PREFIX + message, TITLE_PREFIX + title, 1);
    }

    public static int showYesNoConfirmDialog(Component parentComponent, String message, String title) {
        return JOptionPane.showConfirmDialog(parentComponent, MESSAGE_PREFIX + message, TITLE_PREFIX + title, 0);
    }

    public static int showYesNoCancelConfirmDialog(Component parentComponent, String message, String title) {
        return JOptionPane.showConfirmDialog(parentComponent, MESSAGE_PREFIX + message, TITLE_PREFIX + title, 1);
    }

    public static SrOptionPane.Option<String> showOkCancelConfirmDialog(Window aOwner, String aMessage, String aTitle) {
        SrOptionPane optionPane = new SrOptionPane(aTitle, aMessage, SrOptionPane.MessageType.WARNING_DIALOG, aOwner);
        optionPane.addButtons(OK_BUTTON, CANCEL_BUTTON);
        return optionPane.show();
    }

    public static String getTitlePrefix() {
        return TITLE_PREFIX;
    }

    public static void showErrorMessage(Window aOwner, String aMessage) {
        SrOptionPaneUtil.showErrorMsg(aOwner, aMessage, ERROR_TITLE);
    }
}

