/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.components.SrCheckBoxesPanel;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrRadioButtonsPanel;
import com.sanrad.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SrOptionPane {
    private Window myParentWindow;
    private String myMessage;
    private String myTitle;
    private MessageType myMessageType;
    private JComponent myAdditionalComponent;
    private Option myDefaultButtonOption;
    private ArrayList<Option> myButtonList = new ArrayList();
    private SrRadioButtonsPanel myRadioPanel;
    private SrCheckBoxesPanel myCheckBoxesPanel;

    public SrOptionPane(String aTitle, String aMessage, MessageType aMessageType, Window aOwner) {
        this.myParentWindow = aOwner;
        this.initParams(aTitle, aMessage, aMessageType);
    }

    private void initParams(String aTitle, String aMessage, MessageType aMessageType) {
        this.setTitle(aTitle);
        this.setMessage(aMessage);
        this.setMessageType(aMessageType);
    }

    public final void setTitle(String aTitle) {
        if (aTitle == null) {
            throw new IllegalArgumentException("A title must be supplied");
        }
        this.myTitle = aTitle;
    }

    public final void setMessage(String aMessage) {
        if (aMessage == null) {
            throw new IllegalArgumentException("A message must be supplied");
        }
        this.myMessage = aMessage;
    }

    public final void setDefaultButton(Option aOption) {
        this.myDefaultButtonOption = aOption;
    }

    public final void setMessageType(MessageType aMessageType) {
        if (aMessageType == null) {
            throw new IllegalArgumentException("A message type must be supplied");
        }
        this.myMessageType = aMessageType;
    }

    public final void setAdditionalComponent(JComponent aComp) {
        this.myAdditionalComponent = aComp;
    }

    public final Font getFont() {
        return UIManager.getFont("OptionPane.font");
    }

    public <V> void addButton(Option<V> aButtonOption, int aPosition) {
        Util.ensureCapacityAndAdd(this.myButtonList, aPosition, aButtonOption);
    }

    public <V> void addButtons(Option<V> ... aButtons) {
        for (Option<V> b : aButtons) {
            this.addButton(b, this.myButtonList.size());
        }
    }

    public <V> void addRadioButton(Option<V> aRadioOption) {
        if (this.myRadioPanel == null) {
            this.myRadioPanel = new SrRadioButtonsPanel();
        }
        this.myRadioPanel.addRadio(aRadioOption.getText(), aRadioOption);
    }

    public <V> Option<V> getSelectedRadioOption() {
        if (this.myRadioPanel == null) {
            return null;
        }
        return (Option)this.myRadioPanel.getValue();
    }

    public void addCheckBox(Option aCheckBoxOption) {
        this.addCheckBox(aCheckBoxOption, false);
    }

    public void addCheckBox(Option aCheckBoxOption, boolean defaultState) {
        if (this.myCheckBoxesPanel == null) {
            this.myCheckBoxesPanel = new SrCheckBoxesPanel();
        }
        this.myCheckBoxesPanel.addCheckBox(aCheckBoxOption.getText(), aCheckBoxOption, defaultState);
    }

    public void setCheckBoxToolTip(Option aCheckBoxOption, String aToolTipText) {
        SrCheckbox chkBox = this.myCheckBoxesPanel.getCheckBox(aCheckBoxOption.getText());
        chkBox.setToolTipText(aToolTipText);
    }

    public void setEnableCheckbox(Option aCheckBoxOption, boolean aEnable) {
        SrCheckbox chkBox = this.myCheckBoxesPanel.getCheckBox(aCheckBoxOption.getText());
        chkBox.setEnableComponent(aEnable);
    }

    public <V> List<Option<V>> getSelectedCheckBoxes() {
        if (this.myCheckBoxesPanel == null) {
            return Collections.EMPTY_LIST;
        }
        return this.myCheckBoxesPanel.getSelectedValues();
    }

    public final <V> Option<V> show() {
        JComponent additionalComponent = null;
        if (this.myAdditionalComponent != null) {
            additionalComponent = this.myAdditionalComponent;
        } else {
            SrPanel additionalPanel = new SrPanel(new BorderLayout());
            boolean hasAdditionalComponents = false;
            if (this.myCheckBoxesPanel != null) {
                this.myCheckBoxesPanel.setFont(this.getFont());
                additionalPanel.add((Component)this.myCheckBoxesPanel, "North");
                hasAdditionalComponents = true;
            }
            if (this.myRadioPanel != null) {
                this.myRadioPanel.setFont(this.getFont());
                additionalPanel.add((Component)this.myRadioPanel, "South");
                hasAdditionalComponents = true;
            }
            if (hasAdditionalComponents) {
                additionalComponent = additionalPanel;
            }
        }
        CustomizedOptionPane pane = new CustomizedOptionPane((Object)this.myMessage, this.myMessageType.getType(), this.myButtonList.toArray(), this.myDefaultButtonOption, additionalComponent);
        pane.createDialog(this.myParentWindow, this.myTitle).setVisible(true);
        return (Option)pane.getValue();
    }

    public static class Option<V> {
        private String myText;
        private V myValue;

        public Option(V aValue) {
            this(null, aValue);
        }

        public Option(String aText, V aValue) {
            if (aValue == null) {
                throw new IllegalArgumentException("Text or value must be supplied");
            }
            this.myText = aText != null ? aText : aValue.toString();
            this.myValue = aValue;
        }

        String getText() {
            return this.myText;
        }

        V getValue() {
            return this.myValue;
        }

        public String toString() {
            return this.getText();
        }
    }

    private static class CustomizedOptionPane
    extends JOptionPane {
        private JComponent myAdditionalComponent;

        public CustomizedOptionPane(Object aMessage, int aMessageType, Object[] aOptions, Object aDefaultOption) {
            this(aMessage, aMessageType, aOptions, aDefaultOption, null);
        }

        public CustomizedOptionPane(Object aMessage, int aMessageType, Object[] aOptions, Object aDefaultOption, JComponent aAdditionalComponent) {
            super(aMessage, aMessageType, 2, null, aOptions, aDefaultOption);
            if (aAdditionalComponent != null) {
                this.setAdditionalComponent(aAdditionalComponent);
            }
        }

        private void setAdditionalComponent(JComponent aComp) {
            this.myAdditionalComponent = aComp;
            Component paneBody = SrSwingUtils.getChildComponentByName("OptionPane.realBody", this);
            if (!(paneBody instanceof Container)) {
                throw new IllegalStateException("Building the SrOptionPane encounter a problem, the OptionPane.realBody in not a Container, but is " + paneBody.getClass());
            }
            Container container = (Container)paneBody;
            this.myAdditionalComponent.setBorder(new EmptyBorder(5, 10, 10, 0));
            container.add((Component)this.myAdditionalComponent, "South");
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 70;
        }
    }

    public static enum MessageType {
        ERROR_DIALOG(0),
        PLAIN_DIALOG(-1),
        INFORMATION_DIALOG(1),
        QUESTION_DIALOG(3),
        WARNING_DIALOG(2);

        private int myType;

        private MessageType(int aType) {
            this.myType = aType;
        }

        int getType() {
            return this.myType;
        }
    }
}

