/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.gui.SrClientTreePanel;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.components.SrLabelField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SrDragAndDropTreePanel
extends SrClientTreePanel
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DragSource dragSource = DragSource.getDefaultDragSource();
    protected TreePath SelectedTreePath = null;
    protected DefaultMutableTreeNode SelectedNode = null;

    public SrDragAndDropTreePanel(SrTreeModel model) {
        super(model);
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this.m_tree, this.getDragValidActions(), this);
        dgr.setSourceActions(dgr.getSourceActions());
        DropTarget dropTarget = new DropTarget(this.m_tree, this);
    }

    protected int getDragValidActions() {
        return 2;
    }

    @Override
    protected void onTreeSelectionEvent(TreeSelectionEvent event) {
        this.SelectedTreePath = event.getNewLeadSelectionPath();
        if (this.SelectedTreePath == null) {
            this.SelectedNode = null;
            return;
        }
        this.SelectedNode = (DefaultMutableTreeNode)this.SelectedTreePath.getLastPathComponent();
    }

    private DefaultMutableTreeNode getNewLeadSelectedNode() {
        return this.SelectedNode;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        DefaultMutableTreeNode dragNode = this.getNewLeadSelectedNode();
        if (dragNode != null && dragNode instanceof Transferable) {
            Cursor cursor = this.selectCursor(e.getDragAction());
            this.dragSource.startDrag(e, cursor, (Transferable)((Object)dragNode), this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point cursorLocationBis = dtde.getLocation();
        TreePath destinationPath = this.m_tree.getPathForLocation(cursorLocationBis.x, cursorLocationBis.y);
        if (this.testDropTarget(destinationPath, this.SelectedTreePath) == null) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable targetTrans;
        DataFlavor[] dfList;
        Transferable tr = dtde.getTransferable();
        Point loc = dtde.getLocation();
        TreePath destinationPath = this.m_tree.getPathForLocation(loc.x, loc.y);
        final String msg = this.testDropTarget(destinationPath, this.SelectedTreePath);
        if (msg != null) {
            dtde.rejectDrop();
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SrDragAndDropTreePanel.this.m_tree, msg, "Error Dialog", 0);
                }
            });
            return;
        }
        DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)destinationPath.getLastPathComponent();
        boolean foundFlaver = false;
        if (newParent instanceof Transferable && (dfList = (targetTrans = (Transferable)((Object)newParent)).getTransferDataFlavors()) != null) {
            for (int i = 0; i < dfList.length; ++i) {
                if (!tr.isDataFlavorSupported(dfList[i])) continue;
                foundFlaver = true;
                break;
            }
        }
        if (!foundFlaver) {
            dtde.rejectDrop();
            return;
        }
        DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)this.getNewLeadSelectedNode().getParent();
        int action = dtde.getDropAction();
        boolean copyAction = action == 1;
        try {
            if (!copyAction) {
                oldParent.remove(this.getNewLeadSelectedNode());
            }
            newParent.insert(this.getNewLeadSelectedNode(), 0);
            if (copyAction) {
                dtde.acceptDrop(1);
            } else {
                dtde.acceptDrop(2);
            }
        }
        catch (IllegalStateException ils) {
            dtde.rejectDrop();
        }
        dtde.getDropTargetContext().dropComplete(true);
        SrTreeModel model = (SrTreeModel)this.m_tree.getModel();
        model.reload(oldParent);
        model.reload(newParent);
        TreePath parentPath = new TreePath(newParent.getPath());
        this.m_tree.expandPath(parentPath);
    }

    private String testDropTarget(TreePath destination, TreePath dropper) {
        boolean destinationPathIsNull;
        boolean bl = destinationPathIsNull = destination == null;
        if (destinationPathIsNull) {
            return "Invalid drop location.";
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)destination.getLastPathComponent();
        if (!node.getAllowsChildren()) {
            return "This node does not allow children";
        }
        if (destination.equals(dropper)) {
            return "Destination cannot be same as source";
        }
        if (dropper.isDescendant(destination)) {
            return "Destination node cannot be a descendant.";
        }
        if (dropper.getParentPath().equals(destination)) {
            return "Destination node cannot be a parent.";
        }
        return null;
    }

    private Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<Serializable> vec = new Vector<Serializable>();
        Vector<SrLabelField> vec1 = new Vector<SrLabelField>();
        Vector<SrLabelField> vec2 = new Vector<SrLabelField>();
        vec.add(new SrLabelField("9"));
        vec.add(new SrLabelField("8"));
        vec.add(vec1);
        vec1.add(new SrLabelField("7"));
        vec1.add(new SrLabelField("6"));
        vec1.add(new SrLabelField("5"));
        vec1.add(new SrLabelField("4"));
        vec.add(vec2);
        vec2.add(new SrLabelField("3"));
        vec2.add(new SrLabelField("2"));
        vec2.add(new SrLabelField("10"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new SrLabelField("root"));
        SrTreeModel model = new SrTreeModel(root, vec, true);
        final SrDragAndDropTreePanel pan = new SrDragAndDropTreePanel(model);
        pan.expandTree();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)pan, "South");
        p.add(new JButton(new AbstractAction("Test"){

            @Override
            public void actionPerformed(ActionEvent e) {
                pan.sortTree(false);
            }
        }));
        JDialog dlg = new JDialog((Frame)null, "SrTablePanel Show", true);
        dlg.getContentPane().add(p);
        dlg.setSize(p.getPreferredSize());
        dlg.show();
        System.exit(0);
    }
}

