/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrLabelField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class SrActionLabel
extends SrLabelField
implements PropertyChangeListener {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private UnderlineIcon linkIcon = new UnderlineIcon();
    private Border border = new DashedBorder();
    private boolean paintBorder = false;
    private String actionCommand;
    private boolean isHTMLLinkUnderlined = true;
    private AbstractAction myAction;
    private String myLabelText;

    private SrActionLabel() {
        this.addFocusListener(new FocusHandler());
        this.setRequestFocusEnabled(true);
        this.setHTMLLinkUnderlined(this.isHTMLLinkUnderlined);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SrActionLabel.this.requestFocus();
                if (SrActionLabel.this.isEnabled() && SrActionLabel.this.myAction != null) {
                    SrActionLabel.this.myAction.actionPerformed(new ActionEvent(this, 1001, SrActionLabel.this.getActionCommand()));
                }
            }
        });
    }

    public SrActionLabel(SrAction action) {
        this();
        this.setAction(action);
    }

    @Override
    protected String getFormattedText(String text) {
        return text;
    }

    public void setAction(SrAction aAction) {
        if (this.myAction != null) {
            this.myAction.removePropertyChangeListener(this);
        }
        this.myAction = aAction;
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myAction != null, new Object[]{"SrActionLabel got null action"});
        if (this.myAction != null) {
            this.setText((String)this.myAction.getValue("Name"));
            this.setToolTipText((String)this.myAction.getValue("ShortDescription"));
            this.setIcon((Icon)this.myAction.getValue("SmallIcon"));
            Boolean visible = (Boolean)this.myAction.getValue("visible");
            if (visible != null) {
                this.setVisible(visible);
            }
            this.setEnabled(this.myAction.isEnabled());
            this.myAction.addPropertyChangeListener(this);
        }
    }

    public AbstractAction getAction() {
        return this.myAction;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand != null ? this.actionCommand : this.getText();
    }

    public void setHTMLLinkUnderlined(boolean isHTMLLink) {
        this.isHTMLLinkUnderlined = isHTMLLink;
        if (this.isHTMLLinkUnderlined && this.isEnabled()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.setIcon(this.linkIcon);
        this.setVerticalTextPosition(1);
        this.setHorizontalTextPosition(0);
    }

    public boolean isHTMLLinkUnderlined() {
        return this.isHTMLLinkUnderlined;
    }

    public void setPaintBorder(boolean b) {
        this.paintBorder = b;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setCursor(enabled && this.isHTMLLinkUnderlined ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean value;
        String property = evt.getPropertyName();
        if (property.equals("visible")) {
            value = (Boolean)evt.getNewValue();
            this.setVisible(value);
        }
        if (property.equals("enabled")) {
            value = (Boolean)evt.getNewValue();
            this.setEnabled(value);
        }
        if (property.equals("ShortDescription")) {
            this.setToolTipText((String)evt.getNewValue());
        }
        if (property.equals("Name")) {
            super.setText(this.myLabelText == null ? (String)evt.getNewValue() : this.myLabelText);
        }
    }

    public void setLabelText(String text) {
        this.myLabelText = text;
        this.setText(this.myLabelText);
    }

    private class UnderlineIcon
    implements Icon {
        private UnderlineIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!SrActionLabel.this.isEnabled()) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(SrActionLabel.this.getForeground());
            g.drawLine(x, y - 6, x + this.getIconWidth(), y - 6);
            g.setColor(oldColor);
        }

        private int getFontHieght() {
            return SrActionLabel.this.getFontMetrics(SrActionLabel.this.getFont()).getHeight();
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return SrActionLabel.this.getFontMetrics(SrActionLabel.this.getFont()).stringWidth(SrActionLabel.this.getText() != null ? SrActionLabel.this.getText() : "");
        }
    }

    private class DashedBorder
    extends AbstractBorder {
        private DashedBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.drawBrokenRect(g, x, y, width, height);
        }

        private void drawBrokenRect(Graphics g, int x, int y, int width, int height) {
            int i;
            for (i = x; i < x + width; i += 4) {
                g.drawLine(i, y, i + 2, y);
                g.drawLine(i, y + height - 1, i + 2, y + height - 1);
            }
            for (i = y; i < y + height; i += 4) {
                g.drawLine(x, i, x, i + 2);
                g.drawLine(x + width - 1, i, x + width - 1, i + 2);
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusPic();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.unfocusPic();
        }

        private void focusPic() {
            SrActionLabel.this.setBorder(SrActionLabel.this.paintBorder ? SrActionLabel.this.border : null);
        }

        private void unfocusPic() {
            SrActionLabel.this.setBorder(null);
        }
    }
}

