/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.components.SrProgressDotsPanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SplashWindow
extends JFrame {
    private SplashPanel m_splashPanel;
    private String version = null;
    private Color versionColor;
    private Font versionFont;
    private int versionX;
    private int versionY;
    private SrProgressDotsPanel m_progressPanel = new SrProgressDotsPanel(6, 4);

    private SplashWindow(ImageIcon splashImageIcon, String title, ImageIcon icon, Color versionColor) {
        super(title);
        this.setIconImage(icon.getImage());
        this.setUndecorated(true);
        try {
            SrResourceBundle uiBundle = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US);
            this.m_splashPanel = new SplashPanel(splashImageIcon);
            this.m_progressPanel.setLabelFont(uiBundle.getFontResource(SrDefaultUIBundleKeys.SPLASH_WINDOW_FONT));
            this.m_progressPanel.setProgressForeground(versionColor);
            this.setSize(splashImageIcon.getIconWidth(), splashImageIcon.getIconHeight());
            this.jbInit();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = new Dimension(splashImageIcon.getIconWidth(), splashImageIcon.getIconHeight());
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SplashWindow(ImageIcon splashImageIcon, String title, ImageIcon icon, String version, int versionX, int versionY, Color versionColor, Font versionFont) {
        this(splashImageIcon, title, icon, versionColor);
        this.version = version;
        this.versionX = versionX;
        this.versionY = versionY;
        this.versionColor = versionColor;
        this.versionFont = versionFont;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_splashPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.m_splashPanel, c);
        c.anchor = 16;
        c.fill = 0;
        c.insets = new Insets(0, 10, 27, 0);
        this.m_splashPanel.add((Component)this.m_progressPanel, c);
    }

    public void drawMessage(final String msg, final boolean isProgress) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    SplashWindow.this.startProgress(msg, isProgress);
                }
            });
        } else {
            this.startProgress(msg, isProgress);
        }
    }

    private void startProgress(String msg, boolean isProgress) {
        this.m_progressPanel.setText(msg);
        if (isProgress) {
            this.m_progressPanel.startProgress();
        } else {
            this.m_progressPanel.setProgressEnabled(false);
            this.m_progressPanel.stopPorgress();
        }
    }

    public void error(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    SplashWindow.this.stopProgress(msg);
                }
            });
        } else {
            this.stopProgress(msg);
        }
    }

    private void stopProgress(String msg) {
        this.m_progressPanel.setText(msg);
        this.m_progressPanel.stopPorgress();
    }

    @Override
    public void dispose() {
        this.m_progressPanel.stopPorgress();
        super.dispose();
    }

    class SplashPanel
    extends JPanel {
        ImageIcon m_imageIcon;

        SplashPanel(ImageIcon imageIcon) {
            this.m_imageIcon = imageIcon;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.m_imageIcon.getImage(), 0, 0, this.m_imageIcon.getIconWidth(), this.m_imageIcon.getIconHeight(), this.m_imageIcon.getImageObserver());
            Color prevColor = g.getColor();
            Font prevFont = g.getFont();
            if (SplashWindow.this.version != null) {
                g.setColor(SplashWindow.this.versionColor);
                g.setFont(SplashWindow.this.versionFont);
                g.drawString(SplashWindow.this.version, SplashWindow.this.versionX, SplashWindow.this.versionY);
                g.setFont(prevFont);
            }
            g.setColor(prevColor);
            g.setFont(prevFont);
        }
    }
}

