/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public abstract class OKCancelFrame
extends JFrame
implements OperationController {
    private static SrResourceBundle UI_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US);
    public static final String OK = UI_BUNDLE.getString(SrDefaultUIBundleKeys.OK_BUTTON_TEXT);
    public static final String CLOSE = UI_BUNDLE.getString(SrDefaultUIBundleKeys.CLOSE_BUTTON_TEXT);
    public static final String CANCEL = UI_BUNDLE.getString(SrDefaultUIBundleKeys.CANCEL_BUTTON_TEXT);
    private SrPanel myCenteralPanel = new SrPanel(new BorderLayout());
    private boolean okPressed = false;
    protected SrPanel buttonsPanel = new SrPanel();
    protected SrPanel messagePanel = new SrPanel();
    private FlowLayout flowLayout2 = new FlowLayout();
    private FlowLayout flowLayout3 = new FlowLayout(0, 10, 0);
    protected JButton btnCancel = new JButton();
    protected JButton btnOK = new JButton();
    private JLabel messageLabel = new JLabel();
    private MouseAdapter m_mouseListenerForGlassPane = new MouseAdapter(){};
    private SrComponentStatusBarPanel m_statusBar = new SrComponentStatusBarPanel();
    private boolean m_useStatusBar = true;

    protected OKCancelFrame(JFrame owner, String title) {
        this.setIconImage(owner.getIconImage());
        this.setTitle(title);
        this.init();
    }

    protected void doFirst() {
    }

    private void init() {
        this.jbInit();
        this.setButtons();
        this.btnOK.setPreferredSize(this.btnCancel.getPreferredSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OKCancelFrame.this.doOnCancel();
                OKCancelFrame.this.dispose();
            }
        });
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.messagePanel.setLayout(this.flowLayout3);
        this.flowLayout2.setAlignment(2);
        this.doFirst();
        if (this.isStatusBarInUse()) {
            SrPanel statusPlusButtonPanel = new SrPanel(new BorderLayout());
            statusPlusButtonPanel.add((Component)this.buttonsPanel, "Center");
            statusPlusButtonPanel.add((Component)this.m_statusBar, "South");
            this.getContentPane().add((Component)statusPlusButtonPanel, "South");
        } else {
            this.getContentPane().add((Component)this.buttonsPanel, "South");
        }
        this.myCenteralPanel.add((Component)this.messagePanel, "North");
        this.buttonsPanel.add((Component)this.btnOK, null);
        this.buttonsPanel.add((Component)this.btnCancel, null);
        this.messagePanel.add((Component)this.messageLabel, null);
        this.setBackgroungColor(this.buttonsPanel);
        this.setBackgroungColor(this.messagePanel);
        this.getContentPane().add((Component)this.myCenteralPanel, "Center");
    }

    protected void btnOK_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.dispose();
        this.doOnOK();
    }

    public void removeListeners() {
    }

    public void addListeners() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeListeners();
        new ComponentHandler(this.getContentPane()).clearAllSelections(JTable.class);
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.doOnCancel();
        this.dispose();
    }

    @Override
    public final void inProcess(String message) {
        StatusPanel.getInstance().setLevel(StatusPanel.NO_INFO);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public final void fail(String msg) {
        this.setVisible(true);
        SrOptionPaneUtil.showErrorMessage(this, msg);
        this.setCursor(null);
    }

    @Override
    public final void success(SrAction action) {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
        this.setCursor(null);
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    protected SrPanel createPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        panel.add(c2);
        return panel;
    }

    protected SrPanel createSrPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        if (c2 != null) {
            panel.add(c2);
        }
        return panel;
    }

    protected void addCenterPanel(Component aComp) {
        this.myCenteralPanel.add(aComp, "Center");
    }

    protected void addNorthPanel(Component aComp) {
        this.getContentPane().add(aComp, "North");
    }

    protected abstract void doOnOK();

    public abstract void doOnCancel();

    protected void setBackgroungColor(JComponent component) {
        component.setBackground(LookAndFill.DIALOG_COLOR);
    }

    protected SrTextField getUnknownTextField() {
        SrTextField txtField = new SrTextField();
        txtField.setText("unknown");
        txtField.setEnabled(false);
        return txtField;
    }

    protected void setOKButtonText() {
        this.btnOK.setText(OK);
    }

    protected void setCancelButtonText() {
        this.btnCancel.setText(CANCEL);
    }

    protected void setButtons() {
        this.setOKButtonText();
        this.setCancelButtonText();
        AbstractAction okAct = new AbstractAction(this.btnOK.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelFrame.this.btnOK_actionPerformed(e);
            }
        };
        AbstractAction cancelAct = new AbstractAction(this.btnCancel.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelFrame.this.btnCancel_actionPerformed(e);
            }
        };
        this.btnOK.setAction(okAct);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.btnOK.registerKeyboardAction(okAct, enter, 2);
        this.btnCancel.setAction(cancelAct);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.btnCancel.registerKeyboardAction(cancelAct, escape, 2);
        this.setDefaultButton();
    }

    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setDefaultButton();
            Dimension screenDim = this.getToolkit().getScreenSize();
            Rectangle abounds = this.getBounds();
            this.setLocation((screenDim.width - abounds.width) / 2, (screenDim.height - abounds.height) / 2);
        }
        super.setVisible(visible);
    }

    @Override
    public void show() {
        this.addListeners();
        SrSwingUtils.setLocationOnScreenCenter(this);
        super.show();
    }

    protected void setMessageText(String msg) {
        this.messageLabel.setText(msg);
    }

    public String getStatusStr() {
        return this.m_statusBar.getStatusStr();
    }

    public void setStatusStr(String statusStr) {
        this.m_statusBar.setStatusStr(statusStr);
    }

    public void setStatusStr(String statusStr, StatusPanel.Level statusLevel) {
        this.m_statusBar.setStatusStr(statusStr, statusLevel);
    }

    protected boolean isStatusBarInUse() {
        return this.m_useStatusBar;
    }

    public void setWaitCursor() {
        this.getGlassPane().addMouseListener(this.m_mouseListenerForGlassPane);
        this.getGlassPane().setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        this.getGlassPane().removeMouseListener(this.m_mouseListenerForGlassPane);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        SrSwingUtils.setWindowMinimumWidthByTitle(this, title);
    }

    public void setSizeAndMoveToCenter(int width, int height) {
        super.setSize(width, height);
        this.setLocationRelativeTo(this.getOwner());
    }
}

