/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public abstract class OKCancelDialog
extends JDialog
implements OperationController {
    private static SrResourceBundle UI_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US);
    public static final String OK = UI_BUNDLE.getString(SrDefaultUIBundleKeys.OK_BUTTON_TEXT);
    public static final String CLOSE = UI_BUNDLE.getString(SrDefaultUIBundleKeys.CLOSE_BUTTON_TEXT);
    public static final String CANCEL = UI_BUNDLE.getString(SrDefaultUIBundleKeys.CANCEL_BUTTON_TEXT);
    private SrPanel myCenteralPanel = new SrPanel(new BorderLayout());
    protected SrPanel buttonsPanel = new SrPanel();
    protected SrPanel messagePanel = new SrPanel();
    protected JButton btnCancel = new JButton();
    private JButton btnOK = new JButton();
    private JLabel messageLabel = new JLabel();
    private MouseAdapter m_mouseListenerForGlassPane = new MouseAdapter(){};
    private SrComponentStatusBarPanel m_statusBar = new SrComponentStatusBarPanel();
    private boolean m_useStatusBar = true;
    protected boolean myIsShouldDispose = true;
    protected boolean myIsShowErrMsg = true;

    protected OKCancelDialog(JFrame owner, String title) {
        this(owner, title, true);
    }

    protected OKCancelDialog(JDialog owner, String title) {
        this(owner, title, true);
    }

    protected OKCancelDialog(JFrame frame, String title, boolean modal) {
        this((Window)frame, title, modal);
    }

    protected OKCancelDialog(JDialog dialog, String title, boolean modal) {
        this((Window)dialog, title, modal);
    }

    protected OKCancelDialog(Window owner, String title, boolean modal) {
        super(owner, title);
        this.setModal(modal);
        this.init();
    }

    protected void doFirst() {
    }

    private void init() {
        this.jbInit();
        this.setButtons();
        this.btnOK.setPreferredSize(this.btnCancel.getPreferredSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OKCancelDialog.this.doOnCancel();
                OKCancelDialog.this.dispose();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent aE) {
                OKCancelDialog.this.removeListeners();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                OKCancelDialog.this.addListeners();
                OKCancelDialog.this.onVisible();
            }
        });
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.messagePanel.setLayout(new FlowLayout(0, 10, 0));
        this.doFirst();
        if (this.isStatusBarInUse()) {
            SrPanel statusPlusButtonPanel = new SrPanel(new BorderLayout());
            statusPlusButtonPanel.add((Component)this.buttonsPanel, "Center");
            statusPlusButtonPanel.add((Component)this.m_statusBar, "South");
            this.getContentPane().add((Component)statusPlusButtonPanel, "South");
        } else {
            this.getContentPane().add((Component)this.buttonsPanel, "South");
        }
        this.myCenteralPanel.add((Component)this.messagePanel, "North");
        this.buttonsPanel.add(this.btnOK);
        this.buttonsPanel.add(this.btnCancel);
        this.messagePanel.add(this.messageLabel);
        this.setComponentBgColor(this.buttonsPanel);
        this.setComponentBgColor(this.messagePanel);
        this.getContentPane().add((Component)this.myCenteralPanel, "Center");
    }

    public abstract void removeListeners();

    public void addListeners() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeListeners();
        new ComponentHandler(this.getContentPane()).clearAllSelections(JTable.class);
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.doOnCancel();
        this.dispose();
    }

    @Override
    public void inProcess(String message) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatusStr(message);
    }

    @Override
    public void fail(String message) {
        this.setDefaultCursor();
        this.setStatusStr(StatusPanel.READY);
        if (this.myIsShowErrMsg) {
            SrOptionPaneUtil.showErrorMessage(this, message);
        }
    }

    @Override
    public void success(SrAction action) {
        this.setDefaultCursor();
        this.setStatusStr("");
        if (action != null && action == this.btnOK.getAction() && this.myIsShouldDispose) {
            this.dispose();
        }
    }

    protected SrPanel createPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        panel.add(c2);
        return panel;
    }

    protected SrPanel createSrPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        if (c2 != null) {
            panel.add(c2);
        }
        return panel;
    }

    protected void addLabelAndField(SrPanel aPanel, GridBagConstraints aConstraints, String aText, Component aFieldComp, int aLineInPanel) {
        aConstraints.gridy = aLineInPanel;
        aConstraints.gridx = 0;
        SrLabelField label = new SrLabelField(aText);
        label.setFont(LookAndFill.GENERAL_FONT);
        aPanel.add((Component)label, aConstraints);
        aConstraints.gridx = 1;
        aPanel.add(aFieldComp, aConstraints);
    }

    public static GridBagConstraints getGridBagConstraintsForSimpleFields() {
        return SrSwingUtils.getGridBagConstraintsForSimpleFields();
    }

    protected void addCenterPanel(Component aComp) {
        this.myCenteralPanel.add(aComp, "Center");
    }

    protected void addNorthPanel(Component aComp) {
        this.getContentPane().add(aComp, "North");
    }

    protected void setOKAction(SrAction action) {
        if (action.getValue("Name") == null) {
            action.setName(OK);
        }
        this.btnOK.setAction(action);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.btnOK.registerKeyboardAction(action, enter, 2);
        action.addControllerAsListener(this);
    }

    public abstract void doOnCancel();

    protected void setComponentBgColor(JComponent component) {
        component.setBackground(LookAndFill.DIALOG_COLOR);
    }

    protected SrTextField getUnknownTextField() {
        SrTextField txtField = new SrTextField();
        txtField.setText("unknown");
        txtField.setEnabled(false);
        return txtField;
    }

    protected void setCancelButtonText() {
        this.btnCancel.setText(CANCEL);
    }

    protected void setButtons() {
        this.setCancelButtonText();
        AbstractAction cancelAct = new AbstractAction(this.btnCancel.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelDialog.this.btnCancel_actionPerformed(e);
            }
        };
        this.btnCancel.setAction(cancelAct);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.btnCancel.registerKeyboardAction(cancelAct, escape, 2);
        this.setDefaultButton();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setSizeAndMoveToCenter(int width, int height) {
        super.setSize(width, height);
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void pack() {
        super.pack();
        Dimension size = this.getSize();
        size.width += 35;
        this.setSize(size);
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    private void onVisible() {
        this.setDefaultButton();
        if (this.btnOK.getAction() == null) {
            this.btnOK.setVisible(false);
        }
    }

    protected void setMessageText(String msg) {
        this.messageLabel.setText(msg);
    }

    public final void setStatusStr(String statusStr) {
        this.m_statusBar.setStatusStr(statusStr);
    }

    protected boolean isStatusBarInUse() {
        return this.m_useStatusBar;
    }

    public void setWaitCursor() {
        this.getGlassPane().addMouseListener(this.m_mouseListenerForGlassPane);
        this.getGlassPane().setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        this.getGlassPane().removeMouseListener(this.m_mouseListenerForGlassPane);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        SrSwingUtils.setWindowMinimumWidthByTitle(this, title);
    }
}

