/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.ToolBarListener;
import com.sanrad.swing.ToolBarPanel;
import com.sanrad.swing.UpperPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public abstract class FrameView
extends JFrame
implements ToolBarListener {
    protected static final String STATUS_READY = "Ready";
    protected UpperPanel upperPanel = new UpperPanel();
    private SrPanel topPanel = new SrPanel();
    private SrPanel mainPanel = new SrPanel();

    protected FrameView() {
        this(true);
    }

    protected FrameView(boolean aAddUpperPanel) {
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.upperPanel.setLayout(new FlowLayout(0));
        this.upperPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.setLayout(new BorderLayout());
        if (aAddUpperPanel) {
            this.topPanel.add((Component)this.upperPanel, "North");
        }
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.topPanel, "Center");
        SrPanel buttonsPanel = this.createButtonsPanel();
        if (buttonsPanel != null) {
            this.getContentPane().add((Component)buttonsPanel, "South");
        }
        StatusPanel.getInstance().setText(STATUS_READY, StatusPanel.INFO, this);
    }

    protected FrameView(String viewTitle) {
        this();
        this.setViewTitle(viewTitle, true);
    }

    protected FrameView(String viewTitle, Image icon) {
        this(viewTitle);
        this.setIconImage(icon);
    }

    protected SrPanel createButtonsPanel() {
        return null;
    }

    protected void addToolBarPanel(ToolBarPanel toolBarPanel) {
        if (this instanceof ToolBarListener) {
            this.upperPanel.addToolBarPanel(toolBarPanel, this);
        } else {
            System.err.println(this.getClass() + " is not instance of ToolBarListener in " + this.getClass() + "::addToolBarPanel()");
        }
    }

    protected void removeToolBarPanel(ToolBarPanel toolBarPanel) {
        this.upperPanel.removeToolBarPanel(this);
    }

    protected void setToolBarPanel(ToolBarPanel toolBarPanel) {
        this.upperPanel.setToolBarPanel(toolBarPanel, this);
    }

    protected SrPanel getMainPanel() {
        return this.mainPanel;
    }

    protected void setStatusLabel(String message) {
        StatusPanel.getInstance().setText(message, this);
    }

    protected void setViewTitle(String title, boolean isToolbarShown) {
        if (isToolbarShown) {
            this.upperPanel.setViewTitle(title);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        final boolean fVisible = visible;
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                FrameView.this.setItVisible(fVisible);
            }
        });
    }

    private void setItVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void show() {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                FrameView.this.letItShow();
            }
        });
    }

    private void letItShow() {
        super.show();
    }
}

