/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.SwingUtilities;

public class EventDispatcherTask
implements Runnable {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private Runnable myRunnable;
    private static Queue<Runnable> theQueue = new LinkedList<Runnable>();
    private static boolean theIsIdle = true;

    private EventDispatcherTask(Runnable aRunnable) {
        this.myRunnable = aRunnable;
    }

    @Override
    public void run() {
        try {
            this.myRunnable.run();
        }
        catch (Throwable th) {
            theLogger.logAndAssert(SrLogCategories.ERROR, th, "Caught a throwable during task execution.");
            throw new IllegalStateException("Caught a throwable during task execution.", th);
        }
        finally {
            EventDispatcherTask.invokeNext();
        }
    }

    public static synchronized void submit(Runnable aRunnable) {
        theQueue.add(aRunnable);
        if (!theIsIdle) {
            return;
        }
        EventDispatcherTask.invokeNext();
    }

    private static synchronized void invokeNext() {
        if (theQueue.isEmpty()) {
            theIsIdle = true;
            return;
        }
        theIsIdle = false;
        SwingUtilities.invokeLater(new EventDispatcherTask(theQueue.remove()));
    }
}

