/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.udp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.udp.SrUDPStatisticChart;
import com.sanrad.nms.client.gui.vswitch.statistics.udp.SrUDPStatisticsDetailsPanel;
import com.sanrad.nms.client.gui.vswitch.statistics.udp.SrUPDListenerTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.SrAction;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;

public class UDPStatisticsDialog
extends SrStatisticsDialog
implements UDPStatisticsListener {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_DIALOG_SPECIFIC_TITLE);

    public UDPStatisticsDialog(JFrame owner, VSwitchNode vswitchNode) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + vswitchNode.getName() + ": " + DIALOG_SPECIFIC_TITLE, vswitchNode);
        SrAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getUDPStatistics(), true)), this);
        this.setSize(650, 650);
    }

    @Override
    public void doOnCancel() {
        SrAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getUDPStatistics(), false)), this);
        UDPStatisticsManager.getInstance().clearStatisticNodeParamsList(this.getVswitchNode());
    }

    @Override
    protected void initDialogPanels() {
    }

    private SrUDPStatisticsDetailsPanel createUDPStatisticsDetailsPanel() {
        SrUDPStatisticsDetailsPanel panel = new SrUDPStatisticsDetailsPanel();
        return panel;
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return new SrUPDListenerTablePanel(this.m_vswitchNode);
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        return this.createUDPStatisticsDetailsPanel();
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        return null;
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        this.m_statisticChart = new SrUDPStatisticChart(this.m_vswitchNode.getStatisticsPollInterval());
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void addListeners() {
        UDPStatisticsManager.getInstance().addUDPStatisticsListener(this);
    }

    @Override
    public void removeListeners() {
        UDPStatisticsManager.getInstance().removeUDPStatisticsListener(this);
    }
}

