/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.udp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;

public class SrUDPStatisticsDetailsPanel
extends SrPanel
implements UDPStatisticsListener {
    private SrClientLabel m_datagramsReceivedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_DETAILES_DATAGRAMS_RECEIVED));
    private SrClientLabel m_datagramsReceivedValueLabel = new SrClientLabel("0");
    private SrClientLabel m_datagramsSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_DETAILES_DATAGRAMS_SENT));
    private SrClientLabel m_datagramsSentValueLabel = new SrClientLabel("0");
    private SrClientLabel m_errorsDatagramsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_DETAILES_ERRORS_DATAGRAMS));
    private SrClientLabel m_errorsDatagramsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_wrongPortDatagramsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_DETAILES_WRONG_PORT_DATAGRAMS));
    private SrClientLabel m_wrongPortDatagramsValueLabel = new SrClientLabel("0");

    public SrUDPStatisticsDetailsPanel() {
        UDPStatisticsManager.getInstance().addUDPStatisticsListener(this);
        this.initPanelComponents();
    }

    @Override
    public void removeListeners() {
        UDPStatisticsManager.getInstance().removeUDPStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_wrongPortDatagramsLabel.getPreferredSize();
        dim.width += 20;
        this.m_datagramsReceivedLabel.setPreferredSize(dim);
        this.m_wrongPortDatagramsLabel.setPreferredSize(dim);
        this.m_errorsDatagramsLabel.setPreferredSize(dim);
        this.m_datagramsSentLabel.setPreferredSize(dim);
        return dim;
    }

    private void buildAllPanels(Dimension usedDim) {
        SrPanel panel = this.buildCountersPanel(usedDim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        SrPanel panel = new SrPanel(new BorderLayout(0, 0));
        panel.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        panel.add(label);
        if (panelAll == null) {
            this.add((Component)panel, c);
        } else {
            panelAll.add((Component)panel, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        this.addDetailRow(panel, this.m_datagramsReceivedLabel, whiteBackground, c, 0, 0, new Insets(5, 10, 5, 0));
        this.addDetailRow(panel, this.m_datagramsReceivedValueLabel, whiteBackground, c, 1, 0, new Insets(5, 0, 5, 10));
        this.addDetailRow(panel, this.m_datagramsSentLabel, whiteBackground, c, 0, 1, new Insets(0, 10, 5, 0));
        this.addDetailRow(panel, this.m_errorsDatagramsLabel, whiteBackground, c, 0, 2, null);
        this.addDetailRow(panel, this.m_wrongPortDatagramsLabel, whiteBackground, c, 0, 3, null);
        this.addDetailRow(panel, this.m_datagramsSentValueLabel, whiteBackground, c, 1, 1, new Insets(0, 0, 5, 10));
        this.addDetailRow(panel, this.m_errorsDatagramsValueLabel, whiteBackground, c, 1, 2, null);
        this.addDetailRow(panel, this.m_wrongPortDatagramsValueLabel, whiteBackground, c, 1, 3, null);
        return panel;
    }

    private void updateLabelFieldWithVal(HashMap statisticsValues, ClientParameterCode code, SrClientLabel label) {
        Object objVal = statisticsValues.get(code);
        if (objVal != null) {
            String text = ((BigInteger)objVal).toString();
            label.setText(text);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap statisticsValues = e.getValuesMap();
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.UDP_STATISTICS_DATAGRAMS_RECEIVED, this.m_datagramsReceivedValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.UDP_STATISTICS_DATAGRAMS_SENT, this.m_datagramsSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.UDP_STATISTICS_ERRORS_DATAGRAMS, this.m_errorsDatagramsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.UDP_STATISTICS_WRONG_PORT_DATAGRAMS, this.m_wrongPortDatagramsValueLabel);
    }
}

