/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.udp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.util.Date;
import java.util.HashMap;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class SrUDPStatisticChart
extends SrStatisticChart
implements UDPStatisticsListener {
    private static final String SERIES_DATAGRAMS_RECEIVED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_CHART_DATAGRAMS_RECEIVED);
    private static final String SERIES_DATAGRAMS_SENT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_CHART_DATAGRAMS_SENT);
    private static final String SERIES_ERRORS_DATAGRAMS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_UDP_STATISTICS_CHART_ERRORS_DATAGRAMS);

    public SrUDPStatisticChart(int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_DATAGRAMS_RECEIVED);
        this.addSeries(SERIES_DATAGRAMS_SENT);
        this.addSeries(SERIES_ERRORS_DATAGRAMS);
        UDPStatisticsManager.getInstance().addUDPStatisticsListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap values = e.getValuesMap();
        Long dataReceived = (Long)values.get(ClientParameterCode.UDP_STATISTICS_DATAGRAMS_RECEIVED_PER_SEC);
        Long dataSent = (Long)values.get(ClientParameterCode.UDP_STATISTICS_DATAGRAMS_SENT_PER_SEC);
        Long errorData = (Long)values.get(ClientParameterCode.UDP_STATISTICS_ERRORS_DATAGRAMS_PER_SEC);
        Date time = new Date();
        if (dataReceived != null) {
            this.setSeriesValue(SERIES_DATAGRAMS_RECEIVED, time, dataReceived);
        }
        if (dataSent != null) {
            this.setSeriesValue(SERIES_DATAGRAMS_SENT, time, dataSent);
        }
        if (errorData != null) {
            this.setSeriesValue(SERIES_ERRORS_DATAGRAMS, time, errorData);
        }
    }

    @Override
    public void removeListeners() {
        UDPStatisticsManager.getInstance().removeUDPStatisticsListener(this);
    }

    @Override
    public ChartPanel packChartToPanel() {
        ChartPanel panel = super.packChartToPanel();
        XYPlot plot = panel.getChart().getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, ChartColor.LIGHT_RED);
        return panel;
    }
}

