/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.tcp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.tcp.SrTCPStatisticChart;
import com.sanrad.nms.client.gui.vswitch.statistics.tcp.SrTCPStatisticsConnectionsTablePanel;
import com.sanrad.nms.client.gui.vswitch.statistics.tcp.SrTCPStatisticsDetailsPanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.SrAction;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;

public class TCPStatisticsDialog
extends SrStatisticsDialog
implements TCPStatisticsListener {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DIALOG_SPECIFIC_TITLE);

    public TCPStatisticsDialog(JFrame owner, VSwitchNode vswitchNode) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + vswitchNode.getName() + ": " + DIALOG_SPECIFIC_TITLE, vswitchNode);
        SrAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getTCPStatistics(), true)), this);
        this.setSize(650, 650);
    }

    @Override
    public void doOnCancel() {
        SrAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getTCPStatistics(), false)), this);
        TCPStatisticsManager.getInstance().clearStatisticNodeParamsList(this.getVswitchNode());
    }

    @Override
    protected void initDialogPanels() {
    }

    private SrTCPStatisticsDetailsPanel createTCPStatisticsDetailsPanel() {
        SrTCPStatisticsDetailsPanel panel = new SrTCPStatisticsDetailsPanel();
        return panel;
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        return this.createTCPStatisticsDetailsPanel();
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return new SrTCPStatisticsConnectionsTablePanel(this.m_vswitchNode);
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        return null;
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        this.m_statisticChart = new SrTCPStatisticChart(this.m_vswitchNode.getStatisticsPollInterval());
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void addListeners() {
        TCPStatisticsManager.getInstance().addTCPStatisticsListener(this);
    }

    @Override
    public void removeListeners() {
        TCPStatisticsManager.getInstance().removeTCPStatisticsListener(this);
    }
}

