/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.tcp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;

public class SrTCPStatisticsDetailsPanel
extends SrPanel
implements TCPStatisticsListener {
    private SrClientLabel m_numOfCurrentConnectionsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_NUMBER_OF_CURRENT_CONNECTIONS));
    private SrClientLabel m_numOfCurrentConnectionsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_activeOpenLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_ACTIVE_OPEN));
    private SrClientLabel m_activeOpenValueLabel = new SrClientLabel("0");
    private SrClientLabel m_passiveOpenLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_PASSIVE_OPEN));
    private SrClientLabel m_passiveOpenValueLabel = new SrClientLabel("0");
    private SrClientLabel m_attemptFailureLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_ATTEMPT_FAILURE));
    private SrClientLabel m_attemptFailureValueLabel = new SrClientLabel("0");
    private SrClientLabel m_resetEstablishmentsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_RESET_ESTABLISHMENTS));
    private SrClientLabel m_resetEstablishmentsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_segmentsReceivedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_SEGMENTS_RECEIVED));
    private SrClientLabel m_segmentsReceivedValueLabel = new SrClientLabel("0");
    private SrClientLabel m_segmentsSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_SEGMENTS_SENT));
    private SrClientLabel m_segmentsSentValueLabel = new SrClientLabel("0");
    private SrClientLabel m_segmentsRetransmittedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_SEGMENTS_RETRANSMITTED));
    private SrClientLabel m_segmentsRetransmittedValueLabel = new SrClientLabel("0");
    private SrClientLabel m_errorsReceivedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_ERRORS_RECEIVED));
    private SrClientLabel m_errorsReceivedValueLabel = new SrClientLabel("0");
    private SrClientLabel m_resetSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_DETAILES_RESET_SENT));
    private SrClientLabel m_resetSentValueLabel = new SrClientLabel("0");

    public SrTCPStatisticsDetailsPanel() {
        TCPStatisticsManager.getInstance().addTCPStatisticsListener(this);
        this.initPanelComponents();
    }

    @Override
    public void removeListeners() {
        TCPStatisticsManager.getInstance().removeTCPStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_segmentsRetransmittedLabel.getPreferredSize();
        dim.width += 20;
        this.m_numOfCurrentConnectionsLabel.setPreferredSize(dim);
        this.m_activeOpenLabel.setPreferredSize(dim);
        this.m_passiveOpenLabel.setPreferredSize(dim);
        this.m_attemptFailureLabel.setPreferredSize(dim);
        this.m_resetEstablishmentsLabel.setPreferredSize(dim);
        this.m_segmentsReceivedLabel.setPreferredSize(dim);
        this.m_segmentsSentLabel.setPreferredSize(dim);
        this.m_segmentsRetransmittedLabel.setPreferredSize(dim);
        this.m_errorsReceivedLabel.setPreferredSize(dim);
        this.m_resetSentLabel.setPreferredSize(dim);
        return dim;
    }

    private void buildAllPanels(Dimension usedDim) {
        SrPanel panel = this.buildCountersPanel(usedDim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        SrPanel panel = new SrPanel(new BorderLayout(0, 0));
        panel.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        panel.add(label);
        if (panelAll == null) {
            this.add((Component)panel, c);
        } else {
            panelAll.add((Component)panel, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        this.addDetailRow(panel, this.m_numOfCurrentConnectionsLabel, whiteBackground, c, 0, 0, new Insets(5, 10, 5, 0));
        this.addDetailRow(panel, this.m_numOfCurrentConnectionsValueLabel, whiteBackground, c, 1, 0, new Insets(5, 0, 5, 10));
        this.addDetailRow(panel, this.m_activeOpenLabel, whiteBackground, c, 0, 1, new Insets(0, 10, 5, 0));
        this.addDetailRow(panel, this.m_passiveOpenLabel, whiteBackground, c, 0, 2, null);
        this.addDetailRow(panel, this.m_attemptFailureLabel, whiteBackground, c, 0, 3, null);
        this.addDetailRow(panel, this.m_resetEstablishmentsLabel, whiteBackground, c, 0, 4, null);
        this.addDetailRow(panel, this.m_segmentsReceivedLabel, whiteBackground, c, 0, 5, null);
        this.addDetailRow(panel, this.m_segmentsSentLabel, whiteBackground, c, 0, 6, null);
        this.addDetailRow(panel, this.m_segmentsRetransmittedLabel, whiteBackground, c, 0, 7, null);
        this.addDetailRow(panel, this.m_errorsReceivedLabel, whiteBackground, c, 0, 8, null);
        this.addDetailRow(panel, this.m_resetSentLabel, whiteBackground, c, 0, 9, null);
        this.addDetailRow(panel, this.m_activeOpenValueLabel, whiteBackground, c, 1, 1, new Insets(0, 0, 5, 10));
        this.addDetailRow(panel, this.m_passiveOpenValueLabel, whiteBackground, c, 1, 2, null);
        this.addDetailRow(panel, this.m_attemptFailureValueLabel, whiteBackground, c, 1, 3, null);
        this.addDetailRow(panel, this.m_resetEstablishmentsValueLabel, whiteBackground, c, 1, 4, null);
        this.addDetailRow(panel, this.m_segmentsReceivedValueLabel, whiteBackground, c, 1, 5, null);
        this.addDetailRow(panel, this.m_segmentsSentValueLabel, whiteBackground, c, 1, 6, null);
        this.addDetailRow(panel, this.m_segmentsRetransmittedValueLabel, whiteBackground, c, 1, 7, null);
        this.addDetailRow(panel, this.m_errorsReceivedValueLabel, whiteBackground, c, 1, 8, null);
        this.addDetailRow(panel, this.m_resetSentValueLabel, whiteBackground, c, 1, 9, null);
        return panel;
    }

    private void updateLabelFieldWithVal(HashMap statisticsValues, ClientParameterCode code, SrClientLabel label) {
        Object objVal = statisticsValues.get(code);
        if (objVal != null) {
            String text = ((BigInteger)objVal).toString();
            label.setText(text);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap statisticsValues = e.getValuesMap();
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_NUM_OF_CONNECTIONS, this.m_numOfCurrentConnectionsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_ACTIVE_OPEN, this.m_activeOpenValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_PASSIVE_OPEN, this.m_passiveOpenValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_ATTEMPT_FAILURE, this.m_attemptFailureValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_RESET_ESTABLISHMENTS, this.m_resetEstablishmentsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_SEGMENTS_RECEIVED, this.m_segmentsReceivedValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_SEGMENTS_SENT, this.m_segmentsSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_SEGMENTS_RETRANSMITTED, this.m_segmentsRetransmittedValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_ERRORS_RECEIVED, this.m_errorsReceivedValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.TCP_STATISTICS_RESET_SENT, this.m_resetSentValueLabel);
    }
}

