/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.tcp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.util.Date;
import java.util.HashMap;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class SrTCPStatisticChart
extends SrStatisticChart
implements TCPStatisticsListener {
    private static final String SERIES_SEGMENTS_RECEIVED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_CHART_SEGMENTS_RECEIVED);
    private static final String SERIES_SEGMENTS_SENT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_CHART_SEGMENTS_SENT);
    private static final String SERIES_ERRORS_RECEIVED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_CHART_ERRORS_RECEIVED);
    private static final String SERIES_SEGMENTS_RETRANSMITTED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TCP_STATISTICS_CHART_SEGMENTS_RETRANSMITTED);

    public SrTCPStatisticChart(int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_SEGMENTS_RECEIVED);
        this.addSeries(SERIES_SEGMENTS_RETRANSMITTED);
        this.addSeries(SERIES_SEGMENTS_SENT);
        this.addSeries(SERIES_ERRORS_RECEIVED);
        TCPStatisticsManager.getInstance().addTCPStatisticsListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap values = e.getValuesMap();
        Long segReceived = (Long)values.get(ClientParameterCode.TCP_STATISTICS_SEGMENTS_RECEIVED_PER_SEC);
        Long segSent = (Long)values.get(ClientParameterCode.TCP_STATISTICS_SEGMENTS_SENT_PER_SEC);
        Long segRetransmitted = (Long)values.get(ClientParameterCode.TCP_STATISTICS_SEGMENTS_RETRANSMITTED_PER_SEC);
        Long errorRecived = (Long)values.get(ClientParameterCode.TCP_STATISTICS_ERRORS_RECEIVED_PER_SEC);
        Date time = new Date();
        if (segReceived != null) {
            this.setSeriesValue(SERIES_SEGMENTS_RECEIVED, time, segReceived);
        }
        if (segRetransmitted != null) {
            this.setSeriesValue(SERIES_SEGMENTS_RETRANSMITTED, time, segRetransmitted);
        }
        if (segSent != null) {
            this.setSeriesValue(SERIES_SEGMENTS_SENT, time, segSent);
        }
        if (errorRecived != null) {
            this.setSeriesValue(SERIES_ERRORS_RECEIVED, time, errorRecived);
        }
    }

    @Override
    public void removeListeners() {
        TCPStatisticsManager.getInstance().removeTCPStatisticsListener(this);
    }

    @Override
    public ChartPanel packChartToPanel() {
        ChartPanel panel = super.packChartToPanel();
        XYPlot plot = panel.getChart().getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(3, ChartColor.LIGHT_RED);
        return panel;
    }
}

