/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.ip;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.ip.IPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;

public class SrIPStatisticsDetailsPanel
extends SrPanel
implements IPStatisticsListener {
    private SrClientLabel m_inReceivesLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_RECEIVES));
    private SrClientLabel m_inReceivesValueLabel = new SrClientLabel("0");
    private SrClientLabel m_inHeaderErrorsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_HEADER_ERRORS));
    private SrClientLabel m_inHeaderErrorsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_inAddressErrorsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_ADDRESS_ERRORS));
    private SrClientLabel m_inAddressErrorsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_inUnknownProtosLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_UNKNOWN_PROTOS));
    private SrClientLabel m_inUnknownProtosValueLabel = new SrClientLabel("0");
    private SrClientLabel m_inDiscardsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_DISCARDS));
    private SrClientLabel m_inDiscardsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_inDeliversLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_IN_DELIVERS));
    private SrClientLabel m_inDeliversValueLabel = new SrClientLabel("0");
    private SrClientLabel m_outRequestsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_OUT_REQUESTS));
    private SrClientLabel m_outRequestsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_outDiscardsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_OUT_DISCARDS));
    private SrClientLabel m_outDiscardsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_outNoRoutesLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_OUT_NO_ROUTES));
    private SrClientLabel m_outNoRoutesValueLabel = new SrClientLabel("0");
    private SrClientLabel m_reasmFragmentsReceivedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_REASM_FRAGMENTS_RECEIVED));
    private SrClientLabel m_reasmFragmentsReceivedValueLabel = new SrClientLabel("0");
    private SrClientLabel m_reasmFragmentsOkLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_REASM_FRAGMENTS_OK));
    private SrClientLabel m_reasmFragmentsOkValueLabel = new SrClientLabel("0");
    private SrClientLabel m_reasmFragmentsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_REASM_FRAGMENTS));
    private SrClientLabel m_reasmFragmentsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_fragmentsOkLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_FRAGMENTS_OK));
    private SrClientLabel m_fragmentsOkValueLabel = new SrClientLabel("0");
    private SrClientLabel m_failedToFragmentsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_FAILED_TO_FRAGMENTS));
    private SrClientLabel m_failedToFragmentsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_numberGeneratedFragmentsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_NUMBER_GENERATED_FRAGMENTS));
    private SrClientLabel m_numberGeneratedFragmentsValueLabel = new SrClientLabel("0");
    private SrClientLabel m_routingDiscardsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_DETAILES_ROUTING_DISCRADS));
    private SrClientLabel m_routingDiscardsValueLabel = new SrClientLabel("0");

    public SrIPStatisticsDetailsPanel() {
        IPStatisticsManager.getInstance().addIPStatisticsListener(this);
        this.initPanelComponents();
    }

    @Override
    public void removeListeners() {
        IPStatisticsManager.getInstance().removeIPStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_numberGeneratedFragmentsLabel.getPreferredSize();
        dim.width += 20;
        this.m_inReceivesLabel.setPreferredSize(dim);
        this.m_inHeaderErrorsLabel.setPreferredSize(dim);
        this.m_inAddressErrorsLabel.setPreferredSize(dim);
        this.m_inUnknownProtosLabel.setPreferredSize(dim);
        this.m_inDiscardsLabel.setPreferredSize(dim);
        this.m_inDeliversLabel.setPreferredSize(dim);
        this.m_outRequestsLabel.setPreferredSize(dim);
        this.m_outDiscardsLabel.setPreferredSize(dim);
        this.m_outNoRoutesLabel.setPreferredSize(dim);
        this.m_reasmFragmentsReceivedLabel.setPreferredSize(dim);
        this.m_reasmFragmentsOkLabel.setPreferredSize(dim);
        this.m_reasmFragmentsLabel.setPreferredSize(dim);
        this.m_fragmentsOkLabel.setPreferredSize(dim);
        this.m_failedToFragmentsLabel.setPreferredSize(dim);
        this.m_numberGeneratedFragmentsLabel.setPreferredSize(dim);
        this.m_routingDiscardsLabel.setPreferredSize(dim);
        return dim;
    }

    private void buildAllPanels(Dimension usedDim) {
        SrPanel panel = this.buildCountersPanel(usedDim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        SrPanel panel = new SrPanel(new BorderLayout(0, 0));
        panel.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        panel.add(label);
        if (panelAll == null) {
            this.add((Component)panel, c);
        } else {
            panelAll.add((Component)panel, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        this.addDetailRow(panel, this.m_inReceivesLabel, whiteBackground, c, 0, 0, new Insets(5, 10, 5, 0));
        this.addDetailRow(panel, this.m_inReceivesValueLabel, whiteBackground, c, 1, 0, new Insets(5, 0, 5, 10));
        this.addDetailRow(panel, this.m_inHeaderErrorsLabel, whiteBackground, c, 0, 1, new Insets(0, 10, 5, 0));
        this.addDetailRow(panel, this.m_inAddressErrorsLabel, whiteBackground, c, 0, 2, null);
        this.addDetailRow(panel, this.m_inUnknownProtosLabel, whiteBackground, c, 0, 3, null);
        this.addDetailRow(panel, this.m_inDiscardsLabel, whiteBackground, c, 0, 4, null);
        this.addDetailRow(panel, this.m_inDeliversLabel, whiteBackground, c, 0, 5, null);
        this.addDetailRow(panel, this.m_outRequestsLabel, whiteBackground, c, 0, 6, null);
        this.addDetailRow(panel, this.m_outDiscardsLabel, whiteBackground, c, 0, 7, null);
        this.addDetailRow(panel, this.m_outNoRoutesLabel, whiteBackground, c, 0, 8, null);
        this.addDetailRow(panel, this.m_reasmFragmentsReceivedLabel, whiteBackground, c, 0, 9, null);
        this.addDetailRow(panel, this.m_reasmFragmentsOkLabel, whiteBackground, c, 0, 10, null);
        this.addDetailRow(panel, this.m_reasmFragmentsLabel, whiteBackground, c, 0, 11, null);
        this.addDetailRow(panel, this.m_fragmentsOkLabel, whiteBackground, c, 0, 12, null);
        this.addDetailRow(panel, this.m_failedToFragmentsLabel, whiteBackground, c, 0, 13, null);
        this.addDetailRow(panel, this.m_numberGeneratedFragmentsLabel, whiteBackground, c, 0, 14, null);
        this.addDetailRow(panel, this.m_routingDiscardsLabel, whiteBackground, c, 0, 15, null);
        this.addDetailRow(panel, this.m_inHeaderErrorsValueLabel, whiteBackground, c, 1, 1, new Insets(0, 0, 5, 10));
        this.addDetailRow(panel, this.m_inAddressErrorsValueLabel, whiteBackground, c, 1, 2, null);
        this.addDetailRow(panel, this.m_inUnknownProtosValueLabel, whiteBackground, c, 1, 3, null);
        this.addDetailRow(panel, this.m_inDiscardsValueLabel, whiteBackground, c, 1, 4, null);
        this.addDetailRow(panel, this.m_inDeliversValueLabel, whiteBackground, c, 1, 5, null);
        this.addDetailRow(panel, this.m_outRequestsValueLabel, whiteBackground, c, 1, 6, null);
        this.addDetailRow(panel, this.m_outDiscardsValueLabel, whiteBackground, c, 1, 7, null);
        this.addDetailRow(panel, this.m_outNoRoutesValueLabel, whiteBackground, c, 1, 8, null);
        this.addDetailRow(panel, this.m_reasmFragmentsReceivedValueLabel, whiteBackground, c, 1, 9, null);
        this.addDetailRow(panel, this.m_reasmFragmentsOkValueLabel, whiteBackground, c, 1, 10, null);
        this.addDetailRow(panel, this.m_reasmFragmentsValueLabel, whiteBackground, c, 1, 11, null);
        this.addDetailRow(panel, this.m_fragmentsOkValueLabel, whiteBackground, c, 1, 12, null);
        this.addDetailRow(panel, this.m_failedToFragmentsValueLabel, whiteBackground, c, 1, 13, null);
        this.addDetailRow(panel, this.m_numberGeneratedFragmentsValueLabel, whiteBackground, c, 1, 14, null);
        this.addDetailRow(panel, this.m_routingDiscardsValueLabel, whiteBackground, c, 1, 15, null);
        return panel;
    }

    private void updateLabelFieldWithVal(HashMap statisticsValues, ClientParameterCode code, SrClientLabel label) {
        Object objVal = statisticsValues.get(code);
        if (objVal != null) {
            String text = ((BigInteger)objVal).toString();
            label.setText(text);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap statisticsValues = e.getValuesMap();
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_RECEIVED, this.m_inReceivesValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_HEADER_ERRORS, this.m_inHeaderErrorsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_ADDRESS_ERRORS, this.m_inAddressErrorsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_UNKNOWN_PROTOCOLS, this.m_inUnknownProtosValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_DISCARDS, this.m_inDiscardsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_IN_DELIVERS, this.m_inDeliversValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_OUT_REQUESTS, this.m_outRequestsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_OUT_DISCARDS, this.m_outDiscardsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_OUT_NO_ROUTES, this.m_outNoRoutesValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_REASSEMBLED_FRAGMENTS_RECEIVED, this.m_reasmFragmentsReceivedValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_REASSEMBLED_FRAGMENTS_OK, this.m_reasmFragmentsOkValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_REASSEMBLED_FRAGMENTS, this.m_reasmFragmentsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_FRAGMENTS_OK, this.m_fragmentsOkValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_FAILED_TO_FRAGMENT, this.m_failedToFragmentsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_FRAGMENTS_GENERATED, this.m_numberGeneratedFragmentsValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.IP_STATISTICS_ROUTING_DISCARDS, this.m_routingDiscardsValueLabel);
    }
}

