/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.ip;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.ip.IPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.util.Date;
import java.util.HashMap;

public class SrIPStatisticChart
extends SrStatisticChart
implements IPStatisticsListener {
    private static final String SERIES_IN_RECEIVED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_CHART_IN_RECEIVED);
    private static final String SERIES_IN_DELIVERS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_CHART_IN_DELIVERS);
    private static final String SERIES_OUT_REQUESTS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IP_STATISTICS_CHART_OUT_REQUESTS);

    public SrIPStatisticChart(int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_IN_RECEIVED);
        this.addSeries(SERIES_IN_DELIVERS);
        this.addSeries(SERIES_OUT_REQUESTS);
        IPStatisticsManager.getInstance().addIPStatisticsListener(this);
    }

    @Override
    public void removeListeners() {
        IPStatisticsManager.getInstance().removeIPStatisticsListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap values = e.getValuesMap();
        Long inReceived = (Long)values.get(ClientParameterCode.IP_STATISTICS_IN_RECEIVES_PER_SEC);
        Long inDelivers = (Long)values.get(ClientParameterCode.IP_STATISTICS_IN_DELIVERS_PER_SEC);
        Long outRequests = (Long)values.get(ClientParameterCode.IP_STATISTICS_OUT_REQUESTS_PER_SEC);
        Date time = new Date();
        if (inReceived != null) {
            this.setSeriesValue(SERIES_IN_RECEIVED, time, inReceived);
        }
        if (inDelivers != null) {
            this.setSeriesValue(SERIES_IN_DELIVERS, time, inDelivers);
        }
        if (outRequests != null) {
            this.setSeriesValue(SERIES_OUT_REQUESTS, time, outRequests);
        }
    }
}

