/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.interfaces;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.SrInterfacesStatisticsTableModel;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfaceStatisticsRowSelectionEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfaceStatisticsRowSelectionListener;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfacesStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.InterfacesStatisticsTableHeader;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.SrInterfacesStatisticsTablePanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.StorageSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class SrInterfacesStatisticsDetailsPanel
extends SrPanel
implements InterfaceStatisticsRowSelectionListener,
InterfacesStatisticsListener {
    private String NO_VALUES = "NA/NA";
    private SrInterfacesStatisticsTablePanel m_interfacesStatisticsTablePanel;
    private SrClientLabel m_detailPanelTitleLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES));
    private SrClientLabel m_interfaceAliasLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_ALIAS));
    private SrClientLabel m_interfaceAliasValueLabel = new SrClientLabel("---");
    private SrClientLabel m_discontinuityLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_DISCONTINUITY));
    private SrClientLabel m_discontinuityValueLabel = new SrClientLabel("NA");
    private SrClientLabel m_octetsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_OCTETS_IN_OUT));
    private SrClientLabel m_octetsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_unicastPacketsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_UNICAST_PKTS_IN_OUT));
    private SrClientLabel m_unicastPacketsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_discardsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_DISCARDS_IN_OUT));
    private SrClientLabel m_discardsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_errorsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_ERRORS_IN_OUT));
    private SrClientLabel m_errorsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_multicastPacketsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_MULTICAST_PKTS_IN_OUT));
    private SrClientLabel m_multicastPacketsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_broadcastPacketsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_BROADCAST_PKTS_IN_OUT));
    private SrClientLabel m_broadcastPacketsInOutValueLabel = new SrClientLabel(this.NO_VALUES);
    private SrClientLabel m_unknownProtocolsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DETAILES_UNKNOWN_PROTOS_IN_OUT));
    private InterfacesStatisticsNode m_currDisplayedInterfaceRow;
    private boolean m_firstStatisticChangeEvent = true;

    public SrInterfacesStatisticsDetailsPanel(SrInterfacesStatisticsTablePanel interfacesStatisticsTablePanel) {
        this.m_interfacesStatisticsTablePanel = interfacesStatisticsTablePanel;
        this.m_interfacesStatisticsTablePanel.addInterfaceSelectionListener(this);
        InterfacesStatisticsManager.getInstance().addInterfacesStatisticsListener(this);
        this.initPanelComponents();
    }

    public void initFirst() {
        if (this.m_interfacesStatisticsTablePanel.getTable().getRowCount() > 0) {
            this.m_interfacesStatisticsTablePanel.getTable().changeSelection(0, 1, false, true);
            SrInterfacesStatisticsTableModel model = (SrInterfacesStatisticsTableModel)this.m_interfacesStatisticsTablePanel.getTable().getModel();
            int aliasCol = model.getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
            AliasObject alias = (AliasObject)model.getValueAt(0, aliasCol);
            this.m_interfaceAliasValueLabel.setText((String)alias.getValue());
        }
    }

    @Override
    public void removeListeners() {
        this.m_interfacesStatisticsTablePanel.removeInterfaceSelectionListener(this);
        InterfacesStatisticsManager.getInstance().removeInterfacesStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.setLookAndFillOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_unknownProtocolsInOutLabel.getPreferredSize();
        dim.width += 20;
        this.m_interfaceAliasLabel.setPreferredSize(dim);
        this.m_discontinuityLabel.setPreferredSize(dim);
        this.m_octetsInOutLabel.setPreferredSize(dim);
        this.m_unicastPacketsInOutLabel.setPreferredSize(dim);
        this.m_discardsInOutLabel.setPreferredSize(dim);
        this.m_errorsInOutLabel.setPreferredSize(dim);
        this.m_multicastPacketsInOutLabel.setPreferredSize(dim);
        this.m_broadcastPacketsInOutLabel.setPreferredSize(dim);
        this.m_unknownProtocolsInOutLabel.setPreferredSize(dim);
        return dim;
    }

    private void setLookAndFillOfComponents() {
        Font titleFont = Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT));
        this.m_detailPanelTitleLabel.setFont(titleFont);
    }

    private void buildAllPanels(Dimension usedDim) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        Color dialogBackground = LookAndFill.DIALOG_COLOR;
        this.addDetailRow(null, this.m_detailPanelTitleLabel, dialogBackground, c, 0, 0, new Insets(10, 10, 0, 0));
        SrPanel panel = this.buildCountersPanel(usedDim);
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        label.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        if (panelAll == null) {
            this.add((Component)label, c);
        } else {
            panelAll.add((Component)label, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        Insets inserts = new Insets(2, 2, 2, 2);
        this.addDetailRow(panel, this.m_interfaceAliasLabel, whiteBackground, c, 0, 0, inserts);
        this.addDetailRow(panel, this.m_interfaceAliasValueLabel, whiteBackground, c, 1, 0, inserts);
        this.addDetailRow(panel, this.m_discontinuityLabel, whiteBackground, c, 0, 1, inserts);
        this.addDetailRow(panel, this.m_octetsInOutLabel, whiteBackground, c, 0, 2, inserts);
        this.addDetailRow(panel, this.m_unicastPacketsInOutLabel, whiteBackground, c, 0, 3, inserts);
        this.addDetailRow(panel, this.m_discardsInOutLabel, whiteBackground, c, 0, 4, inserts);
        this.addDetailRow(panel, this.m_errorsInOutLabel, whiteBackground, c, 0, 5, inserts);
        this.addDetailRow(panel, this.m_multicastPacketsInOutLabel, whiteBackground, c, 0, 6, inserts);
        this.addDetailRow(panel, this.m_broadcastPacketsInOutLabel, whiteBackground, c, 0, 7, inserts);
        this.addDetailRow(panel, this.m_discontinuityValueLabel, whiteBackground, c, 1, 1, inserts);
        this.addDetailRow(panel, this.m_octetsInOutValueLabel, whiteBackground, c, 1, 2, inserts);
        this.addDetailRow(panel, this.m_unicastPacketsInOutValueLabel, whiteBackground, c, 1, 3, inserts);
        this.addDetailRow(panel, this.m_discardsInOutValueLabel, whiteBackground, c, 1, 4, inserts);
        this.addDetailRow(panel, this.m_errorsInOutValueLabel, whiteBackground, c, 1, 5, inserts);
        this.addDetailRow(panel, this.m_multicastPacketsInOutValueLabel, whiteBackground, c, 1, 6, inserts);
        this.addDetailRow(panel, this.m_broadcastPacketsInOutValueLabel, whiteBackground, c, 1, 7, inserts);
        return panel;
    }

    public void interfaceStatisticsRowSelected(InterfacesStatisticsNode interfaceStatisticsTableRowNode, AliasObject selectedAlias) {
        this.m_currDisplayedInterfaceRow = interfaceStatisticsTableRowNode;
        this.initInterfaceStatistics(interfaceStatisticsTableRowNode);
    }

    public synchronized void initInterfaceStatistics(InterfacesStatisticsNode interfaceStatisticsTableRowNode) {
        this.showInterfaceStatistics(interfaceStatisticsTableRowNode, interfaceStatisticsTableRowNode.getAllSetOfValuesForInterface());
    }

    public synchronized void showInterfaceStatistics(InterfacesStatisticsNode interfaceStatisticsTableRowNode, HashMap values) {
        this.setAliasValueLabel(interfaceStatisticsTableRowNode.interfaceAlias());
        HashMap statisticsValues = values == null ? interfaceStatisticsTableRowNode.getChangedValues() : values;
        String type = interfaceStatisticsTableRowNode.getInterfaceType();
        boolean isPSCSIInterface = type.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI.getDescriptionName());
        boolean isFCInterface = type.equals(IANAifTypeConstant.IANA_IF_TYPE_FC.getDescriptionName());
        Long discontinuityValue = (Long)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_DISCONTINUITY_TIME);
        if (discontinuityValue != null) {
            this.m_discontinuityValueLabel.setText(new Date(discontinuityValue).toString());
        }
        if (!isPSCSIInterface) {
            this.rebuildGuiValsInMbit((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_OCTETS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_OCTETS), this.m_octetsInOutValueLabel);
            this.rebuildGuiVals((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_ERRORS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_ERRORS), this.m_errorsInOutValueLabel);
        } else {
            this.m_octetsInOutValueLabel.setText(this.NO_VALUES);
            this.m_errorsInOutValueLabel.setText(this.NO_VALUES);
        }
        if (!isPSCSIInterface && !isFCInterface) {
            this.rebuildGuiValsInM((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_UNICAST_PACKETS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_UNICAST_PACKETS), this.m_unicastPacketsInOutValueLabel);
            this.rebuildGuiVals((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_DISCARDS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_DISCARDS), this.m_discardsInOutValueLabel);
            this.rebuildGuiVals((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_MULTICAST_PACKETS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_MULTICAST_PACKETS), this.m_multicastPacketsInOutValueLabel);
            this.rebuildGuiVals((BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_IN_BROADCAST_PACKETS), (BigInteger)statisticsValues.get(ClientParameterCode.IFC_STATISTICS_OUT_BROADCAST_PACKETS), this.m_broadcastPacketsInOutValueLabel);
        } else {
            this.m_unicastPacketsInOutValueLabel.setText(this.NO_VALUES);
            this.m_discardsInOutValueLabel.setText(this.NO_VALUES);
            this.m_multicastPacketsInOutValueLabel.setText(this.NO_VALUES);
            this.m_broadcastPacketsInOutValueLabel.setText(this.NO_VALUES);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        InterfacesStatisticsNode statisticsNode = (InterfacesStatisticsNode)e.getStatisticsNode();
        if (this.m_firstStatisticChangeEvent) {
            int aliasCol = this.m_interfacesStatisticsTablePanel.getModel().getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
            AliasObject alias = (AliasObject)this.m_interfacesStatisticsTablePanel.getModel().getValueAt(this.m_interfacesStatisticsTablePanel.getSelectedRow(), aliasCol);
            Vector interfacesStatisticsTableNodes = ((SrInterfacesStatisticsTableModel)this.m_interfacesStatisticsTablePanel.getModel()).getInterfacesStatisticsTableNodes();
            for (int index1 = 0; index1 < interfacesStatisticsTableNodes.size(); ++index1) {
                InterfacesStatisticsNode row = (InterfacesStatisticsNode)interfacesStatisticsTableNodes.elementAt(index1);
                HashMap parmList = row.getChangedValues();
                if (parmList == null || !alias.getAdditionalValue().equals((InterfaceTableRow)parmList.get(ClientParameterCode.INTERFACE_ID))) continue;
                this.m_currDisplayedInterfaceRow = row;
                this.m_firstStatisticChangeEvent = false;
                break;
            }
        }
        if (this.m_currDisplayedInterfaceRow != null && this.m_currDisplayedInterfaceRow.equals(statisticsNode)) {
            this.showInterfaceStatistics(statisticsNode, null);
        }
    }

    private void rebuildGuiValsInMbit(BigInteger numberIn, BigInteger numberOut, SrClientLabel label) {
        if (numberIn == null || numberOut == null) {
            this.rebuildGuiVals(numberIn, numberOut, label);
            return;
        }
        BigInteger eight = new BigInteger("8");
        BigInteger newIn = numberIn.multiply(eight);
        BigInteger newOut = numberOut.multiply(eight);
        this.rebuildGuiValsInM(newIn, newOut, label);
    }

    private void rebuildGuiValsInM(BigInteger numberIn, BigInteger numberOut, SrClientLabel label) {
        if (numberIn == null || numberOut == null) {
            this.rebuildGuiVals(numberIn, numberOut, label);
            return;
        }
        BigDecimal mega = new BigDecimal(StorageSize.MEGA.getValue());
        BigDecimal inMb = new BigDecimal(numberIn);
        inMb = inMb.divide(mega, 3, 6);
        BigDecimal outMb = new BigDecimal(numberOut);
        outMb = outMb.divide(mega, 3, 6);
        this.rebuildGuiVals(inMb, outMb, label);
    }

    private void rebuildGuiVals(Number numberIn, Number numberOut, SrClientLabel label) {
        boolean currentIsNoVal = false;
        String currentGuiVal = label.getValue().toString();
        String currentIn = null;
        String currentOut = null;
        if (currentGuiVal.equals(this.NO_VALUES) || currentGuiVal.equals("NA")) {
            currentIsNoVal = true;
        } else {
            currentIn = currentGuiVal != null ? currentGuiVal.substring(0, currentGuiVal.indexOf(47)) : "";
            String string = currentOut = currentGuiVal != null ? currentGuiVal.substring(currentGuiVal.indexOf(47) + 1) : "";
        }
        if (numberIn != null || numberOut != null) {
            String newInVal = null;
            String newOutVal = null;
            if (currentIsNoVal) {
                newInVal = numberIn == null ? "NA" : numberIn.toString();
                newOutVal = numberOut == null ? "NA" : numberOut.toString();
            } else {
                newInVal = numberIn == null ? currentIn : numberIn.toString();
                newOutVal = numberOut == null ? currentOut : numberOut.toString();
            }
            currentGuiVal = newInVal + "/" + newOutVal;
            label.setText(currentGuiVal);
        }
    }

    public void setAliasValueLabel(String alias) {
        this.m_interfaceAliasValueLabel.setText(alias);
    }

    @Override
    public void interfaceStatisticsRowSelected(InterfaceStatisticsRowSelectionEvent event) {
        this.interfaceStatisticsRowSelected(event.getInterfaceStatisticsTableRow(), event.getSelectedAlias());
    }

    @Override
    public void aliasChanged(InterfaceStatisticsRowSelectionEvent event) {
        this.setAliasValueLabel(event.getSelectedAlias().toString());
    }
}

